/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.escalationcomposites;

import de.aristaflow.adept2.model.common.plugindata.DelegationMeasureData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.escalationcomposites.AbstractEscalationComposite;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogue;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueProvider;
import de.aristaflow.adept2.ui.sardialogue.StaffAssignmentRuleDialogueRegistry;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;

public class DelegationComposite
extends AbstractEscalationComposite {
    private Button unassignedDelegateToManagerButton;
    private Button assignedDelegateToManagerButton;
    private Button unassignedDelegateBySARButton;
    private Button assignedDelegateBySARButton;
    private Text assignedStaffAssignmentRule;
    private Text unassignedStaffAssignmentRule;
    private Text delegationComment;
    private Button unassignedStaffAssignmentButton;
    private Button assignedStaffAssignmentButton;

    public DelegationComposite(Composite parent, int style) {
        super(parent, style);
        this.createChildControls();
    }

    @Override
    protected void createChildControls() {
        this.form.setText("Attributes of 'Delegation' action");
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        this.createSectionControls(body, false);
        this.createSectionControls(body, true);
        Section delegateCommentSection = this.toolkit.createSection(body, 322);
        delegateCommentSection.setText("Delegation Comment:");
        delegateCommentSection.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite client = this.toolkit.createComposite((Composite)delegateCommentSection);
        client.setLayout((Layout)new GridLayout(1, false));
        this.delegationComment = new Text(client, 2624);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = this.delegationComment.getLineHeight() * 3;
        data.widthHint = 200;
        this.delegationComment.setLayoutData((Object)data);
        delegateCommentSection.setClient((Control)client);
        delegateCommentSection.setExpanded(false);
    }

    private void createSectionControls(Composite parent, boolean assigned) {
        Button staffAssignmentButton;
        Text staffAssignmentRule;
        Section section = this.toolkit.createSection(parent, 322);
        section.setLayoutData((Object)new GridData(4, 4, false, false));
        Composite client = this.toolkit.createComposite((Composite)section);
        client.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(16384, 128, false, false);
        layoutData.horizontalSpan = 2;
        if (assigned) {
            section.setText("Delegation if item is already selected/running:");
            this.assignedDelegateToManagerButton = this.toolkit.createButton(client, "Delegate to manager", 16);
            this.assignedDelegateToManagerButton.setLayoutData((Object)layoutData);
            this.assignedDelegateBySARButton = this.toolkit.createButton(client, "Delegate by Staff Assignment Rule", 16);
            this.assignedDelegateBySARButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.getSource()).getSelection()) {
                        DelegationComposite.this.enableAssignedSARControls(true);
                    } else {
                        DelegationComposite.this.enableAssignedSARControls(false);
                    }
                }
            });
            layoutData = new GridData(16384, 128, false, false);
            layoutData.horizontalSpan = 2;
            this.assignedDelegateBySARButton.setLayoutData((Object)layoutData);
            staffAssignmentRule = this.assignedStaffAssignmentRule = this.toolkit.createText(client, "", 2056);
            staffAssignmentButton = this.assignedStaffAssignmentButton = this.toolkit.createButton(client, "Change...", 8);
        } else {
            section.setText("Delegation if item is still unselected:");
            this.unassignedDelegateToManagerButton = this.toolkit.createButton(client, "Delegate to manager", 16);
            this.unassignedDelegateToManagerButton.setLayoutData((Object)layoutData);
            this.unassignedDelegateBySARButton = this.toolkit.createButton(client, "Delegate by Staff Assignment Rule", 16);
            layoutData = new GridData(16384, 128, false, false);
            layoutData.horizontalSpan = 2;
            this.unassignedDelegateBySARButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((Button)e.getSource()).getSelection()) {
                        DelegationComposite.this.enableUnassignedSARControls(true);
                    } else {
                        DelegationComposite.this.enableUnassignedSARControls(false);
                    }
                }
            });
            layoutData = new GridData(16384, 128, false, false);
            layoutData.horizontalSpan = 2;
            this.unassignedDelegateBySARButton.setLayoutData((Object)layoutData);
            staffAssignmentRule = this.unassignedStaffAssignmentRule = this.toolkit.createText(client, "", 2056);
            staffAssignmentButton = this.unassignedStaffAssignmentButton = this.toolkit.createButton(client, "Change...", 8);
        }
        layoutData = new GridData(4, 0x1000000, true, false);
        staffAssignmentRule.setLayoutData((Object)layoutData);
        layoutData = new GridData(131072, 128, false, false);
        staffAssignmentButton.setLayoutData((Object)layoutData);
        staffAssignmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StaffAssignmentRuleDialogueProvider[] providers = StaffAssignmentRuleDialogueRegistry.getProviders();
                if (providers.length == 0) {
                    throw new RuntimeException("There are no registered Staff Assignment Rule Dialogue providers!");
                }
                StaffAssignmentRuleDialogue dialogue = providers[0].createDialogue(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Activator.getService().getOrgModelManager());
                dialogue.open(staffAssignmentRule.getText());
                if (dialogue.wasConfirmed() && dialogue.wasStaffAssignmentRuleChanged()) {
                    String sar = dialogue.getStaffAssignmentRule();
                    staffAssignmentRule.setText(sar);
                }
            }
        });
        section.setClient((Control)client);
        section.setExpanded(false);
    }

    protected void enableUnassignedSARControls(boolean enable) {
        this.unassignedStaffAssignmentRule.setEnabled(enable);
        this.unassignedStaffAssignmentButton.setEnabled(enable);
    }

    protected void enableAssignedSARControls(boolean enable) {
        this.assignedStaffAssignmentRule.setEnabled(enable);
        this.assignedStaffAssignmentButton.setEnabled(enable);
    }

    @Override
    public Map<String, String> getInput() {
        String sar;
        HashMap<String, String> escalationAttributes = new HashMap<String, String>();
        DelegationMeasureData delegationMeasureData = (DelegationMeasureData)ModelViewer.createView(escalationAttributes, DelegationMeasureData.class);
        if (this.unassignedDelegateToManagerButton.getSelection() || !this.unassignedDelegateToManagerButton.getSelection() && this.unassignedStaffAssignmentRule.getText().equals("")) {
            delegationMeasureData.setUnassignedDelegationRule(null);
        } else {
            sar = this.unassignedStaffAssignmentRule.getText();
            delegationMeasureData.setUnassignedDelegationRule(sar);
        }
        if (this.assignedDelegateToManagerButton.getSelection() || !this.assignedDelegateToManagerButton.getSelection() && this.assignedStaffAssignmentRule.getText().equals("")) {
            delegationMeasureData.setAssignedDelegationRule(null);
        } else {
            sar = this.assignedStaffAssignmentRule.getText();
            delegationMeasureData.setAssignedDelegationRule(sar);
        }
        delegationMeasureData.setDelegationComment(this.delegationComment.getText());
        return escalationAttributes;
    }

    @Override
    public void setInput(Map<String, String> escalationAttributes) {
        DelegationMeasureData delegationMeasureData = (DelegationMeasureData)ModelViewer.createView(escalationAttributes, DelegationMeasureData.class);
        String assignedSARRule = delegationMeasureData.getAssignedDelegationRule();
        if (assignedSARRule == null) {
            this.assignedDelegateToManagerButton.setSelection(true);
            this.assignedDelegateBySARButton.setSelection(false);
            this.assignedStaffAssignmentRule.setText("");
            this.enableAssignedSARControls(false);
        } else {
            this.assignedDelegateToManagerButton.setSelection(false);
            this.assignedDelegateBySARButton.setSelection(true);
            this.assignedStaffAssignmentRule.setText(assignedSARRule);
            this.enableAssignedSARControls(true);
        }
        String unassignedSARRule = delegationMeasureData.getUnassignedDelegationRule();
        if (unassignedSARRule == null) {
            this.unassignedDelegateToManagerButton.setSelection(true);
            this.unassignedDelegateBySARButton.setSelection(false);
            this.unassignedStaffAssignmentRule.setText("");
            this.enableUnassignedSARControls(false);
        } else {
            this.unassignedDelegateToManagerButton.setSelection(false);
            this.unassignedDelegateBySARButton.setSelection(true);
            this.unassignedStaffAssignmentRule.setText(unassignedSARRule);
            this.enableUnassignedSARControls(true);
        }
        String delegationComment = delegationMeasureData.getDelegationComment();
        if (delegationComment != null) {
            this.delegationComment.setText(delegationComment);
        } else {
            this.delegationComment.setText("");
        }
    }
}

