/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.escalationcomposites;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.worklistmanager.escalationmeasures.InstantiateProcessMeasure;
import de.aristaflow.adept2.model.common.plugindata.InstantiateProcessMeasureData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.escalationcomposites.AbstractEscalationComposite;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class InstantiateProcessComposite
extends AbstractEscalationComposite {
    private Map<String, UUID> templateNameMap = new HashMap<String, UUID>();
    private Map<UUID, String> templateUUIDMap = new HashMap<UUID, String>();
    private Combo templateCombo;
    String[] comboInput = new String[0];

    public InstantiateProcessComposite(Composite parent, int style) {
        super(parent, style);
        this.createChildControls();
    }

    @Override
    protected void createChildControls() {
        this.form.setText("Attributes of 'Start escalation process' action");
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        this.toolkit.createLabel(body, "Select the template to instantiate:");
        this.templateCombo = new Combo(body, 0x800808);
        this.toolkit.adapt((Control)this.templateCombo, true, false);
        GridData gridData = new GridData(4, 128, false, false);
        this.templateCombo.setLayoutData((Object)gridData);
        SessionToken session = Activator.getService().getSessionToken();
        Set templateRefs = Activator.getService().getInstanceControl().getInstantiableTemplateReferences(session);
        Activator.getService().getProcessManager().getTemplateManager();
        for (TemplateReference templateRef : templateRefs) {
            if (!InstantiateProcessMeasure.isValidEscalationProcess((TemplateReference)templateRef, (ProcessModelFactory)Activator.getService().getProcessModelFactory())) continue;
            String name = String.format("%s (#%s)", templateRef.getName(), templateRef.getID().getMostSignificantBits());
            this.templateNameMap.put(name, templateRef.getID());
            this.templateUUIDMap.put(templateRef.getID(), name);
        }
        this.comboInput = this.templateNameMap.keySet().toArray(new String[this.templateNameMap.size()]);
        this.templateCombo.setItems(this.comboInput);
    }

    @Override
    public Map<String, String> getInput() {
        HashMap<String, String> escalationAttributes = new HashMap<String, String>();
        InstantiateProcessMeasureData instantiateProcessData = (InstantiateProcessMeasureData)ModelViewer.createView(escalationAttributes, InstantiateProcessMeasureData.class);
        int selectionIndex = this.templateCombo.getSelectionIndex();
        UUID templateID = selectionIndex == -1 ? null : this.templateNameMap.get(this.comboInput[selectionIndex]);
        instantiateProcessData.setTemplateID(templateID);
        return escalationAttributes;
    }

    @Override
    public void setInput(Map<String, String> escalationAttributes) {
        InstantiateProcessMeasureData instantiateProcessData = (InstantiateProcessMeasureData)ModelViewer.createView(escalationAttributes, InstantiateProcessMeasureData.class);
        UUID templateID = instantiateProcessData.getTemplateID();
        String name = this.templateUUIDMap.get(templateID);
        if (name != null) {
            int index = 0;
            int i = 0;
            while (i < this.comboInput.length) {
                if (this.comboInput[i].equals(name)) {
                    index = i;
                    break;
                }
                ++i;
            }
            this.templateCombo.select(index);
        }
    }
}

