/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.escalationcomposites;

import de.aristaflow.adept2.model.common.plugindata.MailNotificationData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.escalationcomposites.AbstractEscalationComposite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MailNotificationComposite
extends AbstractEscalationComposite {
    private static final String ADDRESS = "Email recipients";
    private Text subjectTextField;
    private Text bodyTextField;
    Button mailAddressesButton;
    Button assignmentMembersButton;
    Button assignmentSupervisorButton;
    TableViewer addressTableViewer;
    List<String> mailAddressModel = new ArrayList<String>();

    public MailNotificationComposite(Composite parent, int style) {
        super(parent, style);
        this.createChildControls();
    }

    @Override
    protected void createChildControls() {
        this.form.setText("Attributes of 'Mail Notification' action");
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(4, 4, false, false);
        this.assignmentMembersButton = this.toolkit.createButton(body, "Send email to assigned staff.", 32);
        this.assignmentMembersButton.setLayoutData((Object)gridData);
        this.assignmentMembersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!((Button)e.getSource()).getSelection() && !MailNotificationComposite.this.assignmentSupervisorButton.getSelection()) {
                    MailNotificationComposite.this.addressTableViewer.getTable().setEnabled(true);
                    MailNotificationComposite.this.mailAddressesButton.setSelection(true);
                }
            }
        });
        gridData = new GridData(4, 4, false, false);
        this.assignmentSupervisorButton = this.toolkit.createButton(body, "Send email to supervisor of assigned staff.", 32);
        this.assignmentSupervisorButton.setLayoutData((Object)gridData);
        this.assignmentSupervisorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!((Button)e.getSource()).getSelection() && !MailNotificationComposite.this.assignmentMembersButton.getSelection()) {
                    MailNotificationComposite.this.addressTableViewer.getTable().setEnabled(true);
                    MailNotificationComposite.this.mailAddressesButton.setSelection(true);
                }
            }
        });
        this.mailAddressesButton = this.toolkit.createButton(body, "Use recipients from the table.", 32);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 3;
        this.mailAddressesButton.setLayoutData((Object)gridData);
        this.mailAddressesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    MailNotificationComposite.this.addressTableViewer.getTable().setEnabled(true);
                } else {
                    MailNotificationComposite.this.addressTableViewer.getTable().setEnabled(false);
                    if (!MailNotificationComposite.this.assignmentSupervisorButton.getSelection()) {
                        MailNotificationComposite.this.assignmentMembersButton.setSelection(true);
                    }
                }
            }
        });
        Table addressTable = this.toolkit.createTable(body, 100352);
        GridData data = new GridData(4, 4, false, false);
        data.horizontalSpan = 3;
        data.heightHint = 60;
        addressTable.setLayoutData((Object)data);
        this.addressTableViewer = new TableViewer(addressTable);
        TableColumn addressColumn = new TableColumn(addressTable, 16384);
        addressColumn.setText(ADDRESS);
        addressColumn.setWidth(250);
        this.addressTableViewer.setColumnProperties(new String[]{ADDRESS});
        addressTable.setHeaderVisible(true);
        addressTable.setLinesVisible(true);
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)addressTable)};
        this.addressTableViewer.setCellEditors(editors);
        this.addressTableViewer.setCellModifier((ICellModifier)new AddressTableCellModifier(this.addressTableViewer));
        this.addressTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.addressTableViewer.setLabelProvider((IBaseLabelProvider)new EMailTableLabelProvider());
        Label subjectLabel = this.toolkit.createLabel(body, "Subject:");
        gridData = new GridData(16384, 0x1000000, false, false);
        subjectLabel.setLayoutData((Object)gridData);
        this.subjectTextField = this.toolkit.createText(body, "", 2048);
        gridData = new GridData(4, 4, false, false);
        this.subjectTextField.setLayoutData((Object)gridData);
        Button btnSubjectInsert = this.toolkit.createButton(body, "", 1028);
        MenuManager mmSubjectInsert = new MenuManager();
        this.fillFieldInsertMenu(mmSubjectInsert, this.subjectTextField);
        final Menu menSubjectInsert = mmSubjectInsert.createContextMenu((Control)btnSubjectInsert);
        btnSubjectInsert.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                menSubjectInsert.setVisible(true);
            }
        });
        this.bodyTextField = this.toolkit.createText(body, "", 2626);
        gridData = new GridData(4, 4, true, false);
        gridData.heightHint = this.bodyTextField.getLineHeight() * 10;
        gridData.horizontalSpan = 2;
        this.bodyTextField.setLayoutData((Object)gridData);
        Button btnBodyInsert = this.toolkit.createButton(body, "", 1028);
        gridData = new GridData(-1, 128, false, false);
        btnBodyInsert.setLayoutData((Object)gridData);
        MenuManager mmBodyInsert = new MenuManager();
        this.fillFieldInsertMenu(mmBodyInsert, this.bodyTextField);
        final Menu menBodyInsert = mmBodyInsert.createContextMenu((Control)btnBodyInsert);
        btnBodyInsert.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                menBodyInsert.setVisible(true);
            }
        });
    }

    private void fillFieldInsertMenu(MenuManager menuManager, Text textField) {
        MailNotificationData.MailField[] mailFieldArray = MailNotificationData.MailField.values();
        int n = mailFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            MailNotificationData.MailField field = mailFieldArray[n2];
            menuManager.add((IAction)new InsertTemplateValueAction(textField, field));
            ++n2;
        }
    }

    @Override
    public Map<String, String> getInput() {
        MailNotificationData.Addressees type;
        HashMap<String, String> escalationAttributes = new HashMap<String, String>();
        MailNotificationData mailData = (MailNotificationData)ModelViewer.createView(escalationAttributes, MailNotificationData.class);
        if (this.mailAddressesButton.getSelection()) {
            type = MailNotificationData.Addressees.MailAddresses;
            ArrayList<String> shortList = new ArrayList<String>(this.mailAddressModel);
            if (!shortList.isEmpty()) {
                shortList.remove(shortList.size() - 1);
            }
            shortList.toArray(new String[shortList.size()]);
            mailData.setMailAddresses(shortList.toArray(new String[shortList.size()]));
            if (this.assignmentMembersButton.getSelection()) {
                type = this.assignmentSupervisorButton.getSelection() ? MailNotificationData.Addressees.Both : MailNotificationData.Addressees.AssignmentMembersAndMail;
            } else if (this.assignmentSupervisorButton.getSelection()) {
                type = MailNotificationData.Addressees.AssignmentSupervisorMembersAndMail;
            }
        } else {
            type = MailNotificationData.Addressees.AssignmentMembers;
            if (this.assignmentMembersButton.getSelection()) {
                if (this.assignmentSupervisorButton.getSelection()) {
                    type = MailNotificationData.Addressees.AssignmentMembersAndSupervisors;
                }
            } else if (this.assignmentSupervisorButton.getSelection()) {
                type = MailNotificationData.Addressees.AssignmentSupervisorMembers;
            }
            mailData.setMailAddresses(new String[0]);
        }
        mailData.setAddressees(type);
        mailData.setMailSubject(this.subjectTextField.getText());
        mailData.setMailBody(this.bodyTextField.getText());
        return escalationAttributes;
    }

    @Override
    public void setInput(Map<String, String> escalationAttributes) {
        this.mailAddressModel.clear();
        MailNotificationData mailData = (MailNotificationData)ModelViewer.createView(escalationAttributes, MailNotificationData.class);
        MailNotificationData.Addressees addressees = mailData.getAddressees();
        switch (addressees) {
            case MailAddresses: {
                String mailAddress;
                this.mailAddressesButton.setSelection(true);
                this.addressTableViewer.getTable().setEnabled(true);
                this.assignmentMembersButton.setSelection(false);
                this.assignmentSupervisorButton.setSelection(false);
                String[] stringArray = mailData.getMailAddresses();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    mailAddress = stringArray[n2];
                    this.mailAddressModel.add(mailAddress);
                    ++n2;
                }
                break;
            }
            case AssignmentMembers: {
                this.assignmentMembersButton.setSelection(true);
                this.assignmentSupervisorButton.setSelection(false);
                this.mailAddressesButton.setSelection(false);
                this.addressTableViewer.getTable().setEnabled(false);
                break;
            }
            case AssignmentSupervisorMembers: {
                this.assignmentSupervisorButton.setSelection(true);
                this.assignmentMembersButton.setSelection(false);
                this.mailAddressesButton.setSelection(false);
                this.addressTableViewer.getTable().setEnabled(false);
                break;
            }
            case AssignmentMembersAndSupervisors: {
                this.assignmentSupervisorButton.setSelection(true);
                this.assignmentMembersButton.setSelection(true);
                this.mailAddressesButton.setSelection(false);
                this.addressTableViewer.getTable().setEnabled(false);
                break;
            }
            case AssignmentMembersAndMail: {
                String mailAddress;
                this.mailAddressesButton.setSelection(true);
                this.addressTableViewer.getTable().setEnabled(true);
                this.assignmentMembersButton.setSelection(true);
                this.assignmentSupervisorButton.setSelection(false);
                String[] stringArray = mailData.getMailAddresses();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    mailAddress = stringArray[n2];
                    this.mailAddressModel.add(mailAddress);
                    ++n2;
                }
                break;
            }
            case AssignmentSupervisorMembersAndMail: {
                String mailAddress;
                this.mailAddressesButton.setSelection(true);
                this.addressTableViewer.getTable().setEnabled(true);
                this.assignmentMembersButton.setSelection(false);
                this.assignmentSupervisorButton.setSelection(true);
                String[] stringArray = mailData.getMailAddresses();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    mailAddress = stringArray[n2];
                    this.mailAddressModel.add(mailAddress);
                    ++n2;
                }
                break;
            }
            case Both: {
                String mailAddress;
                this.mailAddressesButton.setSelection(true);
                this.assignmentMembersButton.setSelection(true);
                this.assignmentSupervisorButton.setSelection(true);
                this.addressTableViewer.getTable().setEnabled(true);
                String[] stringArray = mailData.getMailAddresses();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    mailAddress = stringArray[n2];
                    this.mailAddressModel.add(mailAddress);
                    ++n2;
                }
                break;
            }
        }
        this.mailAddressModel.add("");
        this.addressTableViewer.setInput(this.mailAddressModel);
        String mailSubject = mailData.getMailSubject();
        if (mailSubject != null) {
            this.subjectTextField.setText(mailSubject);
        } else {
            this.subjectTextField.setText("");
        }
        String mailBody = mailData.getMailBody();
        if (mailSubject != null) {
            this.bodyTextField.setText(mailBody);
        } else {
            this.bodyTextField.setText("");
        }
    }

    private class AddressTableCellModifier
    implements ICellModifier {
        TableViewer tableViewer = null;

        public AddressTableCellModifier(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        public boolean canModify(Object element, String property) {
            boolean modifiable = false;
            if (this.tableViewer.getColumnProperties()[0].equals(property)) {
                modifiable = true;
            }
            return modifiable;
        }

        public Object getValue(Object element, String property) {
            int columnIndex = Arrays.asList(this.tableViewer.getColumnProperties()).indexOf(property);
            String result = null;
            String address = (String)element;
            switch (columnIndex) {
                case 0: {
                    result = address;
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            int columnIndex = Arrays.asList(this.tableViewer.getColumnProperties()).indexOf(property);
            TableItem item = (TableItem)element;
            String oldAddress = (String)item.getData();
            switch (columnIndex) {
                case 0: {
                    int i = 0;
                    while (i < MailNotificationComposite.this.mailAddressModel.size()) {
                        if (oldAddress.equals(MailNotificationComposite.this.mailAddressModel.get(i))) {
                            MailNotificationComposite.this.mailAddressModel.remove(i);
                            String mailAddress = (String)value;
                            if (!mailAddress.equals("") || mailAddress.equals("") && oldAddress.equals("")) {
                                MailNotificationComposite.this.mailAddressModel.add(i, mailAddress);
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
            String lastEntry = MailNotificationComposite.this.mailAddressModel.get(MailNotificationComposite.this.mailAddressModel.size() - 1);
            if (!lastEntry.equals("")) {
                MailNotificationComposite.this.mailAddressModel.add("");
            }
            this.tableViewer.refresh();
        }
    }

    private static class EMailTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private EMailTableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof String)) {
                throw new RuntimeException("getColumnText: element is not of type String!");
            }
            String address = (String)element;
            switch (columnIndex) {
                case 0: {
                    return address;
                }
            }
            return "Invalid column: " + columnIndex;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Image getImage(Object element) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }

    protected static class InsertTemplateValueAction
    extends Action {
        private final Text target;
        private final MailNotificationData.MailField field;

        public InsertTemplateValueAction(Text target, MailNotificationData.MailField field) {
            this.target = target;
            this.field = field;
            this.setText(field.toString());
        }

        public void run() {
            this.target.insert(this.field.variable);
        }
    }
}

