/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.escalationcomposites;

import de.aristaflow.adept2.model.common.plugindata.PriorityIncreaseData;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.ui.processvisualisation.propertysources.propertysections.escalationcomposites.AbstractEscalationComposite;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PriorityIncreaseComposite
extends AbstractEscalationComposite {
    Combo relativePriorityCombo;
    Combo absolutePriorityCombo;
    private Button relativeButton;
    private Button absoluteButton;

    public PriorityIncreaseComposite(Composite parent, int style) {
        super(parent, style);
        this.createChildControls();
    }

    @Override
    protected void createChildControls() {
        this.form.setText("Attributes of 'Increase Priority' action");
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 4, false, false);
        this.relativeButton = this.toolkit.createButton(body, "Increase by...", 16);
        this.relativeButton.setLayoutData((Object)gridData);
        this.relativeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    PriorityIncreaseComposite.this.relativePriorityCombo.setEnabled(true);
                } else {
                    PriorityIncreaseComposite.this.relativePriorityCombo.setEnabled(false);
                }
            }
        });
        this.relativePriorityCombo = new Combo(body, 2056);
        this.toolkit.adapt((Composite)this.relativePriorityCombo);
        String[] items = new String[WorklistConstants.Priority.values().length];
        int i = 0;
        while (i < WorklistConstants.Priority.values().length) {
            items[i] = i == WorklistConstants.Priority.values().length - 1 ? "max" : String.valueOf(i + 1) + " Level(s)";
            ++i;
        }
        this.relativePriorityCombo.setItems(items);
        this.relativePriorityCombo.select(0);
        GridData layoutData = new GridData(4, 0x1000000, false, false);
        this.relativePriorityCombo.setLayoutData((Object)layoutData);
        this.relativePriorityCombo.setEnabled(false);
        this.absoluteButton = this.toolkit.createButton(body, "Increase to...", 16);
        gridData = new GridData(4, 4, false, false);
        this.absoluteButton.setLayoutData((Object)gridData);
        this.absoluteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.getSource()).getSelection()) {
                    PriorityIncreaseComposite.this.absolutePriorityCombo.setEnabled(true);
                } else {
                    PriorityIncreaseComposite.this.absolutePriorityCombo.setEnabled(false);
                }
            }
        });
        this.absolutePriorityCombo = new Combo(body, 2056);
        this.toolkit.adapt((Composite)this.absolutePriorityCombo);
        int i2 = 0;
        while (i2 < WorklistConstants.Priority.values().length) {
            this.absolutePriorityCombo.add(WorklistConstants.Priority.toString(null, (int)WorklistConstants.Priority.values()[i2].getPriority()));
            ++i2;
        }
        this.absolutePriorityCombo.select(0);
        layoutData = new GridData(4, 0x1000000, false, false);
        this.absolutePriorityCombo.setLayoutData((Object)layoutData);
        this.absolutePriorityCombo.setEnabled(false);
    }

    @Override
    public Map<String, String> getInput() {
        int priorityValue;
        PriorityIncreaseData.Type type;
        HashMap<String, String> escalationAttributes = new HashMap<String, String>();
        PriorityIncreaseData priorityData = (PriorityIncreaseData)ModelViewer.createView(escalationAttributes, PriorityIncreaseData.class);
        if (this.absoluteButton.getSelection()) {
            type = PriorityIncreaseData.Type.IncreaseTo;
            priorityValue = WorklistConstants.Priority.values()[this.absolutePriorityCombo.getSelectionIndex()].getPriority();
        } else {
            type = PriorityIncreaseData.Type.IncreaseBy;
            priorityValue = WorklistConstants.Priority.values()[this.relativePriorityCombo.getSelectionIndex()].getPriority();
        }
        priorityData.setType(type);
        priorityData.setValue(priorityValue);
        return escalationAttributes;
    }

    @Override
    public void setInput(Map<String, String> escalationAttributes) {
        PriorityIncreaseData priorityData = (PriorityIncreaseData)ModelViewer.createView(escalationAttributes, PriorityIncreaseData.class);
        PriorityIncreaseData.Type type = priorityData.getType();
        if (type != null) {
            int priorityValue = priorityData.getValue();
            if (type.equals((Object)PriorityIncreaseData.Type.IncreaseBy)) {
                this.relativeButton.setSelection(true);
                this.absoluteButton.setSelection(false);
                this.absolutePriorityCombo.setEnabled(false);
                this.relativePriorityCombo.setEnabled(true);
                int i = 0;
                while (i < WorklistConstants.Priority.values().length) {
                    if (priorityValue == WorklistConstants.Priority.values()[i].getPriority()) {
                        this.relativePriorityCombo.select(i);
                        break;
                    }
                    ++i;
                }
            } else {
                this.relativeButton.setSelection(false);
                this.absoluteButton.setSelection(true);
                this.absolutePriorityCombo.setEnabled(true);
                this.relativePriorityCombo.setEnabled(false);
                int i = 0;
                while (i < WorklistConstants.Priority.values().length) {
                    if (priorityValue == WorklistConstants.Priority.values()[i].getPriority()) {
                        this.absolutePriorityCombo.select(i);
                    }
                    ++i;
                }
            }
        } else {
            this.relativeButton.setSelection(false);
            this.absoluteButton.setSelection(true);
            this.absolutePriorityCombo.setEnabled(true);
            this.relativePriorityCombo.setEnabled(false);
            this.absolutePriorityCombo.select(0);
        }
    }
}

