/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.selectionmanager;

import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionDefinition;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionGroup;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.events.SelectionChangedDeltaEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class Selection
implements ISelectionProvider {
    private SelectionDefinition definition;
    protected final Logger logger = null;
    private List<IProcessEditPart> selectedEditParts = new SelectionList();
    private List<IProcessEditPart> addedParts = new ArrayList<IProcessEditPart>();
    private List<IProcessEditPart> removedParts = new ArrayList<IProcessEditPart>();
    private SelectionGroup parent;
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();

    public Selection(SelectionGroup parent, SelectionDefinition definition) {
        this.parent = parent;
        this.definition = definition;
    }

    public SelectionDefinition getDefinition() {
        return this.definition;
    }

    public SelectionGroup getParent() {
        return this.parent;
    }

    public boolean isSelected(IProcessEditPart part) {
        return this.selectedEditParts.contains(part);
    }

    public void addPart(IProcessEditPart editPart) {
        if (!this.isAllowedToAdd(editPart)) {
            return;
        }
        this.selectedEditParts.add(editPart);
        this.addedParts.add(editPart);
        this.fireSelectionChangedEvent();
        this.addedParts.clear();
    }

    public void removePart(IProcessEditPart editPart) {
        if (!this.selectedEditParts.contains(editPart)) {
            return;
        }
        this.selectedEditParts.remove(editPart);
        this.removedParts.add(editPart);
        this.fireSelectionChangedEvent();
        this.removedParts.clear();
    }

    public void reset() {
        if (this.selectedEditParts.isEmpty()) {
            return;
        }
        for (IProcessEditPart part : this.selectedEditParts) {
            this.removedParts.add(part);
        }
        this.selectedEditParts.clear();
        this.fireSelectionChangedEvent();
        this.removedParts.clear();
    }

    public void fireSelectionChangedEvent() {
        SelectionChangedDeltaEvent event = new SelectionChangedDeltaEvent(this, this.getSelection(), this.addedParts, this.removedParts);
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged((SelectionChangedEvent)event);
        }
        this.addedParts.clear();
        this.removedParts.clear();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        return (ISelection)this.selectedEditParts;
    }

    public void setSelection(ISelection selection) {
        if (!(selection instanceof List)) {
            return;
        }
        if (!this.isAllowedToSet(selection)) {
            return;
        }
        for (IProcessEditPart part : (SelectionList)selection) {
            if (this.selectedEditParts.contains(part)) continue;
            this.addedParts.add(part);
        }
        for (IProcessEditPart part : this.selectedEditParts) {
            if (((SelectionList)selection).contains(part)) continue;
            this.removedParts.add(part);
        }
        this.selectedEditParts.clear();
        for (IProcessEditPart part : (List)selection) {
            this.selectedEditParts.add(part);
        }
        this.fireSelectionChangedEvent();
        this.addedParts.clear();
        this.removedParts.clear();
    }

    public boolean isAllowedToAdd(IProcessEditPart part) {
        SelectionList list = new SelectionList();
        list.add(part);
        return this.isAllowedToAdd((ISelection)list);
    }

    public boolean isAllowedToAdd(ISelection list) {
        if (!(list instanceof List)) {
            return false;
        }
        SelectionList tmpList = new SelectionList();
        for (IProcessEditPart part : this.selectedEditParts) {
            tmpList.add(part);
        }
        for (IProcessEditPart part : (List)list) {
            if (!this.definition.isValidAddAction(this, part)) {
                this.selectedEditParts = tmpList;
                return false;
            }
            if (this.selectedEditParts.contains(part)) continue;
            this.selectedEditParts.add(part);
        }
        this.selectedEditParts = tmpList;
        return true;
    }

    public boolean isAllowedToSet(IProcessEditPart part) {
        SelectionList list = new SelectionList();
        list.add(part);
        return this.isAllowedToSet((ISelection)list);
    }

    public boolean isAllowedToSet(ISelection list) {
        if (!(list instanceof List)) {
            return false;
        }
        List<IProcessEditPart> tmpList = this.selectedEditParts;
        this.selectedEditParts = new SelectionList();
        for (IProcessEditPart part : (List)list) {
            if (!this.definition.isValidAddAction(this, part)) {
                this.selectedEditParts = tmpList;
                return false;
            }
            if (this.selectedEditParts.contains(part)) continue;
            this.selectedEditParts.add(part);
        }
        this.selectedEditParts = tmpList;
        return true;
    }

    public static class SelectionList
    extends ArrayList<IProcessEditPart>
    implements IStructuredSelection {
        private static final long serialVersionUID = -1595656639985236907L;

        public Object getFirstElement() {
            if (this.size() == 0) {
                return null;
            }
            return this.get(0);
        }

        public List<?> toList() {
            return this;
        }
    }
}

