/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.selectionmanager;

import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.Selection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;

public class SelectionDefinition {
    private String id;
    private String name;
    private String description;
    private Color color;
    private SelectionMode mode;
    private List<Class<?>> acceptableTypes = new ArrayList();

    public SelectionDefinition(String id, String name, String description, Color color, SelectionMode mode, Class<?> ... types) {
        if (id == null || name == null || description == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.name = name;
        this.description = description;
        this.color = color;
        this.mode = mode;
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            this.acceptableTypes.add(type);
            ++n2;
        }
    }

    public List<Class<?>> getAcceptableTypes() {
        ArrayList res = new ArrayList(this.acceptableTypes);
        return res;
    }

    public Color getColor() {
        return this.color;
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public SelectionMode getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValidSelection(Selection selection) {
        return selection.getDefinition().getID().compareTo(this.id) == 0;
    }

    public boolean isValidAddAction(Selection selection, Object element) throws IllegalArgumentException {
        if (this.mode == SelectionMode.NONE) {
            return false;
        }
        if (selection == null || element == null) {
            throw new IllegalArgumentException("At least one argument is null");
        }
        if (selection.getDefinition().getID().compareTo(this.id) != 0) {
            return false;
        }
        if (this.acceptableTypes.contains(element.getClass())) {
            return false;
        }
        return this.mode != SelectionMode.SINGLE || ((Selection.SelectionList)selection.getSelection()).size() <= 0;
    }

    public static enum SelectionMode {
        SINGLE,
        MULTIPLE,
        NONE;

    }
}

