/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.selectionmanager;

import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.TemplateEditPart;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.Selection;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionDefinition;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionGroupDefinition;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionManager;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.events.ISelectionGroupChangeListener;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.events.ISelectionGroupChangedProvider;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.events.SelectionChangedDeltaEvent;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.events.SelectionGroupChangedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SelectionGroup
implements ISelectionChangedListener,
ISelectionGroupChangedProvider {
    private boolean active;
    private SelectionGroupDefinition definition = null;
    private List<Selection> selections = new ArrayList<Selection>();
    private Selection activeSelection = null;
    private List<Selection> visibleSelections = new ArrayList<Selection>();
    private SelectionManager parent = null;
    List<ISelectionGroupChangeListener> listeners = new ArrayList<ISelectionGroupChangeListener>();
    protected final Logger logger;

    SelectionGroup(SelectionManager parent, SelectionGroupDefinition definition) {
        if (parent == null || definition == null) {
            throw new IllegalArgumentException();
        }
        this.definition = definition;
        this.parent = parent;
        this.logger = Logger.getAnonymousLogger();
        for (SelectionDefinition def : definition.getSelectionDefinitions()) {
            Selection sel = new Selection(this, def);
            sel.addSelectionChangedListener(this);
            this.selections.add(sel);
            this.visibleSelections.add(sel);
        }
        if (this.selections.size() > 0) {
            this.setActiveSelection(this.selections.get(0));
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public SelectionGroupDefinition getDefinition() {
        return this.definition;
    }

    public SelectionManager getParent() {
        return this.parent;
    }

    public Selection getActiveSelection() {
        return this.activeSelection;
    }

    public Selection getSelection(SelectionDefinition definition) {
        for (Selection selection : this.selections) {
            if (selection == null || selection.getDefinition().getID().compareTo(definition.getID()) != 0) continue;
            return selection;
        }
        return null;
    }

    public List<Selection> getAllSelections() {
        return this.selections;
    }

    public boolean isSelected(IProcessEditPart part) {
        for (Selection seleciton : this.selections) {
            if (!seleciton.isSelected(part)) continue;
            return true;
        }
        return false;
    }

    public boolean isVisible(Selection selection) {
        return this.visibleSelections.contains(selection);
    }

    public void activate(boolean newState) {
        if (this.active == newState) {
            return;
        }
        if (!newState) {
            this.active = newState;
            for (Selection selection : this.selections) {
                for (IProcessEditPart part : (Selection.SelectionList)selection.getSelection()) {
                    part.setBackgroundColor(null);
                    part.setSelected(false);
                }
            }
            return;
        }
        SelectionGroup oldActiveGroup = this.parent.getActiveGroup();
        if (oldActiveGroup != null) {
            oldActiveGroup.activate(false);
        }
        this.active = newState;
        for (Selection selection : this.visibleSelections) {
            for (IProcessEditPart part : (Selection.SelectionList)selection.getSelection()) {
                part.setBackgroundColor(selection.getDefinition().getColor());
                if (selection != this.activeSelection) continue;
                part.setSelected(true);
            }
        }
    }

    public void setActivSelection(SelectionDefinition definition) {
        if (definition == null) {
            return;
        }
        Selection selection = this.getSelection(definition);
        if (!this.visibleSelections.contains(selection)) {
            this.visibleSelections.add(selection);
        }
        if (this.activeSelection != selection) {
            this.setActiveSelection(selection);
            this.fireSelectionGroupChangedEvent();
        }
    }

    public void switchActiveSelection() {
        int index = this.visibleSelections.indexOf(this.activeSelection);
        if (index == -1) {
            Selection sel = this.visibleSelections.get(0);
            if (sel == null) {
                return;
            }
            this.setActiveSelection(sel);
            this.fireSelectionGroupChangedEvent();
        } else {
            this.setActiveSelection(this.visibleSelections.get(index + 1 < this.visibleSelections.size() ? index + 1 : 0));
            this.fireSelectionGroupChangedEvent();
        }
    }

    public void showSelection(Selection selection) {
        if (!this.selections.contains(selection)) {
            return;
        }
        if (!this.visibleSelections.contains(selection)) {
            this.visibleSelections.add(selection);
            this.fireSelectionGroupChangedEvent();
        }
    }

    public void hideSelection(Selection selection) {
        if (this.visibleSelections.contains(selection)) {
            this.visibleSelections.remove(selection);
            if (selection == this.activeSelection) {
                this.setActiveSelection(null);
            }
            this.fireSelectionGroupChangedEvent();
        }
    }

    public void showAllSelections() {
        boolean fireEvent = false;
        for (Selection sel : this.selections) {
            if (this.visibleSelections.contains(sel)) continue;
            fireEvent = true;
            this.visibleSelections.add(sel);
        }
        if (fireEvent) {
            this.fireSelectionGroupChangedEvent();
        }
    }

    public void hideAllSelections() {
        this.visibleSelections.clear();
        this.setActiveSelection(null);
        this.fireSelectionGroupChangedEvent();
    }

    public void addEditPartToActiveSelection(IProcessEditPart editPart) {
        if (this.definition.isValidAddAction(this, editPart)) {
            this.activeSelection.addPart(editPart);
        }
    }

    public void removeEditPartFromActiveSelection(IProcessEditPart editPart) {
        if (this.activeSelection != null) {
            this.activeSelection.removePart(editPart);
        }
    }

    public void resetActiveSelection() {
        if (this.activeSelection != null) {
            this.activeSelection.reset();
        }
    }

    public void resetAllSelections() {
        for (Selection sel : this.selections) {
            sel.reset();
        }
        if (this.parent.getActiveGroup() == this) {
            this.parent.setActiveEditPart(null);
        }
    }

    public void validateSelection(Selection selection) {
        GraphicalViewer viewer = this.getParent().getViewer();
        if (!(viewer.getContents() instanceof TemplateEditPart)) {
            this.logger.info("No Template Editpart");
            return;
        }
        if (!this.selections.contains(selection)) {
            return;
        }
        SelectionDefinition def = selection.getDefinition();
        Template template = (Template)viewer.getContents().getModel();
        for (IProcessEditPart editPart : (ArrayList)selection.getSelection()) {
            int id;
            boolean accepted = false;
            for (Class<?> cls : def.getAcceptableTypes()) {
                if (cls != editPart.getClass()) continue;
                accepted = true;
            }
            if (!accepted) {
                selection.removePart(editPart);
                continue;
            }
            for (Selection otherSelection : this.selections) {
                if (otherSelection == selection || !otherSelection.isSelected(editPart)) continue;
                selection.removePart(editPart);
            }
            if (!(editPart.getModel() instanceof Node) || template.getNode(id = ((Node)editPart.getModel()).getID()) != null) continue;
            selection.removePart(editPart);
        }
    }

    public void validateAllSelections() {
        for (Selection sel : this.selections) {
            this.validateSelection(sel);
        }
    }

    @Override
    public void addSelectionGroupChangedListener(ISelectionGroupChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeSelectionGroupChangedListener(ISelectionGroupChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireSelectionGroupChangedEvent() {
        SelectionGroupChangedEvent event = new SelectionGroupChangedEvent(this);
        for (ISelectionGroupChangeListener listener : this.listeners) {
            listener.selectionGroupChanged(event);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Selection selection = (Selection)event.getSource();
        SelectionDefinition def = selection.getDefinition();
        if (!(event instanceof SelectionChangedDeltaEvent)) {
            for (IProcessEditPart part : (List)event.getSelection()) {
                part.setBackgroundColor(def.getColor());
                part.setSelected(true);
                if (this.activeSelection != selection || def.getMode() == SelectionDefinition.SelectionMode.NONE) continue;
                part.setBackgroundColor(def.getColor());
            }
            this.logger.info("No detailed information about the selectionchange");
            return;
        }
        SelectionChangedDeltaEvent e = (SelectionChangedDeltaEvent)event;
        if (e.hasChangedEditParts()) {
            for (IProcessEditPart part : e.getRemovedEditParts()) {
                part.setBackgroundColor(null);
                part.setSelected(false);
            }
            for (IProcessEditPart part : e.getAddedEditParts()) {
                part.setBackgroundColor(def.getColor());
                if (this.activeSelection != selection || def.getMode() == SelectionDefinition.SelectionMode.NONE) continue;
                part.setBackgroundColor(def.getColor());
                part.setSelected(true);
            }
        }
    }

    private void setActiveSelection(Selection selection) {
        if (this.activeSelection != null && this.active) {
            for (IProcessEditPart editPart : (ArrayList)this.activeSelection.getSelection()) {
                editPart.setSelected(false);
            }
        }
        SelectionDefinition def = selection.getDefinition();
        this.activeSelection = selection;
        if (def.getMode() != SelectionDefinition.SelectionMode.NONE && this.active) {
            for (IProcessEditPart editPart : (ArrayList)selection.getSelection()) {
                editPart.setSelected(true);
            }
        }
    }

    public void switchSelection(IProcessEditPart part) {
        if (this.activeSelection == null) {
            return;
        }
        if (this.activeSelection.isSelected(part)) {
            this.activeSelection.removePart(part);
            return;
        }
        if (!this.activeSelection.isAllowedToAdd(part)) {
            return;
        }
        for (Selection selection : this.selections) {
            if (!selection.isSelected(part)) continue;
            selection.removePart(part);
        }
        this.activeSelection.addPart(part);
    }

    public void setSelection(IProcessEditPart part) {
        if (this.activeSelection == null) {
            return;
        }
        Selection.SelectionList list = new Selection.SelectionList();
        list.add(part);
        if (!this.activeSelection.isAllowedToSet((ISelection)list)) {
            return;
        }
        for (Selection selection : this.selections) {
            if (selection == this.activeSelection || !selection.isSelected(part)) continue;
            selection.removePart(part);
        }
        this.activeSelection.setSelection((ISelection)list);
    }
}

