/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.selectionmanager;

import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.Selection;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionDefinition;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionGroup;
import java.util.ArrayList;
import java.util.List;

public class SelectionGroupDefinition {
    private String id;
    private String name;
    private List<SelectionDefinition> selectionDefinitions = new ArrayList<SelectionDefinition>();

    public SelectionGroupDefinition(String id, String name, SelectionDefinition ... defList) {
        this.name = name;
        this.id = id;
        SelectionDefinition[] selectionDefinitionArray = defList;
        int n = defList.length;
        int n2 = 0;
        while (n2 < n) {
            SelectionDefinition def = selectionDefinitionArray[n2];
            this.selectionDefinitions.add(def);
            ++n2;
        }
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<SelectionDefinition> getSelectionDefinitions() {
        return this.selectionDefinitions;
    }

    public boolean isValidGroup(SelectionGroup group) {
        return group.getDefinition().getID().compareTo(this.id) == 0;
    }

    public boolean isValidAddAction(SelectionGroup group, Object element) throws IllegalArgumentException {
        if (group == null || element == null) {
            throw new IllegalArgumentException("At least one argument is null");
        }
        if (!group.getDefinition().getID().equals(this.id)) {
            return false;
        }
        Selection selection = group.getActiveSelection();
        if (selection == null) {
            return false;
        }
        return selection.getDefinition().isValidAddAction(selection, element);
    }
}

