/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.selectionmanager;

import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.processvisualisation.PaletteFactory;
import de.aristaflow.adept2.ui.processvisualisation.SwapSelectionToolEntry;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.ui.processvisualisation.parts.BranchEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataEdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.DefaultNodeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.EdgeEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.TemplateEditPart;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.Selection;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionDefinition;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionGroup;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.SelectionGroupDefinition;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.events.ISelectionGroupChangeListener;
import de.aristaflow.adept2.ui.processvisualisation.selectionmanager.events.SelectionGroupChangedEvent;
import de.aristaflow.adept2.ui.processvisualisation.widgets.DataFigure;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;

public class SelectionManager
implements ISelectionProvider,
ISelectionGroupChangeListener {
    protected final Logger logger;
    private List<SelectionGroup> groups = new ArrayList<SelectionGroup>();
    private GraphicalViewer viewer = null;
    private PaletteFactory palette = null;
    private IProcessEditPart activeEditPart = null;
    private List<IProcessEditPart> activeEditPartDependencies = new ArrayList<IProcessEditPart>();
    private EditDomain domain;
    private UISettings uiSettings;
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private Selection activeSelection = null;

    public SelectionManager(GraphicalViewer parent, PaletteFactory palette, EditDomain domain, UISettings uiSettings) {
        this.viewer = parent;
        this.palette = palette;
        this.domain = domain;
        this.uiSettings = uiSettings;
        this.logger = LoggerTools.getLogger((Object)this);
    }

    public SelectionGroup getActiveGroup() {
        for (SelectionGroup group : this.groups) {
            if (!group.isActive()) continue;
            return group;
        }
        return null;
    }

    public SelectionGroup getGroup(SelectionGroupDefinition definition) {
        if (definition == null) {
            return null;
        }
        for (SelectionGroup group : this.groups) {
            if (group.getDefinition().getID().compareTo(definition.getID()) != 0) continue;
            return group;
        }
        return this.createNewGroup(definition);
    }

    public List<SelectionGroup> getAllGroups() {
        return new ArrayList<SelectionGroup>(this.groups);
    }

    public IProcessEditPart getActiveEditPart() {
        return this.activeEditPart;
    }

    public GraphicalViewer getViewer() {
        return this.viewer;
    }

    public void removeGroup(SelectionGroupDefinition definition) {
        Iterator<SelectionGroup> groupIterator = this.groups.iterator();
        while (groupIterator.hasNext()) {
            SelectionGroup group = groupIterator.next();
            if (!group.getDefinition().getID().equals(definition.getID())) continue;
            if (group.isActive()) {
                this.setActiveGroup(null);
            }
            groupIterator.remove();
            return;
        }
    }

    public void setActiveGroup(SelectionGroupDefinition definition) {
        SelectionGroup activeGroup = this.getActiveGroup();
        if (activeGroup != null && definition == null) {
            activeGroup.activate(false);
            if (this.domain != null && this.palette != null) {
                this.updateSelectionDrawerEntries();
            }
            return;
        }
        SelectionGroup group = this.getGroup(definition);
        this.activeSelection = null;
        if (group != null) {
            this.activeSelection = group.getActiveSelection();
            group.activate(true);
        }
        if (this.domain != null && this.palette != null) {
            this.updateSelectionDrawerEntries();
        }
    }

    public void validateSelections() {
        for (SelectionGroup group : this.groups) {
            group.validateAllSelections();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public ISelection getSelection() {
        SelectionGroup group = this.getActiveGroup();
        if (group == null) {
            if (this.getActiveEditPart() != null) {
                return new StructuredSelection((Object)this.getActiveEditPart());
            }
            return new StructuredSelection();
        }
        Selection selection = group.getActiveSelection();
        if (selection == null) {
            return new StructuredSelection();
        }
        return new StructuredSelection(((Selection.SelectionList)selection.getSelection()).toArray());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        SelectionGroup group = this.getActiveGroup();
        if (group == null) {
            return;
        }
        Selection activeSelection = group.getActiveSelection();
        if (activeSelection == null) {
            return;
        }
        activeSelection.setSelection(selection);
    }

    public void updateSelectionReferencesForGroup(Instance newInstance, SelectionGroupDefinition definition) {
        this.updateSelectionReferencesForGroup(newInstance.getTemplate(), definition);
    }

    public void updateSelectionReferencesForGroup(Template newTemplate, SelectionGroupDefinition definition) {
        SelectionGroup selectedGroup = null;
        for (SelectionGroup group : this.groups) {
            if (group.getDefinition().getID().compareTo(definition.getID()) != 0) continue;
            selectedGroup = group;
            break;
        }
        if (selectedGroup == null) {
            String message = "The selection manager does not contain a selection group for the given definition '" + definition + "'.";
            this.logger.severe(message);
            throw new IllegalArgumentException(message);
        }
        List<Selection> selections = selectedGroup.getAllSelections();
        for (Selection selection : selections) {
            Selection.SelectionList selectedParts = (Selection.SelectionList)selection.getSelection();
            Selection.SelectionList partList = new Selection.SelectionList();
            for (Object selectedPart : selectedParts) {
                int dataElementID;
                IProcessEditPart currentPart = (IProcessEditPart)selectedPart;
                Object element = currentPart.getModel();
                IProcessEditPart newActivePart = null;
                if (element instanceof Node) {
                    Node node = (Node)element;
                    int nodeID = node.getID();
                    newActivePart = (IProcessEditPart)this.getViewer().getEditPartRegistry().get(newTemplate.getNode(nodeID));
                    if (newActivePart != null) {
                        partList.add(newActivePart);
                    }
                } else if (element instanceof DataElement) {
                    DataElement dataElement = (DataElement)element;
                    dataElementID = dataElement.getID();
                    newActivePart = (IProcessEditPart)this.getViewer().getEditPartRegistry().get(newTemplate.getDataElement(dataElementID));
                    if (newActivePart != null) {
                        partList.add(newActivePart);
                    }
                } else if (selectedPart instanceof DataEdgeEditPart) {
                    DataEdge dataEdge = (DataEdge)element;
                    dataElementID = -1;
                    int nodeID = -1;
                    DataEdgeEditPart dataEdgeEditPart = (DataEdgeEditPart)selectedPart;
                    switch (dataEdge.getType()) {
                        case READ: 
                        case SYSTEM_READ: {
                            dataElementID = dataEdgeEditPart.getSourceNodeID();
                            nodeID = dataEdgeEditPart.getDestNodeID();
                            break;
                        }
                        case WRITE: 
                        case SYSTEM_WRITE: {
                            dataElementID = dataEdgeEditPart.getDestNodeID();
                            nodeID = dataEdgeEditPart.getSourceNodeID();
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)"An unknown access type was found!");
                        }
                    }
                    newActivePart = (IProcessEditPart)this.getViewer().getEditPartRegistry().get(newTemplate.getDataEdge(nodeID, dataElementID, dataEdge.getType()));
                    if (newActivePart != null) {
                        partList.add(newActivePart);
                    }
                } else if (element instanceof EdgeEditPart) {
                    EdgeEditPart edgePart = (EdgeEditPart)element;
                    int srcNodeID = edgePart.getSourceNodeID();
                    int destNodeID = edgePart.getDestNodeID();
                    Edge edge = (Edge)element;
                    newActivePart = (IProcessEditPart)this.getViewer().getEditPartRegistry().get(newTemplate.getEdge(srcNodeID, destNodeID, edge.getType()));
                    if (newActivePart != null) {
                        partList.add(newActivePart);
                    }
                }
                if (currentPart != this.activeEditPart) continue;
                this.activeEditPart = newActivePart;
            }
            if (partList.isEmpty()) continue;
            selection.reset();
            selection.setSelection((ISelection)partList);
        }
    }

    public void editPartClicked(IProcessEditPart part, boolean ctrl) {
        List edgeEditParts;
        List edgeEditParts2;
        DataFigure dataFigure;
        if (this.uiSettings.isDependencyVisibilityModeOn() && this.getActiveEditPart() instanceof DataElementEditPart && (!this.uiSettings.isDataElementsVisible() || ProcessConstants.IDENTIFIER_ID_DECISION.equals(((DataElement)((DataElementEditPart)this.getActiveEditPart()).getModel()).getIdentifierID()))) {
            ((DataFigure)((DataElementEditPart)this.getActiveEditPart()).getFigure()).setVisible(false);
        }
        this.getViewer().deselectAll();
        for (IProcessEditPart depPart : this.activeEditPartDependencies) {
            Iterator edgeEditPart2;
            depPart.setBorderColor(null);
            if (depPart instanceof DataElementEditPart) {
                DataFigure dataFigure2 = (DataFigure)((DataElementEditPart)depPart).getFigure();
                dataFigure2.resetLineStyle();
                if (!this.uiSettings.isDependencyVisibilityModeOn()) continue;
                dataFigure2.setVisible(this.uiSettings.isDataElementsVisible() && !ProcessConstants.IDENTIFIER_ID_DECISION.equals(((DataElement)depPart.getModel()).getIdentifierID()));
                if ((!this.uiSettings.isDataElementsVisible() || ProcessConstants.IDENTIFIER_ID_DECISION.equals(((DataElement)depPart.getModel()).getIdentifierID())) && part.equals(depPart)) {
                    dataFigure2.setVisible(true);
                }
                List srcEdgeEditParts = ((DataElementEditPart)depPart).getSourceConnections();
                List destEdgeEditParts = ((DataElementEditPart)depPart).getTargetConnections();
                for (Iterator edgeEditPart2 : srcEdgeEditParts) {
                    ((EdgeEditPart)((Object)edgeEditPart2)).getFigure().setVisible(false);
                }
                for (Iterator edgeEditPart2 : destEdgeEditParts) {
                    ((EdgeEditPart)((Object)edgeEditPart2)).getFigure().setVisible(false);
                }
                continue;
            }
            if (!(depPart instanceof DefaultNodeEditPart) || !this.uiSettings.isDependencyVisibilityModeOn()) continue;
            List srcEdgeEditParts = ((DefaultNodeEditPart)depPart).getSourceConnections();
            List destEdgeEditParts = ((DefaultNodeEditPart)depPart).getTargetConnections();
            for (Iterator<IProcessEditPart> edgeEditPart3 : srcEdgeEditParts) {
                if (!(((EdgeEditPart)((Object)edgeEditPart3)).getModel() instanceof DataEdge)) continue;
                ((EdgeEditPart)((Object)edgeEditPart3)).getFigure().setVisible(false);
            }
            edgeEditPart2 = destEdgeEditParts.iterator();
            while (edgeEditPart2.hasNext()) {
                Iterator<IProcessEditPart> edgeEditPart3;
                edgeEditPart3 = edgeEditPart2.next();
                if (!(((EdgeEditPart)((Object)edgeEditPart3)).getModel() instanceof DataEdge)) continue;
                ((EdgeEditPart)((Object)edgeEditPart3)).getFigure().setVisible(false);
            }
        }
        this.activeEditPartDependencies = new ArrayList<IProcessEditPart>();
        if (part == null) {
            return;
        }
        this.setActiveEditPart(part);
        List<IProcessEditPart> read = this.getDependencies(part, 0);
        List<IProcessEditPart> write = this.getDependencies(part, 1);
        ArrayList<IProcessEditPart> rw = new ArrayList<IProcessEditPart>();
        for (IProcessEditPart readPart : read) {
            readPart.setBorderColor(ColorConstants.darkGreen);
            if (readPart instanceof DataElementEditPart) {
                dataFigure = (DataFigure)((DataElementEditPart)readPart).getFigure();
                dataFigure.setLineStyle(1);
                if (this.uiSettings.isDependencyVisibilityModeOn()) {
                    dataFigure.setVisible(true);
                    edgeEditParts2 = ((DataElementEditPart)readPart).getSourceConnections();
                    for (Iterator edgeEditPart : edgeEditParts2) {
                        if (((EdgeEditPart)((Object)edgeEditPart)).getDestNodeID() != ((Node)part.getModel()).getID()) continue;
                        ((EdgeEditPart)((Object)edgeEditPart)).getFigure().setVisible(true);
                    }
                }
            } else if (readPart instanceof DefaultNodeEditPart && this.uiSettings.isDependencyVisibilityModeOn()) {
                Iterator edgeEditPart;
                edgeEditParts = ((DefaultNodeEditPart)readPart).getTargetConnections();
                edgeEditPart = edgeEditParts.iterator();
                while (edgeEditPart.hasNext()) {
                    Iterator<IProcessEditPart> edgeEditPart4 = edgeEditPart.next();
                    if (((EdgeEditPart)((Object)edgeEditPart4)).getSourceNodeID() != ((DataElement)part.getModel()).getID()) continue;
                    ((EdgeEditPart)((Object)edgeEditPart4)).getFigure().setVisible(true);
                }
            }
            if (this.sameColor(readPart.getBorderColor(), readPart.getBackgroundColor())) {
                readPart.setBorderColor(ColorConstants.lightGreen);
            }
            if (!this.activeEditPartDependencies.contains(readPart)) {
                this.activeEditPartDependencies.add(readPart);
            }
            for (IProcessEditPart writePart : write) {
                if (readPart != writePart || rw.contains(part)) continue;
                rw.add(readPart);
            }
        }
        for (IProcessEditPart writePart : write) {
            if (!this.activeEditPartDependencies.contains(writePart)) {
                this.activeEditPartDependencies.add(writePart);
            }
            writePart.setBorderColor(ColorConstants.red);
            if (writePart instanceof DataElementEditPart) {
                dataFigure = (DataFigure)((DataElementEditPart)writePart).getFigure();
                dataFigure.setLineStyle(1);
                if (!this.uiSettings.isDependencyVisibilityModeOn()) continue;
                dataFigure.setVisible(true);
                edgeEditParts2 = ((DataElementEditPart)writePart).getTargetConnections();
                for (Iterator edgeEditPart : edgeEditParts2) {
                    if (((EdgeEditPart)((Object)edgeEditPart)).getSourceNodeID() != ((Node)part.getModel()).getID()) continue;
                    ((EdgeEditPart)((Object)edgeEditPart)).getFigure().setVisible(true);
                }
                continue;
            }
            if (!(writePart instanceof DefaultNodeEditPart) || !this.uiSettings.isDependencyVisibilityModeOn()) continue;
            edgeEditParts = ((DefaultNodeEditPart)writePart).getSourceConnections();
            for (Iterator<IProcessEditPart> edgeEditPart4 : edgeEditParts) {
                if (((EdgeEditPart)((Object)edgeEditPart4)).getDestNodeID() != ((DataElement)part.getModel()).getID()) continue;
                ((EdgeEditPart)((Object)edgeEditPart4)).getFigure().setVisible(true);
            }
        }
        for (IProcessEditPart rwPart : rw) {
            rwPart.setBorderColor(ColorConstants.orange);
        }
        SelectionGroup group = this.getActiveGroup();
        if (group == null) {
            return;
        }
        if (ctrl) {
            group.switchSelection(part);
            ISelection selection = group.getActiveSelection().getSelection();
            if (selection instanceof IStructuredSelection) {
                Object[] elements;
                Object[] objectArray = elements = ((IStructuredSelection)selection).toArray();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof TemplateEditPart || element instanceof BranchEditPart) {
                        group.removeEditPartFromActiveSelection((IProcessEditPart)element);
                    }
                    ++n2;
                }
            } else {
                this.logger.warning("Not an IStructuredSelection!");
            }
        } else {
            group.setSelection(part);
        }
        this.fireActiveEditPartChangedEvent();
    }

    private SelectionGroup createNewGroup(SelectionGroupDefinition definition) {
        for (SelectionGroup group : this.groups) {
            if (!group.getDefinition().getID().equals(definition.getID())) continue;
            return group;
        }
        SelectionGroup newGroup = new SelectionGroup(this, definition);
        this.groups.add(newGroup);
        newGroup.addSelectionGroupChangedListener(this);
        return newGroup;
    }

    protected void setActiveEditPart(IProcessEditPart part) {
        if (this.activeEditPart == part) {
            return;
        }
        if (this.activeEditPart != null) {
            this.activeEditPart.setFocused(false);
        }
        this.activeEditPart = part;
        if (part != null) {
            this.activeEditPart.setFocused(true);
        }
    }

    private void fireActiveEditPartChangedEvent() {
        List<?> selection = ((Selection.SelectionList)this.getActiveGroup().getActiveSelection().getSelection()).toList();
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(selection));
        ArrayList<ISelectionChangedListener> myListeners = new ArrayList<ISelectionChangedListener>(this.listeners);
        for (ISelectionChangedListener listener : myListeners) {
            listener.selectionChanged(event);
        }
    }

    private void updateSelectionDrawerEntries() {
        this.domain.setActiveTool(null);
        this.palette.resetSelectionDrawer();
        PaletteDrawer selectionDrawer = this.palette.getSelectionDrawer();
        if (this.getActiveGroup() == null) {
            return;
        }
        ArrayList<SwapSelectionToolEntry> tools = new ArrayList<SwapSelectionToolEntry>();
        SwapSelectionToolEntry newActiveToolEntry = null;
        for (SelectionDefinition def : this.getActiveGroup().getDefinition().getSelectionDefinitions()) {
            SwapSelectionToolEntry newEntry = new SwapSelectionToolEntry(this.getActiveGroup(), def);
            tools.add(newEntry);
            Selection sel = this.getActiveGroup().getActiveSelection();
            if (sel == null || sel.getDefinition().getID().compareTo(def.getID()) != 0) continue;
            newActiveToolEntry = newEntry;
        }
        selectionDrawer.setLabel(this.getActiveGroup().getDefinition().getName());
        selectionDrawer.setChildren(tools);
        if (this.domain.getPaletteViewer() != null) {
            this.domain.getPaletteViewer().setActiveTool(newActiveToolEntry);
        }
    }

    @Override
    public void selectionGroupChanged(SelectionGroupChangedEvent event) {
        if (this.getActiveGroup() != (SelectionGroup)event.getSource()) {
            return;
        }
        this.activeSelection = this.getActiveGroup().getActiveSelection();
        if (this.activeSelection == null) {
            if (this.domain.getActiveTool() != null) {
                this.domain.getPaletteViewer().setActiveTool(null);
            }
            return;
        }
        List tools = this.palette.getSelectionDrawer().getChildren();
        for (Object entry : tools) {
            SelectionDefinition def = ((SwapSelectionToolEntry)((Object)entry)).getDefinition();
            if (this.activeSelection.getDefinition().getID().compareTo(def.getID()) != 0) continue;
            Tool tool = ((ToolEntry)entry).createTool();
            if (this.domain.getActiveTool() == tool) continue;
            this.domain.getPaletteViewer().setActiveTool((ToolEntry)entry);
            return;
        }
    }

    List<IProcessEditPart> getDependencies(IProcessEditPart part, int type) {
        ArrayList<IProcessEditPart> list = new ArrayList<IProcessEditPart>();
        if (part == null || this.viewer.getRootEditPart() == null || this.viewer.getRootEditPart().getContents() == null || !(this.viewer.getRootEditPart().getContents().getModel() instanceof Template)) {
            return list;
        }
        Template template = (Template)this.viewer.getRootEditPart().getContents().getModel();
        int[] ids = null;
        Object model = part.getModel();
        boolean isDataElement = false;
        if (model instanceof Node) {
            ids = type == 0 ? template.getAccessedDataElementIDsForNode(((Node)model).getID(), ActivityConstants.AccessType.READ) : template.getAccessedDataElementIDsForNode(((Node)model).getID(), ActivityConstants.AccessType.WRITE);
        } else if (model instanceof DataElement) {
            isDataElement = true;
            ids = type == 0 ? template.getAccessingNodeIDsForDataElement(((DataElement)model).getID(), ActivityConstants.AccessType.READ) : template.getAccessingNodeIDsForDataElement(((DataElement)model).getID(), ActivityConstants.AccessType.WRITE);
        } else {
            return list;
        }
        if (isDataElement) {
            int[] nArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                list.add((IProcessEditPart)this.viewer.getEditPartRegistry().get(template.getNode(id)));
                ++n2;
            }
        } else {
            int[] nArray = ids;
            int n = ids.length;
            int n3 = 0;
            while (n3 < n) {
                int id = nArray[n3];
                list.add((IProcessEditPart)this.viewer.getEditPartRegistry().get(template.getDataElement(id)));
                ++n3;
            }
        }
        return list;
    }

    boolean sameColor(Color c1, Color c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.getRed() == c2.getRed() && c1.getGreen() == c2.getGreen() && c1.getBlue() == c2.getBlue();
    }
}

