/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.widgets;

import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.widgets.NodeFigure;
import java.util.ArrayList;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class DataFigure
extends NodeFigure {
    private String VIRTUAL_ICON = "widgets/icons/virt.png";
    private boolean isVirtual = false;
    private int lastLocation = 0;
    private DataElementEditPart editpart;

    public DataFigure(DataElementEditPart editpart) {
        this.editpart = editpart;
    }

    public void setVirtual(boolean virtual) {
        ImageRegistry imageRegistry;
        Image image = null;
        if (virtual && (image = (imageRegistry = Activator.getDefault().getImageRegistry()).get(this.VIRTUAL_ICON)) == null) {
            image = ImageDescriptor.createFromFile(Activator.class, (String)"widgets/icons/virt.png").createImage();
            imageRegistry.put(this.VIRTUAL_ICON, image);
        }
        this.setIcon(image);
        this.isVirtual = virtual;
        RectangleFigure fig = (RectangleFigure)this.container;
        fig.setLineStyle(this.isVirtual ? 2 : 3);
        fig.setLineWidth(this.isVirtual ? 1 : 2);
    }

    @Override
    public void setIcon(Image icon) {
        this.topLabel.setIcon(icon);
    }

    @Override
    protected void initializeFigure() {
        super.initializeFigure();
        this.add((IFigure)this.topLabel, 0);
    }

    public int getPreferredLocation() {
        Rectangle bounds;
        AbstractGraphicalEditPart target;
        ArrayList<Point> points = new ArrayList<Point>(0);
        for (ConnectionEditPart c : this.editpart.getSourceConnections()) {
            target = (AbstractGraphicalEditPart)c.getTarget();
            if (target == null) continue;
            bounds = target.getFigure().getBounds();
            points.add(new Point(bounds.x, bounds.y));
        }
        for (ConnectionEditPart c : this.editpart.getTargetConnections()) {
            target = (AbstractGraphicalEditPart)c.getSource();
            if (target == null) continue;
            bounds = target.getFigure().getBounds();
            points.add(new Point(bounds.x, bounds.y));
        }
        int location = 0;
        if (points.size() > 0) {
            for (Point p : points) {
                location += p.x;
            }
            location /= points.size();
        }
        if (location != this.lastLocation) {
            this.lastLocation = location;
            this.revalidate();
        }
        return location;
    }

    @Override
    protected Figure createContainer() {
        RectangleFigure rectangle = new RectangleFigure(){

            protected void outlineShape(Graphics graphics) {
                Rectangle r = this.getBounds();
                int x = r.x + this.lineWidth / 2;
                int y = r.y + this.lineWidth / 2;
                int w = r.width - Math.max(1, this.lineWidth);
                int h = r.height - Math.max(1, this.lineWidth);
                graphics.drawLine(x, y, x + w, y);
                graphics.drawLine(x, y + h, x + w, y + h);
            }
        };
        rectangle.setLineWidth(2);
        rectangle.setLineStyle(3);
        return rectangle;
    }

    @Override
    public void setSelected(boolean select) {
        if (this.container instanceof RectangleFigure) {
            ((RectangleFigure)this.container).setLineWidth(select ? 3 : 2);
        }
    }

    public DataElementEditPart getEditPart() {
        return this.editpart;
    }

    public void setLineStyle(int lineStyle) {
        RectangleFigure fig = (RectangleFigure)this.container;
        fig.setLineStyle(lineStyle);
    }

    public void resetLineStyle() {
        RectangleFigure fig = (RectangleFigure)this.container;
        fig.setLineStyle(this.isVirtual ? 2 : 3);
    }
}

