/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.widgets;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.i18n.LocalisationResolver;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.LightWeightProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.ui.icons.MiscImages;
import de.aristaflow.adept2.ui.icons.TypeImages;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.model.ModelGlue;
import de.aristaflow.adept2.ui.processvisualisation.widgets.NodeFigure;
import de.aristaflow.adept2.ui.processvisualisation.widgets.ProcessConnection;
import de.aristaflow.adept2.ui.processvisualisation.widgets.SmartToolTip;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class LabelTextFormatter {
    protected static final int ICON_HEIGTH = 16;
    protected static final int ICON_WIDTH = 16;
    protected final Logger logger = LoggerTools.getLogger((Object)this);

    public void init(GraphicalViewer viewer) {
    }

    public void format(NodeFigure figure, Object source, Instance instance, Locale locale) {
        figure.setText(source.toString(), "This class needs a LabelTextFormatter: " + source.getClass());
    }

    public void format(ProcessConnection connectionFigure, Object source, EdgeData data, Locale locale) {
        connectionFigure.setText("" + source);
    }

    Image getDescIcon(String nodeDescription) {
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        if (nodeDescription.equals("")) {
            return null;
        }
        String imageKey = "desc.gif";
        Image icon = imageRegistry.get(imageKey);
        if (icon == null) {
            Image unscaledImage = MiscImages.getImage((String)imageKey);
            icon = new Image(unscaledImage.getDevice(), unscaledImage.getImageData().scaledTo(16, 16));
            unscaledImage.dispose();
            imageRegistry.put(imageKey, icon);
        }
        return icon;
    }

    public static class DataEdgeFormatter
    extends LabelTextFormatter {
        @Override
        public void format(ProcessConnection figure, Object source, EdgeData data, Locale locale) {
            DataEdge edge = (DataEdge)source;
            switch (edge.getType()) {
                case READ: {
                    break;
                }
                case WRITE: {
                    break;
                }
                case SYSTEM_READ: {
                    break;
                }
                case SYSTEM_WRITE: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
            figure.setText(null);
            figure.setImage(null);
        }
    }

    public static class DefaultDataElementFormatter
    extends LabelTextFormatter {
        @Override
        public void format(NodeFigure figure, Object source, Instance instance, Locale locale) {
            DataElement element = (DataElement)source;
            if (element.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
                if (element.getUDTName() == null || element.getUDTName().equals("")) {
                    figure.setText(element.getName(), "UDT: <type not specified>");
                } else {
                    figure.setText(element.getName(), "UDT: " + element.getUDTName());
                }
            } else {
                figure.setText(element.getName(), element.getDataType().toString());
            }
            if (instance == null) {
                String text = element.getDescription();
                if (text == null || text.length() == 0) {
                    figure.setToolTip(null);
                } else {
                    figure.setToolTip((IFigure)new Label(text));
                }
            } else {
                new SmartToolTip(instance, element, figure);
            }
        }
    }

    public static class DefaultEdgeFormatter
    extends LabelTextFormatter {
        @Override
        public void format(ProcessConnection figure, Object source, EdgeData data, Locale locale) {
            Edge edge = (Edge)source;
            switch (edge.getType()) {
                case ET_CONTROL: 
                case ET_LOOP: {
                    if (edge.getEdgeCode() != Integer.MIN_VALUE) {
                        DecisionActivity da;
                        long[] decisionIDs;
                        Node node;
                        ExecutableBusinessProcess ebp;
                        figure.setText(Long.valueOf(edge.getEdgeCode()).toString());
                        if (data != null && (ebp = (node = data.template.getNode(data.sourceID)).getExecutableBusinessProcess()) != null && ebp instanceof DecisionActivity && (decisionIDs = (da = (DecisionActivity)ebp).getDecisionID(edge.getEdgeCode())) != null) {
                            StringBuilder decisionLabel = new StringBuilder();
                            int i = 0;
                            while (i < decisionIDs.length) {
                                long decisionID = decisionIDs[i];
                                decisionLabel.append(da.getDecisionLabel(decisionID));
                                if (i < decisionIDs.length - 1) {
                                    decisionLabel.append(" || ");
                                }
                                ++i;
                            }
                            figure.setText(decisionLabel.toString());
                        }
                    }
                    figure.setImage(null);
                    if (data == null || data.instance == null || data.sourceID == Integer.MIN_VALUE || data.destinationID == Integer.MIN_VALUE) break;
                    ProcessConstants.EdgeState state = data.instance.getEdgeState(data.sourceID, data.destinationID, edge.getType());
                    figure.setImage(ModelGlue.getEdgeIcon(state));
                    figure.setColor(ModelGlue.getEdgeColor(state));
                    break;
                }
                case ET_SYNC: {
                    figure.setImage(null);
                    if (data == null || data.instance == null || data.sourceID == Integer.MIN_VALUE || data.destinationID == Integer.MIN_VALUE) break;
                    ProcessConstants.EdgeState state = data.instance.getEdgeState(data.sourceID, data.destinationID, edge.getType());
                    figure.setImage(ModelGlue.getEdgeIcon(state));
                    figure.setColor(ModelGlue.getEdgeColor(state));
                    break;
                }
                default: {
                    this.logger.severe("Edge type not supported");
                }
            }
        }
    }

    public static class DefaultNodeFormatter
    extends LabelTextFormatter {
        private static final FontRegistry fontManager = new FontRegistry(Display.getDefault());

        @Override
        public void format(NodeFigure figure, Object source, Instance instance, Locale locale) {
            Node node = (Node)source;
            if (locale != null) {
                node = (Node)LocalisationResolver.createLocalisedView(Node.class, (PluginDataContainer)node, (Locale)locale);
            }
            String labelNodeName = node.getName().equals("") ? "#" + node.getID() : node.getName();
            Image primaryIcon = null;
            String secondary = this.getSecondaryLabel(node);
            Image secondaryIcon = null;
            figure.setText(labelNodeName, primaryIcon, secondary, secondaryIcon);
            if (!fontManager.hasValueFor("SecondaryLabel")) {
                fontManager.put("SecondaryLabel", fontManager.defaultFontDescriptor().increaseHeight(-2).getFontData());
            }
            Font font = fontManager.get("SecondaryLabel");
            figure.secondaryLabel.setFont(font);
            String toolTipText = this.getToolTipText(node, instance, labelNodeName);
            figure.setToolTipText(toolTipText);
            if (instance != null) {
                ProcessConstants.NodeState state = instance.getNodeState(node.getID());
                int iteration = instance.getNodeIteration(node.getID());
                figure.setTopLabel(ModelGlue.getNodeIcon(state), iteration > 0 ? "" + iteration : null);
                figure.setBackgroundColor(ModelGlue.getNodeColor(state));
            }
            figure.setDescIcon(this.getDescIcon(node.getDescription()));
            figure.setSARIcon(this.getSARIcon(node.getStaffAssignmentRule()));
            figure.setEBPIcon(this.getEBPIcon(node.getExecutableBusinessProcess()));
        }

        protected String getToolTipText(Node node, Instance instance, String labelNodeName) {
            QualifiedAgent agent;
            String ebp = "(none)";
            if (node.getExecutableBusinessProcess() != null) {
                ebp = node.getExecutableBusinessProcess() instanceof Activity ? ((Activity)node.getExecutableBusinessProcess()).getExecutableComponentName() : "(subprocess)";
            }
            String sar = "SAR: (none)";
            if (node.getStaffAssignmentRule() != null && !node.getStaffAssignmentRule().equals("")) {
                sar = "SAR " + node.getStaffAssignmentRule();
            }
            if (instance != null && (agent = instance.getPerformingAgent(node.getID())) != null) {
                sar = "Executed by: " + agent.getAgentUserName() + ", OrgPosition: " + agent.getOrgPositionName();
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" ").append(labelNodeName).append(" \n");
            stringBuilder.append(" EBP:  ").append(ebp);
            stringBuilder.append(" \n");
            stringBuilder.append(" ").append(sar).append(" ");
            return stringBuilder.toString();
        }

        protected String getSecondaryLabel(Node node) {
            return null;
        }

        Image getSARIcon(String staffAssignmentRule) {
            ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
            if (staffAssignmentRule.equals("")) {
                return null;
            }
            String imageKey = "person.png";
            Image icon = imageRegistry.get(imageKey);
            if (icon == null) {
                Image unscaledImage = MiscImages.getImage((String)imageKey);
                icon = new Image(unscaledImage.getDevice(), unscaledImage.getImageData().scaledTo(16, 16));
                unscaledImage.dispose();
                imageRegistry.put(imageKey, icon);
            }
            return icon;
        }

        Image getEBPIcon(ExecutableBusinessProcess ebp) {
            String imageKey;
            ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
            Image icon = imageRegistry.get(imageKey = ebp instanceof Activity ? ((Activity)ebp).getExecutableComponentName() : (ebp instanceof LightWeightProcess || ebp instanceof VariableParallelismEBP ? "LWP" : "EMPTY"));
            if (icon == null) {
                ImageDescriptor descriptor = TypeImages.getDescriptor((String)imageKey, (TypeImages.IconSize)TypeImages.IconSize.x16);
                Image unscaledImage = descriptor.createImage();
                icon = new Image(unscaledImage.getDevice(), unscaledImage.getImageData().scaledTo(16, 16));
                unscaledImage.dispose();
                imageRegistry.put(imageKey, icon);
            }
            return icon;
        }
    }

    public static class EdgeData {
        public int sourceID;
        public int destinationID;
        public ProcessConstants.EdgeType type;
        public Instance instance;
        public Template template;

        public EdgeData(int sourceID, int destinationID, ProcessConstants.EdgeType type, Template template, Instance instance) {
            this.sourceID = sourceID;
            this.destinationID = destinationID;
            this.type = type;
            this.template = template;
            this.instance = instance;
        }

        public String toString() {
            return String.valueOf(this.sourceID) + "->" + this.destinationID + ":" + this.type;
        }
    }

    public static class NullFormatter
    extends LabelTextFormatter {
        @Override
        public void format(ProcessConnection figure, Object source, EdgeData data, Locale locale) {
            figure.setText(null);
            figure.setImage(null);
        }

        @Override
        public void format(NodeFigure figure, Object source, Instance instance, Locale locale) {
            figure.setText("", null);
        }
    }

    public static class SimpleNodeFormatter
    extends LabelTextFormatter {
        @Override
        public void format(NodeFigure figure, Object source, Instance instance, Locale locale) {
            Node node = (Node)source;
            if (locale != null) {
                node = (Node)LocalisationResolver.createLocalisedView(Node.class, (PluginDataContainer)node, (Locale)locale);
            }
            String name = node.getName();
            figure.setText(name, null);
        }
    }
}

