/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.widgets;

import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.ui.processvisualisation.widgets.LabelTextFormatter;
import de.aristaflow.adept2.ui.processvisualisation.widgets.NodeFigure;
import de.aristaflow.adept2.ui.processvisualisation.widgets.ProcessConnection;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.gef.GraphicalViewer;

public class LabelTextProvider {
    protected HashMap<Class<?>, LabelTextFormatter> providerMap = new HashMap();
    protected GraphicalViewer viewer;
    protected Locale locale;

    public LabelTextProvider(GraphicalViewer viewer, Locale locale) {
        this.viewer = viewer;
        this.locale = locale;
        this.installDefaultFormatters();
    }

    private void installDefaultFormatters() {
        this.addLabelTextFormatter(Node.class, new LabelTextFormatter.DefaultNodeFormatter());
        this.addLabelTextFormatter(DataElement.class, new LabelTextFormatter.DefaultDataElementFormatter());
        this.addLabelTextFormatter(Edge.class, new LabelTextFormatter.DefaultEdgeFormatter());
        this.addLabelTextFormatter(DataEdge.class, new LabelTextFormatter.DataEdgeFormatter());
    }

    public void addLabelTextFormatter(Class<?> source, LabelTextFormatter formatter) {
        this.providerMap.put(source, formatter);
        formatter.init(this.viewer);
    }

    public void removeLabelTextFormatter(Class<?> source) {
        this.providerMap.remove(source);
    }

    public void formatLabel(NodeFigure figure, Object source, Instance instance) {
        this.findFormatter(source).format(figure, source, instance, this.locale);
    }

    protected LabelTextFormatter findFormatter(Object source) {
        for (Class<?> c : this.providerMap.keySet()) {
            if (!c.isInstance(source)) continue;
            return this.providerMap.get(c);
        }
        return new LabelTextFormatter();
    }

    public void formatLabel(ProcessConnection connectionFigure, Object source, LabelTextFormatter.EdgeData data) {
        this.findFormatter(source).format(connectionFigure, source, data, this.locale);
    }
}

