/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.widgets;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.FocusBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class NodeFigure
extends Figure {
    protected Label primaryLabel = new Label();
    protected Label secondaryLabel = new Label();
    protected Label topLabel = new Label();
    protected Label bottomLabel = new Label();
    protected ImageFigure ebpIcon = new ImageFigure();
    protected ImageFigure sarIcon = new ImageFigure();
    protected ImageFigure descIcon = new ImageFigure();
    protected ImageFigure durationIcon = new ImageFigure();
    protected ImageFigure fixedDateIcon = new ImageFigure();
    protected ImageFigure scheduleIcon = new ImageFigure();
    protected ImageFigure validityIcon = new ImageFigure();
    protected Label toolTipLabel = new Label();
    protected Figure container;
    protected Figure bottomContainer;
    protected Figure focusBorder;
    private Color textColor = ColorConstants.black;
    private Figure topContainer;
    public static final Border BORDER_NOTSELECTED = new MarginBorder(2);
    public static final Border BORDER_SELECTED = new LineBorder(ColorConstants.black, 2);
    public static final Border BORDER_NOFOCUS = new MarginBorder(2);
    public static final Border BORDER_FOCUS = new FocusBorder(){

        public Insets getInsets(IFigure figure) {
            return new Insets(2);
        }
    };

    public NodeFigure() {
        this.initializeFigure();
    }

    protected void initializeFigure() {
        FlowLayout layout = new FlowLayout(false);
        this.setLayoutManager((LayoutManager)layout);
        layout.setMinorAlignment(2);
        layout.setMajorSpacing(0);
        layout.setMinorSpacing(0);
        this.setBorder(BORDER_NOTSELECTED);
        this.container = this.createContainer();
        this.container.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        this.container.setBorder(BORDER_NOTSELECTED);
        this.bottomContainer = new Figure();
        ToolbarLayout toolbarLayout = new ToolbarLayout(true);
        toolbarLayout.setMinorAlignment(2);
        this.bottomContainer.setLayoutManager((LayoutManager)toolbarLayout);
        this.topContainer = this.bottomContainer;
        this.focusBorder = new RectangleFigure(){

            public Insets getInsets() {
                Insets inset = new Insets(2);
                return inset;
            }

            protected void fillShape(Graphics arg0) {
            }

            protected void outlineShape(Graphics arg0) {
            }
        };
        this.focusBorder.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        this.focusBorder.setBorder(BORDER_NOFOCUS);
        this.focusBorder.add((IFigure)this.container);
        this.add((IFigure)this.focusBorder);
        this.add((IFigure)this.bottomContainer);
        this.setToolTip((IFigure)this.toolTipLabel);
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipLabel.setText(toolTipText);
    }

    public void setText(String primary, String secondary) {
        this.setText(primary, this.primaryLabel.getIcon(), secondary, this.secondaryLabel.getIcon());
    }

    public void setText(String primary, Image primaryIcon, String secondary, Image secondaryIcon) {
        int i;
        String spaces;
        if (this.container.getChildren().size() > 0) {
            this.container.removeAll();
        }
        if (primary != null) {
            spaces = "";
            i = 0;
            while (i < primary.length() / 4) {
                spaces = String.valueOf(spaces) + " ";
                ++i;
            }
            this.primaryLabel.setText(String.valueOf(primary) + spaces);
            this.primaryLabel.setIcon(primaryIcon);
            this.container.add((IFigure)this.primaryLabel);
        }
        if (secondary != null) {
            spaces = "";
            i = 0;
            while (i < secondary.length() / 4) {
                spaces = String.valueOf(spaces) + " ";
                ++i;
            }
            this.secondaryLabel.setText(String.valueOf(secondary) + spaces);
            this.secondaryLabel.setIcon(secondaryIcon);
            this.container.add((IFigure)this.secondaryLabel);
        }
    }

    public void setTopLabel(Image icon, String text) {
        if (this.getChildren().contains(this.topLabel)) {
            this.remove((IFigure)this.topLabel);
        }
        this.topLabel.setIcon(icon);
        this.topLabel.setText(text);
        if (icon != null || text != null) {
            this.add((IFigure)this.topLabel, 0);
        }
    }

    public void setIcon(Image icon) {
        this.setTopLabel(icon, null);
    }

    public Image getEBPIcon() {
        return this.ebpIcon.getImage();
    }

    public void setEBPIcon(Image icon) {
        if (this.bottomContainer.getChildren().contains(this.ebpIcon)) {
            this.bottomContainer.remove((IFigure)this.ebpIcon);
        }
        this.ebpIcon.setImage(icon);
        if (icon != null) {
            this.bottomContainer.add((IFigure)this.ebpIcon);
        }
    }

    public Image getSARIcon() {
        return this.sarIcon.getImage();
    }

    public void setSARIcon(Image icon) {
        if (this.bottomContainer.getChildren().contains(this.sarIcon)) {
            this.bottomContainer.remove((IFigure)this.sarIcon);
        }
        this.sarIcon.setImage(icon);
        if (icon != null) {
            this.bottomContainer.add((IFigure)this.sarIcon);
        }
    }

    public Image getDescIcon() {
        return this.descIcon.getImage();
    }

    public void setDescIcon(Image icon) {
        if (this.bottomContainer.getChildren().contains(this.descIcon)) {
            this.bottomContainer.remove((IFigure)this.descIcon);
        }
        this.descIcon.setImage(icon);
        if (icon != null) {
            this.bottomContainer.add((IFigure)this.descIcon);
        }
    }

    public Image getDurationIcon() {
        return this.durationIcon.getImage();
    }

    public void setDurationIcon(Image icon) {
        if (this.topContainer.getChildren().contains(this.durationIcon)) {
            this.topContainer.remove((IFigure)this.durationIcon);
        }
        this.durationIcon.setImage(icon);
        if (icon != null) {
            this.topContainer.add((IFigure)this.durationIcon);
        }
    }

    public ImageFigure getFixedDateIcon() {
        return this.fixedDateIcon;
    }

    public void setFixedDateIcon(Image icon) {
        if (this.topContainer.getChildren().contains(this.fixedDateIcon)) {
            this.topContainer.remove((IFigure)this.fixedDateIcon);
        }
        this.fixedDateIcon.setImage(icon);
        if (icon != null) {
            this.topContainer.add((IFigure)this.fixedDateIcon);
        }
    }

    public ImageFigure getScheduleIcon() {
        return this.scheduleIcon;
    }

    public void setScheduleIcon(Image icon) {
        if (this.topContainer.getChildren().contains(this.scheduleIcon)) {
            this.topContainer.remove((IFigure)this.scheduleIcon);
        }
        this.scheduleIcon.setImage(icon);
        if (icon != null) {
            this.topContainer.add((IFigure)this.scheduleIcon);
        }
    }

    public ImageFigure getValidityIcon() {
        return this.validityIcon;
    }

    public void setValidityIcon(Image icon) {
        if (this.topContainer.getChildren().contains(this.validityIcon)) {
            this.topContainer.remove((IFigure)this.validityIcon);
        }
        this.validityIcon.setImage(icon);
        if (icon != null) {
            this.topContainer.add((IFigure)this.validityIcon);
        }
    }

    public void setComment(String text) {
        if (this.getChildren().contains(this.bottomLabel)) {
            this.remove((IFigure)this.bottomLabel);
        }
        this.bottomLabel.setText(text);
        if (text != null) {
            this.add((IFigure)this.bottomLabel);
        }
    }

    protected Figure createContainer() {
        RoundedRectangle figure = new RoundedRectangle(){

            public Insets getInsets() {
                Insets decoration = new Insets(5);
                if (this.getBorder() != null) {
                    decoration.add(this.getBorder().getInsets((IFigure)this));
                }
                return decoration;
            }
        };
        figure.setCornerDimensions(new Dimension(5, 5));
        return figure;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
        this.primaryLabel.setForegroundColor(color);
        this.secondaryLabel.setForegroundColor(color);
        this.topLabel.setForegroundColor(color);
        this.bottomLabel.setForegroundColor(color);
    }

    public void setBorderColor(Color color) {
        this.container.setForegroundColor(color);
        this.setTextColor(this.textColor);
    }

    public void setForegroundColor(Color color) {
        this.setTextColor(color);
        this.setBorderColor(color);
    }

    public void setBackgroundColor(Color color) {
        this.container.setBackgroundColor(color);
    }

    public void setSelected(boolean select) {
        this.container.setBorder(select ? BORDER_SELECTED : BORDER_NOTSELECTED);
        this.repaint();
    }

    public void setFocused(boolean focus) {
        this.focusBorder.setBorder(focus ? BORDER_FOCUS : BORDER_NOFOCUS);
        this.repaint();
    }

    public IFigure getAnchorFigure() {
        return this.container;
    }

    public void setErrorIcon(Image icon) {
        this.primaryLabel.setIcon(icon);
    }

    public Label getPrimaryLabel() {
        return this.primaryLabel;
    }
}

