/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.widgets;

import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.ui.processvisualisation.parts.LabelLocator;
import org.eclipse.draw2d.AbstractLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ProcessConnection
extends PolylineConnection {
    protected Label label;
    AbstractLocator locator;
    public static final int SELECTED_LINE_WIDTH = 2;
    public static final int UNSELECTED_LINE_WIDTH = 1;
    public static final int FOCUS_LINE_WIDTH = 2;

    public ProcessConnection() {
        this(null);
    }

    public ProcessConnection(String text) {
        this.createFigure();
        this.setText(text);
        this.setImage(null);
        this.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
    }

    public void setText(String text) {
        if (text == null) {
            this.label.setText(null);
            this.label.setVisible(false);
        } else {
            this.label.setText(text);
            this.label.setVisible(true);
            this.label.setToolTip((IFigure)new Label(text));
        }
    }

    public void setImage(Image image) {
        this.label.setIcon(image);
        this.label.setVisible(true);
    }

    protected void createFigure() {
        this.label = this.createLabel();
        this.add((IFigure)this.label);
        this.locator = new LabelLocator((Connection)this);
        this.locator.setRelativePosition(1);
        this.locator.setGap(2);
        this.getLayoutManager().setConstraint((IFigure)this.label, (Object)this.locator);
    }

    protected Label createLabel() {
        Label label = new Label();
        label.setOpaque(false);
        return label;
    }

    public void setSelected(int value) {
        switch (value) {
            case 0: {
                this.setLineWidth(1);
                break;
            }
            case 1: {
                this.setLineWidth(2);
                break;
            }
            case 2: {
                this.setLineWidth(2);
            }
        }
    }

    public void setColor(Color color) {
        this.setForegroundColor(color);
    }

    public static class CircleDecoration
    extends Ellipse
    implements RotatableDecoration {
        int diameter;

        public CircleDecoration(int diameter) {
            this.diameter = diameter;
        }

        public void setReferencePoint(Point p) {
            this.setBounds(new Rectangle(this.getLocation().x - this.diameter / 2, this.getLocation().y - this.diameter / 2 - 1, this.diameter, this.diameter));
        }

        protected void fillShape(Graphics graphics) {
            super.fillShape(graphics);
        }

        protected void outlineShape(Graphics graphics) {
            super.outlineShape(graphics);
        }
    }

    public static class ConstraintConnection
    extends ProcessConnection {
        private static final Vector DOWN = new Vector(0.0, 1.0);
        private static final Vector UP = new Vector(0.0, -1.0);
        private final ConstraintEdge constraintEdge;
        private int curveDepth = 0;
        private boolean inverse = false;
        private static final float PI = 3.14159f;
        private RectangleFigure center = new RectangleFigure();

        public ConstraintConnection(ConstraintEdge constraintEdge) {
            this.constraintEdge = constraintEdge;
            this.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
            this.setLineStyle(6);
            this.setLineDash(new float[]{2.0f, 4.0f});
            this.curveDepth = 40;
        }

        public ConstraintEdge getConstraintEdge() {
            return this.constraintEdge;
        }

        public void setDepth(int depth) {
            this.inverse = depth < 0;
            this.curveDepth = depth;
            this.updateArc(this.getPoints());
        }

        @Override
        protected void createFigure() {
            this.label = this.createLabel();
            this.add((IFigure)this.label);
            this.locator = new ConnectionLocator((Connection)this);
            this.locator.setRelativePosition(4);
            this.locator.setGap(2);
            this.getLayoutManager().setConstraint((IFigure)this.label, (Object)this.locator);
        }

        public void addPoint(Point pt) {
        }

        public void setPoints(PointList points) {
            this.updateArc(points);
        }

        protected void updateArc(PointList pointList) {
            if (pointList.size() < 2) {
                return;
            }
            if (this.center.getParent() == this) {
                this.remove((IFigure)this.center);
            }
            pointList.getFirstPoint();
            pointList.getLastPoint();
            if (this.curveDepth == 0) {
                super.setPoints(pointList);
                return;
            }
            PrecisionPoint prev = new PrecisionPoint(this.getSourceAnchor().getOwner().getBounds().getCenter());
            new PrecisionPoint(this.getTargetAnchor().getOwner().getBounds().getCenter());
            PointList points = new PointList();
            int d = this.curveDepth / pointList.size();
            boolean inv = this.inverse;
            PrecisionPoint p1 = new PrecisionPoint(pointList.getFirstPoint());
            Vector prevDir = p1.preciseY() - prev.preciseY() > 0.0 ? DOWN : UP;
            int i = 1;
            while (i < pointList.size()) {
                float cd;
                PrecisionPoint p2 = new PrecisionPoint(pointList.getPoint(i));
                Vector v = new Vector(p1, p2);
                float f = cd = v.getLength() / 6.0 < (double)d ? (float)v.getLength() / 6.0f : (float)d;
                Point lastSegPoint = v.getCrossProduct(prevDir) < 0.0 ? this.arcSegment((Point)p1, (Point)p2, points, -cd, !inv) : this.arcSegment((Point)p1, (Point)p2, points, cd, inv);
                prevDir = new Vector(new PrecisionPoint(lastSegPoint), p2);
                p1 = p2;
                ++i;
            }
            points.addPoint((Point)p1);
            super.setPoints(points);
        }

        private Point arcSegment(Point start, Point end, PointList points, float depth, boolean inverse) {
            float step;
            float arcStart = 0.0f;
            float arcEnd = 0.0f;
            float arcLength = 0.0f;
            float cartCenterX = 0.0f;
            float cartCenterY = 0.0f;
            float r = 0.0f;
            float x1 = start.x;
            float y1 = -start.y;
            float x2 = end.x;
            float y2 = -end.y;
            if (start.equals((Object)end)) {
                arcStart = -1.570795f;
                arcLength = 6.28318f;
                cartCenterX = x1;
                cartCenterY = y1 + depth / 2.0f;
                r = depth / 2.0f;
            } else {
                float th1;
                if (x1 >= x2) {
                    depth = -depth;
                }
                float cartChordX = (x2 + x1) / 2.0f;
                float cartChordY = (y2 + y1) / 2.0f;
                float chordLength = (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
                if (Math.abs(depth) >= chordLength / 2.0f) {
                    depth = chordLength / 3.0f * (depth / Math.abs(depth));
                }
                r = (chordLength / 2.0f * (chordLength / 2.0f) + depth * depth) / (2.0f * depth);
                float chordNormal = 0.0f;
                chordNormal = (double)Math.abs(x1 - x2) <= 1.0E-6 ? Float.NaN : ((double)Math.abs(y1 - y2) <= 1.0E-6 ? Float.POSITIVE_INFINITY : -1.0f * (y2 - y1) / (x2 - x1));
                if (Float.isNaN(chordNormal)) {
                    cartCenterX = y1 > y2 ? cartChordX - r + depth : cartChordX + r - depth;
                    cartCenterY = cartChordY;
                    th1 = 1.570795f;
                } else if (Float.isInfinite(chordNormal)) {
                    cartCenterX = cartChordX;
                    cartCenterY = cartChordY + r - depth;
                    th1 = 0.0f;
                } else {
                    th1 = (float)Math.atan(chordNormal);
                    cartCenterX = (r - depth) * (float)Math.sin(th1) + cartChordX;
                    cartCenterY = (r - depth) * (float)Math.cos(th1) + cartChordY;
                }
                float cartArcX1 = x1 - cartCenterX;
                float cartArcY1 = y1 - cartCenterY;
                float cartArcX2 = x2 - cartCenterX;
                float cartArcY2 = y2 - cartCenterY;
                arcStart = this.angleRadians(cartArcX1, cartArcY1);
                arcEnd = this.angleRadians(cartArcX2, cartArcY2);
                if (arcEnd < arcStart) {
                    arcEnd = arcEnd + 3.14159f + 3.14159f;
                }
                arcLength = arcEnd - arcStart;
                float pad = 3.14159f / Math.abs(r);
                arcLength = (arcEnd -= pad) - (arcStart += pad);
                if (inverse) {
                    arcLength = 6.28318f - arcLength;
                }
            }
            r = Math.abs(r);
            float x = 0.0f;
            float y = 0.0f;
            Point p = null;
            points.addPoint(start);
            float length = arcLength * r;
            int steps = (int)length / 16;
            if (steps < 5 && length > 10.0f) {
                steps = 5;
            }
            if (arcLength < 0.7853975f && steps > 6) {
                steps = 6;
            }
            if (steps < 4 && length > 4.0f) {
                steps = 4;
            }
            float stepSize = arcLength / (float)steps;
            if (inverse) {
                step = arcStart - stepSize;
                int i = 1;
                while (i < steps) {
                    x = r * (float)Math.cos(step) + cartCenterX;
                    y = r * (float)Math.sin(step) + cartCenterY;
                    p = new Point(Math.round(x), Math.round(-y));
                    points.addPoint(p);
                    ++i;
                    step -= stepSize;
                }
            } else {
                step = stepSize + arcStart;
                int i = 1;
                while (i < steps) {
                    x = r * (float)Math.cos(step) + cartCenterX;
                    y = r * (float)Math.sin(step) + cartCenterY;
                    p = new Point(Math.round(x), Math.round(-y));
                    points.addPoint(p);
                    ++i;
                    step += stepSize;
                }
            }
            return p;
        }

        float angleRadians(float x, float y) {
            float theta = (float)Math.atan(y / x);
            switch (this.findQuadrant(x, y)) {
                case 1: {
                    return theta;
                }
                case 2: {
                    return theta + 3.14159f;
                }
                case 4: {
                    return theta + 6.28318f;
                }
                case 3: {
                    return theta + 3.14159f;
                }
            }
            return theta;
        }

        protected int findQuadrant(float x, float y) {
            if (y > 0.0f) {
                if (x > 0.0f) {
                    return 1;
                }
                return 2;
            }
            if (x > 0.0f) {
                return 4;
            }
            return 3;
        }

        public int getDepth() {
            return this.curveDepth;
        }
    }

    public static class DataEdgeConnection
    extends ProcessConnection {
        public DataEdgeConnection() {
            this.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
            this.setLineStyle(2);
            this.remove((IFigure)this.label);
        }
    }

    public static class LoopConnection
    extends ProcessConnection {
        public LoopConnection() {
            this.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
            this.setSourceDecoration(new CircleDecoration(7));
            this.setLineStyle(1);
        }

        public Object getRoutingConstraint() {
            return "LOOP_EDGE";
        }
    }

    public static class SyncConnection
    extends ProcessConnection {
        public SyncConnection() {
            this.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
            this.setLineStyle(2);
        }
    }
}

