/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processvisualisation.widgets;

import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.datamanager.DataManager;
import de.aristaflow.adept2.core.datamanager.ProcessUnawareAccess;
import de.aristaflow.adept2.core.datamanager.tools.DataManagerTools;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.util.LoggerTools;
import java.net.URI;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;

public class SmartToolTip
extends Label
implements ActionListener,
MouseListener {
    private Instance instance;
    private DataElement element;
    static Logger logger = LoggerTools.getLogger(SmartToolTip.class);

    public SmartToolTip(Instance instance, DataElement element, Figure figure) {
        super("(Click the data element to refresh the value)");
        this.instance = instance;
        this.element = element;
        figure.setToolTip((IFigure)this);
        figure.addMouseListener((MouseListener)this);
    }

    public void actionPerformed(ActionEvent event) {
        this.updateValue();
    }

    private void updateValue() {
        String tooltip;
        try {
            SessionToken session = Activator.getService().getSessionToken();
            QualifiedAgent activeAgent = Activator.getService().getActiveAgent().getQualifiedAgent();
            URI[] dataManager = Activator.getService().getExecutionManager().getDataManager(session, this.instance.getID());
            ProcessUnawareAccess pua = ((DataManager)Activator.getService().getService(session, dataManager, DataManager.class)).getProcessUnawareAccess();
            tooltip = DataManagerTools.getStringRepresentationForDataElementContent((SessionToken)session, (ProcessUnawareAccess)pua, (UUID)this.instance.getID(), (int)this.element.getID(), (ProcessConstants.AdeptDataType)this.element.getDataType(), (QualifiedAgent)activeAgent);
        }
        catch (ServiceNotKnownException snke) {
            tooltip = "(an internal error occurred)";
            String msg = String.format("The data manager providing the value of the data element '%s' of process instance '%s' could not be retrieved.", this.element.getID(), this.instance.getID());
            logger.log(Level.SEVERE, msg, snke);
        }
        catch (InvalidDataTypeException e) {
            tooltip = "(an internal error occurred)";
            String message = "An invalid data type exception has been thrown by the data manager tool - this is an internal error: The data element type of my instance, did not match the data element type known in the data manager.";
            logger.log(Level.SEVERE, message, e);
        }
        this.setText(String.valueOf(tooltip) + "  (Click to refresh)");
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
        this.updateValue();
    }
}

