/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.dataelementview;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.changeoperations.UpdateDataElement;
import de.aristaflow.adept2.core.updatemanager.ChangeListener;
import de.aristaflow.adept2.core.updatemanager.PropertyChangeEvent;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.AttributeFactory;
import de.aristaflow.adept2.model.filter.ComparisonFilter;
import de.aristaflow.adept2.model.filter.ComparisonOperator;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.FilterFactory;
import de.aristaflow.adept2.model.filter.MultipleFilterFilter;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.tools.ProcessElementIdentifierTools;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.ui.dataelementview.Activator;
import de.aristaflow.adept2.ui.icons.MiscImages;
import de.aristaflow.adept2.ui.processediting.wizards.DataElementWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.StringBasedComboBoxCellEditor;
import de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser;
import de.aristaflow.adept2.ui.processvisualisation.UISettings;
import de.aristaflow.adept2.ui.processvisualisation.parts.DataElementEditPart;
import de.aristaflow.adept2.ui.processvisualisation.parts.IProcessEditPart;
import de.aristaflow.adept2.ui.util.columnlayout.ColumnData;
import de.aristaflow.adept2.ui.util.list.AdeptFilterWrapper;
import de.aristaflow.adept2.ui.util.list.FilteredListUIComponent;
import de.aristaflow.adept2.ui.util.list.ImageColumnLabelProvider;
import de.aristaflow.adept2.ui.util.list.QuickSearchFilterProvider;
import de.aristaflow.adept2.util.CheckReport;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DataElementView
extends ViewPart
implements IPartListener,
ITabbedPropertySheetPageContributor,
ISelectionChangedListener,
PropertyChangeListener {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".DataElementView";
    protected DataElementListUIComponent viewer;
    private static final String NAME_PROPERTY = "name";
    private static final String ID_PROPERTY = "id";
    private static final String TYPE_PROPERTY = "type";
    private static final String PUBLIC_PROPERTY = "public";
    private static final String UDT_PROPERTY = "udt";
    ProcessVisualiser currentProcVis;
    protected final UpdateManager updateManager = Activator.getService().getUpdateManager();

    public void createPartControl(Composite parent) {
        this.viewer = new DataElementListUIComponent(parent);
        this.getSite().registerContextMenu(this.viewer.getContextMenu(), (ISelectionProvider)this.viewer.getColumnViewer());
        if (this.getSite().getPage() != null) {
            this.getSite().getPage().addPartListener((IPartListener)this);
        }
        this.updateEditor(this.getSite().getPage().getActiveEditor());
        this.viewer.getColumnViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.getColumnViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ChangeableTemplate template;
                TableItem[] selection = ((Table)DataElementView.this.viewer.getColumnControl()).getSelection();
                if (selection.length != 1) {
                    return;
                }
                SessionToken session = Activator.getService().getSessionToken();
                DataElement dataElement = (DataElement)selection[0].getData();
                ChangeableInstance instance = DataElementView.this.currentProcVis.getInstance() instanceof ChangeableInstance ? (ChangeableInstance)DataElementView.this.currentProcVis.getInstance() : null;
                ChangeableTemplate changeableTemplate = template = instance == null && DataElementView.this.currentProcVis.getTemplate() instanceof ChangeableTemplate ? (ChangeableTemplate)DataElementView.this.currentProcVis.getTemplate() : null;
                if (template != null || instance != null) {
                    DataElementWizard.openForChanging((Shell)DataElementView.this.viewer.getColumnControl().getShell(), (ChangeableTemplate)template, (ChangeableInstance)instance, (UpdateManager)DataElementView.this.updateManager, (DataElement)dataElement, (SessionToken)session);
                }
            }
        });
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            this.updateEditor((IEditorPart)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.currentProcVis) {
            this.editorRemoved();
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(type);
    }

    public String getContributorId() {
        return "de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser";
    }

    public synchronized void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)event.getSelection();
            Iterator iterator = sel.iterator();
            if (sel.getFirstElement() instanceof EditPart) {
                ArrayList<DataElement> dataElements = new ArrayList<DataElement>(sel.size());
                while (iterator.hasNext()) {
                    Object nextPart = iterator.next();
                    if (!(nextPart instanceof DataElementEditPart)) continue;
                    DataElementEditPart dataElementEditPart = (DataElementEditPart)nextPart;
                    DataElement dataElement = (DataElement)dataElementEditPart.getModel();
                    dataElements.add(dataElement);
                }
                this.viewer.getColumnViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
                this.viewer.getColumnViewer().setSelection((ISelection)new StructuredSelection(dataElements));
                this.viewer.getColumnViewer().addSelectionChangedListener((ISelectionChangedListener)this);
            } else if (sel.getFirstElement() instanceof DataElement) {
                this.currentProcVis.getSelectionManager().removeSelectionChangedListener((ISelectionChangedListener)this);
                EditPart part = null;
                boolean firstElement = true;
                DataElement dataElement = null;
                while (iterator.hasNext()) {
                    dataElement = (DataElement)iterator.next();
                    part = (EditPart)this.currentProcVis.getGraphicalViewer().getEditPartRegistry().get(dataElement);
                    IProcessEditPart dataElementEditPart = (IProcessEditPart)part;
                    this.currentProcVis.getSelectionManager().editPartClicked(dataElementEditPart, !firstElement);
                    firstElement = false;
                }
                this.currentProcVis.getSelectionManager().addSelectionChangedListener((ISelectionChangedListener)this);
                UISettings settings = this.currentProcVis.getUISettings();
                Template template = this.currentProcVis.getTemplate();
                if (part != null && dataElement != null && (ProcessModelTools.isDecisionDataElement((Template)template, (int)dataElement.getID()) && settings.isDecisionDataElementVisible() || ProcessModelTools.isSystemDataElement((Template)template, (int)dataElement.getID()) && settings.isSystemDataElementVisible() || settings.isDataElementsVisible())) {
                    this.currentProcVis.getGraphicalViewer().reveal(part);
                }
            }
        }
    }

    protected void setSelectionProvider(ISelectionProvider provider) {
        this.getSite().setSelectionProvider(provider);
    }

    private void updateEditor(IEditorPart editorPart) {
        if (this.currentProcVis == editorPart) {
            return;
        }
        if (this.currentProcVis != null) {
            this.editorRemoved();
        }
        if (editorPart != null && editorPart instanceof ProcessVisualiser) {
            this.processVisualiserSet((ProcessVisualiser)editorPart);
        }
    }

    private void updateDataElementCount() {
        Object input = this.viewer.getColumnViewer().getInput();
        if (input instanceof Collection) {
            int dataElementCount = ((Collection)input).size();
            String msg = "%d data elements";
            msg = String.format(msg, dataElementCount);
            this.setContentDescription(msg);
        } else {
            this.setContentDescription("");
        }
    }

    private void editorRemoved() {
        if (this.currentProcVis.getSelectionManager() != null) {
            this.currentProcVis.getSelectionManager().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.currentProcVis.getUISettings().removeUIListener((PropertyChangeListener)this);
        this.currentProcVis = null;
        this.setSelectionProvider(null);
        this.viewer.setInput(null, null);
        this.updateDataElementCount();
    }

    private void processVisualiserSet(ProcessVisualiser procVis) {
        this.currentProcVis = procVis;
        Template template = this.currentProcVis.getTemplate();
        this.viewer.setInput(template, this.currentProcVis.getInstance());
        this.updateDataElementCount();
        this.currentProcVis.getUISettings().addUIListener((PropertyChangeListener)this);
        if (this.currentProcVis.getSelectionManager() != null) {
            this.currentProcVis.getSelectionManager().addSelectionChangedListener((ISelectionChangedListener)this);
            this.setSelectionProvider((ISelectionProvider)this.currentProcVis.getSelectionManager());
            IProcessEditPart activePart = this.currentProcVis.getSelectionManager().getActiveEditPart();
            if (activePart instanceof DataElementEditPart) {
                DataElement dataElement = (DataElement)activePart.getModel();
                this.viewer.getColumnViewer().setSelection((ISelection)new StructuredSelection((Object)dataElement));
            }
        }
    }

    public ProcessVisualiser getCurrentProcessVisualiser() {
        return this.currentProcVis;
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener)this);
        if (this.currentProcVis != null) {
            this.editorRemoved();
        }
        this.currentProcVis = null;
        super.dispose();
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent arg0) {
        this.viewer.getColumnViewer().refresh();
        this.updateDataElementCount();
    }

    public class DataElementEditingSupport
    extends EditingSupport {
        private final String property;
        private final CellEditor cellEditor;

        public DataElementEditingSupport(ColumnViewer viewer, String property, CellEditor cellEditor) {
            super(viewer);
            this.property = property;
            this.cellEditor = cellEditor;
        }

        protected boolean canEdit(Object element) {
            ProcessConstants.DataElementProperty deProperty;
            if (!(DataElementView.this.currentProcVis.getTemplate() instanceof ChangeableTemplate) && !(DataElementView.this.currentProcVis.getInstance() instanceof ChangeableInstance)) {
                return false;
            }
            if (DataElementView.ID_PROPERTY.equals(this.property)) {
                return false;
            }
            if (DataElementView.NAME_PROPERTY.equals(this.property)) {
                deProperty = ProcessConstants.DataElementProperty.NAME;
            } else if (DataElementView.TYPE_PROPERTY.equals(this.property)) {
                deProperty = ProcessConstants.DataElementProperty.TYPE;
            } else if (DataElementView.PUBLIC_PROPERTY.equals(this.property)) {
                deProperty = ProcessConstants.DataElementProperty.PUBLIC;
            } else if (DataElementView.UDT_PROPERTY.equals(this.property)) {
                deProperty = ProcessConstants.DataElementProperty.USER_DEFINED_TYPE;
            } else {
                throw new RuntimeException();
            }
            if (DataElementView.this.currentProcVis.getInstance() instanceof ChangeableInstance) {
                return UpdateDataElement.isPossible((ChangeableInstance)((ChangeableInstance)DataElementView.this.currentProcVis.getInstance()), (DataElement)((DataElement)element), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{deProperty});
            }
            if (DataElementView.this.currentProcVis.getTemplate() instanceof ChangeableTemplate) {
                CheckReport checkReport = null;
                boolean pos = UpdateDataElement.isPossible((Template)DataElementView.this.currentProcVis.getTemplate(), (DataElement)((DataElement)element), checkReport, (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{deProperty});
                return pos;
            }
            return false;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            Object value;
            if (DataElementView.NAME_PROPERTY.equals(this.property)) {
                value = ((DataElement)element).getName();
            } else if (DataElementView.TYPE_PROPERTY.equals(this.property)) {
                value = ((DataElement)element).getDataType().name();
            } else if (DataElementView.PUBLIC_PROPERTY.equals(this.property)) {
                value = ((DataElement)element).isPublic();
            } else if (DataElementView.UDT_PROPERTY.equals(this.property)) {
                value = ((DataElement)element).getUDTName();
                if (value == null) {
                    value = "";
                }
            } else {
                value = null;
            }
            return value;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void setValue(Object element, Object value) {
            ProcessConstants.DataElementProperty deProperty;
            DataElement oldDE = (DataElement)element;
            SessionToken session = Activator.getService().getSessionToken();
            String name = DataElementView.NAME_PROPERTY.equals(this.property) ? (String)value : oldDE.getName();
            ProcessConstants.AdeptDataType type = DataElementView.TYPE_PROPERTY.equals(this.property) ? ProcessConstants.AdeptDataType.valueOf((String)((String)value)) : oldDE.getDataType();
            String userDefinedType = DataElementView.UDT_PROPERTY.equals(this.property) ? (String)value : null;
            boolean isPublic = DataElementView.PUBLIC_PROPERTY.equals(this.property) ? (Boolean)value : false;
            DataElement newDE = Activator.getService().getProcessModelFactory().createDataElement(oldDE.getID(), name, type, null, userDefinedType, null, null, isPublic, false, new HashMap(), new HashMap(), new HashMap());
            if (DataElementView.NAME_PROPERTY.equals(this.property)) {
                if (value.equals(oldDE.getName())) {
                    return;
                }
                deProperty = ProcessConstants.DataElementProperty.NAME;
            } else if (DataElementView.TYPE_PROPERTY.equals(this.property)) {
                if (value.equals(oldDE.getDataType().name())) {
                    return;
                }
                deProperty = ProcessConstants.DataElementProperty.TYPE;
            } else if (DataElementView.PUBLIC_PROPERTY.equals(this.property)) {
                if (value.equals(oldDE.isPublic())) {
                    return;
                }
                deProperty = ProcessConstants.DataElementProperty.PUBLIC;
            } else {
                if (!DataElementView.UDT_PROPERTY.equals(this.property)) throw new RuntimeException();
                if (value.equals(oldDE.getUDTName())) {
                    return;
                }
                deProperty = ProcessConstants.DataElementProperty.USER_DEFINED_TYPE;
            }
            String transactionLabel = String.format("Data element %s changed", newDE.getName());
            if (DataElementView.this.currentProcVis.getInstance() != null) {
                CheckReport checkReport;
                ChangeableInstance instance = (ChangeableInstance)DataElementView.this.currentProcVis.getInstance();
                if (!UpdateDataElement.isPossible((ChangeableInstance)instance, (DataElement)newDE, (CheckReport)(checkReport = new CheckReport(ProcessElementIdentifierTools.getInstanceIdentifier((String)"localhost", (Instance)instance))), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{deProperty})) throw new RuntimeException("Modification not possible, but cell was set to modifiable!\n" + checkReport.getReportSummary());
                StartTransaction.performOperation((ChangeableInstance)instance, (UpdateManager)DataElementView.this.updateManager);
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableInstance)instance, (DataElement)newDE, (UpdateManager)DataElementView.this.updateManager, (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{deProperty});
                EndTransaction.performOperation((ChangeableInstance)instance, (UpdateManager)DataElementView.this.updateManager, (String)transactionLabel);
                return;
            } else {
                CheckReport checkReport;
                ChangeableTemplate template = (ChangeableTemplate)DataElementView.this.currentProcVis.getTemplate();
                if (!UpdateDataElement.isPossible((Template)template, (DataElement)newDE, (CheckReport)(checkReport = new CheckReport(ProcessElementIdentifierTools.getTemplateIdentifier((Template)template, (String)"localhost"))), (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{deProperty})) throw new RuntimeException("Modification not possible, but cell was set to modifiable!\n" + checkReport.getReportSummary());
                StartTransaction.performOperation((ChangeableTemplate)template, (UpdateManager)DataElementView.this.updateManager);
                UpdateDataElement.performOperation((SessionToken)session, (ChangeableTemplate)template, (DataElement)newDE, (UpdateManager)DataElementView.this.updateManager, (ProcessConstants.DataElementProperty[])new ProcessConstants.DataElementProperty[]{deProperty});
                EndTransaction.performOperation((ChangeableTemplate)template, (UpdateManager)DataElementView.this.updateManager, (String)transactionLabel);
            }
        }
    }

    public class DataElementListUIComponent
    extends FilteredListUIComponent
    implements ChangeListener {
        protected final Set<DataElement> dataElements;
        private Template currentTemplate;
        private Instance currentInstance;

        public DataElementListUIComponent(Composite parent) {
            super(Table.class, parent, 65538, (QuickSearchFilterProvider)new DataElementQuickSearchProvider());
            this.dataElements = new HashSet<DataElement>();
            this.currentInstance = null;
            this.initColumns(new String[0], new String[]{DataElementView.ID_PROPERTY}, DataElementView.NAME_PROPERTY, true);
        }

        protected void registerColumns() {
            super.registerColumns();
            Image image = MiscImages.getImage((String)"dataelement.gif");
            ProcessConstants.AdeptDataType[] types = ProcessConstants.AdeptDataType.values();
            String[] typeNames = new String[types.length];
            int i = 0;
            while (i < types.length) {
                typeNames[i] = types[i].name();
                ++i;
            }
            StringBasedComboBoxCellEditor typeEditor = new StringBasedComboBoxCellEditor(this.getColumnControl(), typeNames);
            TextCellEditor nameEditor = new TextCellEditor(this.getColumnControl());
            TextCellEditor udtNameEditor = new TextCellEditor(this.getColumnControl());
            CheckboxCellEditor publicEditor = new CheckboxCellEditor(this.getColumnControl());
            this.registerColumn(DataElementView.ID_PROPERTY, "ID", 16384, new ColumnData(1.0f), (CellLabelProvider)new ImageColumnLabelProvider(image, (Table)this.getColumnControl()){

                public String getText(Object element) {
                    DataElement de = (DataElement)element;
                    return "" + de.getID();
                }
            }, null);
            this.registerColumn(DataElementView.NAME_PROPERTY, "Name", 16384, new ColumnData(2.0f), (CellLabelProvider)new ImageColumnLabelProvider(image, (Table)this.getColumnControl()){

                public String getText(Object element) {
                    DataElement de = (DataElement)element;
                    return de.getName();
                }
            }, null, new DataElementEditingSupport(this.getColumnViewer(), DataElementView.NAME_PROPERTY, (CellEditor)nameEditor));
            this.registerColumn(DataElementView.TYPE_PROPERTY, "Type", 16384, new ColumnData(2.0f), (CellLabelProvider)new ImageColumnLabelProvider(image, (Table)this.getColumnControl()){

                public String getText(Object element) {
                    DataElement de = (DataElement)element;
                    return de.getDataType().name();
                }
            }, null, new DataElementEditingSupport(this.getColumnViewer(), DataElementView.TYPE_PROPERTY, (CellEditor)typeEditor));
            this.registerColumn(DataElementView.PUBLIC_PROPERTY, "Public", 16384, new ColumnData(2.0f), (CellLabelProvider)new ImageColumnLabelProvider(image, (Table)this.getColumnControl()){

                public String getText(Object element) {
                    DataElement de = (DataElement)element;
                    return de.isPublic() ? "Y" : "N";
                }
            }, null, new DataElementEditingSupport(this.getColumnViewer(), DataElementView.PUBLIC_PROPERTY, (CellEditor)publicEditor));
            this.registerColumn(DataElementView.UDT_PROPERTY, "UDT Name", 16384, new ColumnData(2.0f), (CellLabelProvider)new ImageColumnLabelProvider(image, (Table)this.getColumnControl()){

                public String getText(Object element) {
                    DataElement de = (DataElement)element;
                    return de.getUDTName();
                }
            }, null, new DataElementEditingSupport(this.getColumnViewer(), DataElementView.UDT_PROPERTY, (CellEditor)udtNameEditor));
            String sortColumn = DataElementView.NAME_PROPERTY;
            boolean sortAscending = true;
            if (this.isColumnShown(sortColumn)) {
                this.setSortColumn(sortColumn, sortAscending);
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            Instance instance;
            if (event.getSource() instanceof DataElement) {
                if (event.getProperty().equals(UpdateManager.DataElementProperties.DE_NAME)) {
                    DataElement dataElement = (DataElement)event.getSource();
                    this.getColumnViewer().update((Object)dataElement, new String[]{DataElementView.NAME_PROPERTY});
                } else if (event.getProperty().equals(UpdateManager.DataElementProperties.DE_TYPE)) {
                    DataElement dataElement = (DataElement)event.getSource();
                    this.getColumnViewer().update((Object)dataElement, new String[]{DataElementView.TYPE_PROPERTY});
                } else if (event.getProperty().equals(UpdateManager.DataElementProperties.DE_PUBLIC)) {
                    DataElement dataElement = (DataElement)event.getSource();
                    this.getColumnViewer().update((Object)dataElement, new String[]{DataElementView.PUBLIC_PROPERTY});
                } else if (event.getProperty().equals(UpdateManager.DataElementProperties.DE_USER_TYPE)) {
                    DataElement dataElement = (DataElement)event.getSource();
                    this.getColumnViewer().update((Object)dataElement, new String[]{DataElementView.UDT_PROPERTY});
                }
            } else if (event.getSource() instanceof Template) {
                if (event.getProperty().equals(UpdateManager.ProcessProperties.OBJECT_REPLACED)) {
                    if ((Template)event.getSource() == this.currentTemplate) {
                        this.unregisterListeners(this.currentTemplate, this.currentInstance);
                    }
                    this.setInput(DataElementView.this.currentProcVis.getTemplate(), DataElementView.this.currentProcVis.getInstance());
                }
                if (event.getProperty().equals(UpdateManager.ProcessProperties.PROCESS_DATA_ELEMENT)) {
                    this.setInput(null, DataElementView.this.currentProcVis.getInstance());
                    this.setInput(DataElementView.this.currentProcVis.getTemplate(), DataElementView.this.currentProcVis.getInstance());
                }
            } else if (event.getSource() instanceof Instance && (instance = (Instance)event.getSource()).getTemplate() != this.currentTemplate) {
                this.setInput(instance.getTemplate(), instance);
            }
        }

        public void setInput(Template template, Instance instance) {
            DataElement dataElement;
            Iterator listIterator;
            if (template == null) {
                this.unregisterListeners(this.currentTemplate, this.currentInstance);
                this.currentTemplate = null;
                this.currentInstance = null;
                super.setInput(new HashSet());
                return;
            }
            if (template != this.currentTemplate || instance != this.currentInstance) {
                this.unregisterListeners(this.currentTemplate, this.currentInstance);
            }
            this.currentTemplate = template;
            this.currentInstance = instance;
            DataElementView.this.updateManager.addListener((Object)template, (ChangeListener)this);
            if (instance != null) {
                DataElementView.this.updateManager.addListener((Object)instance, (ChangeListener)this);
            }
            for (DataElement dataElement2 : template.getDataElements()) {
                DataElementView.this.updateManager.addListener((Object)dataElement2, (ChangeListener)this);
                this.dataElements.add(dataElement2);
            }
            UISettings settings = DataElementView.this.currentProcVis.getUISettings();
            LinkedList dataElementList = new LinkedList(template.getDataElements());
            if (!settings.isSystemDataElementVisible()) {
                listIterator = dataElementList.iterator();
                while (listIterator.hasNext()) {
                    dataElement = (DataElement)listIterator.next();
                    if (!ProcessModelTools.isSystemDataElement((Template)template, (int)dataElement.getID())) continue;
                    listIterator.remove();
                }
            }
            if (!settings.isDecisionDataElementVisible()) {
                listIterator = dataElementList.iterator();
                while (listIterator.hasNext()) {
                    dataElement = (DataElement)listIterator.next();
                    if (!ProcessModelTools.isDecisionDataElement((Template)template, (int)dataElement.getID())) continue;
                    listIterator.remove();
                }
            }
            super.setInput(dataElementList);
        }

        private void unregisterListeners(Template oldTemplate, Instance oldInstance) {
            if (oldTemplate != null) {
                DataElementView.this.updateManager.removeListener((Object)oldTemplate, (ChangeListener)this);
            }
            if (oldInstance != null) {
                DataElementView.this.updateManager.removeListener((Object)oldInstance, (ChangeListener)this);
            }
            for (DataElement dataElement : this.dataElements) {
                DataElementView.this.updateManager.removeListener((Object)dataElement, (ChangeListener)this);
            }
            this.dataElements.clear();
        }
    }

    protected static class DataElementQuickSearchProvider
    implements QuickSearchFilterProvider {
        private final FilterFactory filterFac = Activator.getService().getFilterFactory();
        private final Attribute nameAttribute;
        private final Attribute udtNameAttribute;

        public DataElementQuickSearchProvider() {
            AttributeFactory afTempl = this.filterFac.createAttributeFactory(DataElement.class);
            this.nameAttribute = afTempl.selectAttribute("getName");
            this.udtNameAttribute = afTempl.selectAttribute("getUDTName");
        }

        public ViewerFilter getQuickSearchFilter(String filterString) {
            StringBuilder filter = new StringBuilder("*");
            filter.append(filterString);
            filter.append("*");
            ComparisonFilter nameFilter = this.filterFac.createComparisonFilter(this.nameAttribute, ComparisonOperator.LIKE, (Comparable)((Object)filter.toString()));
            ComparisonFilter descriptionFilter = this.filterFac.createComparisonFilter(this.udtNameAttribute, ComparisonOperator.LIKE, (Comparable)((Object)filter.toString()));
            MultipleFilterFilter searchFilter = this.filterFac.createOrFilter(new Filter[]{nameFilter, descriptionFilter});
            return new AdeptFilterWrapper((Filter)searchFilter);
        }
    }
}

