/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.dataelementview.actions;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.changeoperations.EndTransaction;
import de.aristaflow.adept2.core.changeoperations.InsertDataElement;
import de.aristaflow.adept2.core.changeoperations.StartTransaction;
import de.aristaflow.adept2.core.updatemanager.UpdateManager;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.ui.dataelementview.DataElementView;
import de.aristaflow.adept2.ui.processediting.wizards.DataElementWizard;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class CreateDataElementAction
implements IViewActionDelegate {
    private DataElementView view;

    public void init(IViewPart view) {
        this.view = (DataElementView)view;
    }

    public void run(IAction action) {
        DataElementWizard wizard = new DataElementWizard();
        WizardDialog wizardDialog = new WizardDialog(this.view.getSite().getShell(), (IWizard)wizard);
        if (wizardDialog.open() == 0) {
            DataElement dataElement = wizard.getDataElement();
            Instance instance = this.view.getCurrentProcessVisualiser().getInstance();
            String label = String.format("Insert Data Element '%s'", dataElement.getName());
            UpdateManager updateManager = Activator.getService().getUpdateManager();
            if (instance == null) {
                ChangeableTemplate template = (ChangeableTemplate)this.view.getCurrentProcessVisualiser().getTemplate();
                StartTransaction.performOperation((ChangeableTemplate)template, (UpdateManager)updateManager);
                if (InsertDataElement.isPossible((Template)template, (DataElement)dataElement)) {
                    InsertDataElement.performOperation((SessionToken)Activator.getService().getSessionToken(), (ChangeableTemplate)template, (DataElement)dataElement, (UpdateManager)updateManager);
                }
                EndTransaction.performOperation((ChangeableTemplate)template, (UpdateManager)updateManager, (String)label);
            } else {
                ChangeableInstance cInstance = (ChangeableInstance)instance;
                StartTransaction.performOperation((ChangeableInstance)cInstance, (UpdateManager)updateManager);
                if (InsertDataElement.isPossible((ChangeableInstance)cInstance, (DataElement)dataElement)) {
                    InsertDataElement.performOperation((SessionToken)Activator.getService().getSessionToken(), (ChangeableInstance)cInstance, (DataElement)dataElement, (UpdateManager)updateManager);
                }
                EndTransaction.performOperation((ChangeableInstance)cInstance, (UpdateManager)updateManager, (String)label);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(false);
        ProcessVisualiser pv = this.view.getCurrentProcessVisualiser();
        if (pv != null) {
            Instance instance = pv.getInstance();
            Template template = pv.getTemplate();
            if (instance instanceof ChangeableInstance) {
                action.setEnabled(InsertDataElement.isPossible((ChangeableInstance)((ChangeableInstance)instance)));
            } else if (template instanceof ChangeableTemplate) {
                action.setEnabled(InsertDataElement.isPossible((Template)template));
            }
        }
    }
}

