/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processlistview;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.i18n.LocalisationResolver;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.ui.util.execution.ProducingRunnable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;

public class InstantiableTemplatesReader
implements ProducingRunnable<List<TemplateReference>, Exception> {
    protected final SessionToken session;
    protected final InstanceControl instCtrl;
    private final Logger logger;
    private final Locale locale;

    public InstantiableTemplatesReader(SessionToken session, InstanceControl instCtrl, Logger logger, Locale locale) {
        this.session = session;
        this.instCtrl = instCtrl;
        this.logger = logger;
        this.locale = locale;
    }

    public List<TemplateReference> call() {
        LinkedList<TemplateReference> ret = new LinkedList<TemplateReference>();
        for (TemplateReference templateRef : this.instCtrl.getInstantiableTemplateReferences(this.session)) {
            if (templateRef.getInputParameters().size() > 0) {
                boolean optional = true;
                for (ProcessModelParameter param : templateRef.getInputParameters()) {
                    boolean bl = optional = optional && param.isOptional();
                }
                if (!optional) {
                    this.logger.info(String.format("Skipping template '%s' with ID '%s' - mandatory input parameters are not yet supported.", templateRef.getName(), templateRef.getID()));
                    continue;
                }
            }
            ret.add((TemplateReference)LocalisationResolver.createLocalisedView(TemplateReference.class, (PluginDataContainer)templateRef, (Locale)this.locale));
        }
        return ret;
    }
}

