/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processlistview;

import de.aristaflow.adept2.base.sessionmanagement.RichAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.client.ClientService;
import de.aristaflow.adept2.core.executionmanager.InstanceControl;
import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.ui.extraview.AristaFlowViewPart;
import de.aristaflow.adept2.ui.extraview.ExtraView;
import de.aristaflow.adept2.ui.processlistview.Activator;
import de.aristaflow.adept2.ui.processlistview.InstantiableTemplatesReader;
import de.aristaflow.adept2.ui.processlistview.TemplateListView;
import de.aristaflow.adept2.ui.util.UIConstants;
import de.aristaflow.adept2.ui.util.execution.ConsumingRunnable;
import de.aristaflow.adept2.ui.util.execution.DisplayExecutor;
import de.aristaflow.adept2.ui.util.execution.ProducingRunnable;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class InstantiableTemplatesView
extends TemplateListView
implements ClientService.ActiveAgentListener,
ExtraView {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".instantiabletemplatesview";
    private final InstanceControl instanceControl = Activator.getService().getInstanceControl();
    private Form form;
    DisplayExecutor templateUpdater;
    final ResourceBundle messages;

    public InstantiableTemplatesView() {
        Activator.getService().addActiveAgentListener((ClientService.ActiveAgentListener)this);
        this.messages = ResourceBundle.getBundle("de.aristaflow.adept2.ui.processlistview.PLVBundle", Activator.getService().getActiveAgent().getLocale());
    }

    public void dispose() {
        this.templateUpdater.shutdown();
        Activator.getService().removeActiveAgentListener((ClientService.ActiveAgentListener)this);
        super.dispose();
        this.templateUpdater.awaitTermination();
    }

    public void activeAgentChanged(RichAgent newAgent, SessionToken session) {
        if (newAgent != null) {
            this.updateInput();
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        long start = System.nanoTime();
        this.templateUpdater = new DisplayExecutor("Instantiable templates view updater", parent.getDisplay(), this.logger);
        super.createPartControl(parent);
        this.setPartName(this.messages.getString("ITVTitle"));
        String msg = String.format("PERFLOG: Method needed %,d milli seconds.", (System.nanoTime() - start) / 1000000L);
        this.logger.info(msg);
    }

    @Override
    protected void initColumns() {
        this.viewer.initColumns(null, new String[]{"id", "outdated", "instantiable"}, "name", true);
    }

    @Override
    public void setMessage(String message) {
        if (this.form != null) {
            this.form.setMessage(message);
        }
    }

    @Override
    public void updateInput() {
        if (Display.getCurrent() != null) {
            this._updateInput();
        } else if (this.getSite() != null) {
            this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    InstantiableTemplatesView.this._updateInput();
                }
            });
        }
    }

    public void _updateInput() {
        long start = System.nanoTime();
        String msg = String.format("PERFLOG: Start _updateInput at %,d.", start);
        this.logger.fine(msg);
        SessionToken session = Activator.getService().getSessionToken();
        final Locale locale = Activator.getService().getActiveAgent().getLocale();
        InstantiableTemplatesReader producer = new InstantiableTemplatesReader(session, this.instanceControl, this.logger, locale);
        ConsumingRunnable<List<TemplateReference>, Exception> consumer = new ConsumingRunnable<List<TemplateReference>, Exception>(){

            public void consumeResult(List<TemplateReference> result) {
                if (!InstantiableTemplatesView.this.isDisposed()) {
                    InstantiableTemplatesView.this.templates.clear();
                    InstantiableTemplatesView.this.templates.addAll(result);
                    InstantiableTemplatesView.this.viewer.setInput((Object)InstantiableTemplatesView.this.templates);
                    String currentTime = DateFormat.getDateTimeInstance(3, 3, locale).format(new Date());
                    InstantiableTemplatesView.this.setMessage(String.format(InstantiableTemplatesView.this.messages.getString("ITVLastRefreshTime"), currentTime));
                }
            }

            public void consumeException(Exception e) {
                InstantiableTemplatesView.this.logger.log(Level.WARNING, "consumeException was called unexpectedly!", e);
            }
        };
        this.templateUpdater.runSynchronously((ProducingRunnable)producer, (ConsumingRunnable)consumer);
        msg = String.format("PERFLOG: Finish _updateInput at %,d (in %,d milli seconds).", System.nanoTime(), (System.nanoTime() - start) / 1000000L);
        this.logger.fine(msg);
    }

    @Override
    protected Composite createBody(Composite parent) {
        FormToolkit toolkit = this.initToolkit(parent);
        this.form = toolkit.createForm(parent);
        toolkit.decorateFormHeading(this.form);
        this.form.getBody().setLayout((Layout)new FillLayout());
        return this.form.getBody();
    }

    @Override
    protected IMenuManager getMenuManager() {
        return this.form.getMenuManager();
    }

    @Override
    protected IToolBarManager getToolBarManager() {
        return this.form.getToolBarManager();
    }

    @Override
    protected void installToolbarActions() {
        super.installToolbarActions();
        this.form.updateToolBar();
    }

    protected void setPartName(String partName) {
        super.setPartName(partName);
        if (this.form != null) {
            this.form.setText(partName);
        }
    }

    @Override
    public <E> List<E> getExtensions(Class<E> c, String extensionPoint) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        LinkedList<Object> actionList = new LinkedList<Object>();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(extensionPoint);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            if (!extension.getContributor().getName().equals("de.aristaflow.adept2.app.processtemplateeditor")) {
                Object action = null;
                try {
                    action = extension.createExecutableExtension("class");
                    actionList.add(action);
                    this.logger.log(Level.INFO, "Registered action: " + action.getClass().getCanonicalName());
                }
                catch (CoreException e) {
                    this.logger.log(Level.SEVERE, "The specified extension could not be instantiated", e);
                }
                catch (ClassCastException e) {
                    this.logger.log(Level.SEVERE, "The class does not match the expected type", e);
                }
            }
            ++n2;
        }
        return actionList;
    }

    @Override
    protected FormToolkit initToolkit(Composite parent) {
        return new FormToolkit(UIConstants.getFormColors((Display)parent.getDisplay()));
    }

    public String getID() {
        return ID;
    }

    public String getLinkText(Locale locale) {
        String ret = UIConstants.FMC_LABELS ? this.messages.getString("ITVFMCLinkLabel") : this.messages.getString("ITVLinkLabel");
        return ret;
    }

    public AristaFlowViewPart getViewPart() {
        return this;
    }

    public void linkActivated(TypedEvent event) {
        this.getSite().getShell().getDisplay().timerExec(500, new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public boolean isVisible() {
        return true;
    }
}

