/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processlistview;

import de.aristaflow.adept2.model.processmodel.TemplateReference;
import de.aristaflow.adept2.ui.components.TemplateReferenceListUIComponent;
import de.aristaflow.adept2.ui.extraview.AristaFlowViewPart;
import de.aristaflow.adept2.ui.processlistview.Activator;
import de.aristaflow.adept2.ui.processlistview.extensions.TemplateManagerAction;
import de.aristaflow.adept2.ui.processlistview.extensions.TemplateManagerDoubleClickAction;
import de.aristaflow.adept2.ui.util.list.ListStatePersistenceTools;
import de.aristaflow.adept2.ui.util.list.ListUIComponent;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class TemplateListView
extends AristaFlowViewPart
implements ITabbedPropertySheetPageContributor {
    protected static final String CONTEXT_ACTIONS_ID = String.valueOf(Activator.getPluginID()) + ".contextMenuActions";
    protected static final String MENU_ACTIONS_ID = String.valueOf(Activator.getPluginID()) + ".menuActions";
    protected static final String DOUBLECLICK_ACTIONS_ID = String.valueOf(Activator.getPluginID()) + ".doubleClickAction";
    protected TemplateReferenceListUIComponent viewer;
    protected final List<TemplateReference> templates = new LinkedList<TemplateReference>();
    protected List<TemplateManagerAction> menuActions;
    protected IDoubleClickListener doubleclickAction;
    protected final Logger logger = LoggerTools.getLogger((Object)((Object)this));
    private IMemento initMemento;
    protected Composite body;
    protected Label lblStatus;

    public TemplateListView() {
        this.loadExtensions();
    }

    private void loadExtensions() {
        this.menuActions = this.getExtensions(TemplateManagerAction.class, MENU_ACTIONS_ID);
        List<TemplateManagerDoubleClickAction> actions = this.getExtensions(TemplateManagerDoubleClickAction.class, DOUBLECLICK_ACTIONS_ID);
        if (actions.size() > 0) {
            this.doubleclickAction = actions.get(0);
        }
        if (actions.size() > 1) {
            this.logger.severe("More than one double click handler has been defined!");
        }
    }

    public <E> List<E> getExtensions(Class<E> c, String extensionPoint) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        LinkedList<Object> actionList = new LinkedList<Object>();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(extensionPoint);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            Object action = null;
            try {
                action = extension.createExecutableExtension("class");
                actionList.add(action);
                this.logger.log(Level.INFO, "Registered action: " + action.getClass().getCanonicalName());
            }
            catch (CoreException e) {
                this.logger.log(Level.SEVERE, "The specified extension could not be instantiated", e);
            }
            catch (ClassCastException e) {
                this.logger.log(Level.SEVERE, "The class does not match the expected type", e);
            }
            ++n2;
        }
        return actionList;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(512));
        this.body = this.createBody(parent);
        this.body.setLayout((Layout)new FillLayout());
        this.viewer = new TemplateReferenceListUIComponent(this.body, 0);
        this.initColumns();
        if (this.initMemento != null) {
            ListStatePersistenceTools.loadState((ListUIComponent)this.viewer, (IMemento)this.initMemento);
            this.initMemento = null;
        }
        this.installToolbarActions();
        if (this.doubleclickAction != null) {
            this.viewer.getColumnViewer().addDoubleClickListener(this.doubleclickAction);
        }
        this.getSite().registerContextMenu(this.viewer.getContextMenu(), (ISelectionProvider)this.viewer.getColumnViewer());
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                TemplateListView.this.updateInput();
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer.getColumnViewer());
    }

    protected void initColumns() {
        this.viewer.initColumns(null, new String[]{"id"}, "name", true);
    }

    protected Composite createBody(Composite parent) {
        return parent;
    }

    protected FormToolkit initToolkit(Composite parent) {
        return new FormToolkit(parent.getDisplay());
    }

    protected IMenuManager getMenuManager() {
        return this.getViewSite().getActionBars().getMenuManager();
    }

    protected IToolBarManager getToolBarManager() {
        return this.getViewSite().getActionBars().getToolBarManager();
    }

    protected void installToolbarActions() {
        IToolBarManager toolBarManager = this.getToolBarManager();
        IMenuManager menuManager = this.getMenuManager();
        for (TemplateManagerAction action : this.menuActions) {
            action.setView(this);
            toolBarManager.add((IAction)action);
            menuManager.add((IAction)action);
        }
    }

    public void setFocus() {
        this.viewer.getColumnControl().setFocus();
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.viewer.getColumnViewer().getSelection();
    }

    public abstract void setMessage(String var1);

    public abstract void updateInput();

    public void saveState(IMemento memento) {
        super.saveState(memento);
        ListStatePersistenceTools.saveState((ListUIComponent)this.viewer, (IMemento)memento);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.initMemento = memento;
        super.init(site, memento);
    }

    public String getContributorId() {
        return "de.aristaflow.adept2.ui.processvisualisation.ProcessVisualiser";
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(type);
    }
}

