/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.ui;

import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizardPage;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.util.RadioGroupManager;
import java.io.File;
import java.util.UUID;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileIOComponentWizard
extends ExecutableComponentWizard {
    public FileIOComponentWizard() {
        this.addPage((IWizardPage)new FileIOWizardPage(this));
    }

    class FileIOWizardPage
    extends ExecutableComponentWizardPage {
        private static final String FILEDATA_OUTPUT_PARAM = "fileDataOutput";
        private static final String FILEDATA_INPUT_PARAM = "fileDataInput";
        private static final String FILENAME_PARAM = "fileUriInput";
        private RadioGroupManager dataTypeGroupManager;
        private Button dataTypeStringRadio;
        private Combo dataTypeStringEncoding;
        private Button dataTypeUserdefinedRadio;
        private Text dataTypeUserdefinedUdtName;
        private RadioGroupManager fileUriGroupManager;
        private Button fileUriRadio;
        Text fileUriText;
        private Button fileUriParamRadio;
        private Button fileWriteAppend;

        public FileIOWizardPage(FileIOComponentWizard pageSet) {
            super((ExecutableComponentWizard)pageSet, "de.aristaflow.tools.FileIO");
            this.setTitle("de.aristaflow.tools.FileIO");
        }

        public void createControl(Composite parent) {
            String opName = this.getData().getOperationName();
            this.setTitle("FileIO." + opName);
            String description = null;
            if (opName.equals("readFromFile")) {
                description = "Read from file into output parameter";
            } else if (opName.equals("writeToFile")) {
                description = "Write from input parameter to file";
            }
            this.setDescription(description);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new MigLayout("wrap", "[grow, fill]"));
            Group dataTypeGroup = new Group(composite, 0);
            dataTypeGroup.setLayout((Layout)new MigLayout("wrap", "[][grow, fill]"));
            if (opName.equals("readFromFile")) {
                dataTypeGroup.setText("Data type of the output parameter");
            } else if (opName.equals("writeToFile")) {
                dataTypeGroup.setText("Data type of the input parameter");
            }
            this.dataTypeStringRadio = new Button((Composite)dataTypeGroup, 16);
            this.dataTypeStringRadio.setLayoutData((Object)"spanx");
            this.dataTypeStringRadio.setText("STRING");
            this.dataTypeStringRadio.addSelectionListener(this.getAutoCommitSelectionListener());
            Label dataTypeStringEncodingLabel = new Label((Composite)dataTypeGroup, 0);
            dataTypeStringEncodingLabel.setLayoutData((Object)"gapx 20lp");
            dataTypeStringEncodingLabel.setText("Encoding:");
            this.dataTypeStringEncoding = new Combo((Composite)dataTypeGroup, 2048);
            this.dataTypeStringEncoding.add("ISO-8859-1");
            this.dataTypeStringEncoding.add("UTF-8");
            this.dataTypeStringEncoding.add("UTF-16");
            this.dataTypeStringEncoding.select(1);
            this.dataTypeStringEncoding.addModifyListener(this.getAutoCommitModifyListener());
            this.dataTypeUserdefinedRadio = new Button((Composite)dataTypeGroup, 16);
            this.dataTypeUserdefinedRadio.setLayoutData((Object)"spanx");
            this.dataTypeUserdefinedRadio.setText("USERDEFINED");
            this.dataTypeUserdefinedRadio.addSelectionListener(this.getAutoCommitSelectionListener());
            Label dataTypeUserdefinedUdtNameLabel = new Label((Composite)dataTypeGroup, 0);
            dataTypeUserdefinedUdtNameLabel.setLayoutData((Object)"gapx 20lp");
            dataTypeUserdefinedUdtNameLabel.setText("UDT name:");
            this.dataTypeUserdefinedUdtName = new Text((Composite)dataTypeGroup, 2048);
            this.dataTypeUserdefinedUdtName.addModifyListener(this.getAutoCommitModifyListener());
            this.dataTypeGroupManager = new RadioGroupManager((Composite)dataTypeGroup);
            this.dataTypeGroupManager.add(this.dataTypeStringRadio, new Control[]{this.dataTypeStringEncoding});
            this.dataTypeGroupManager.add(this.dataTypeUserdefinedRadio, new Control[]{this.dataTypeUserdefinedUdtName});
            Group fileGroup = new Group(composite, 0);
            fileGroup.setLayoutData((Object)"gapy 10lp");
            fileGroup.setLayout((Layout)new MigLayout("wrap", "[][grow][]"));
            if (opName.equals("readFromFile")) {
                fileGroup.setText("Input file");
            } else if (opName.equals("writeToFile")) {
                fileGroup.setText("Ouput file");
            }
            this.fileUriRadio = new Button((Composite)fileGroup, 16);
            this.fileUriRadio.setText("File URI:");
            this.fileUriRadio.addSelectionListener(this.getAutoCommitSelectionListener());
            this.fileUriText = new Text((Composite)fileGroup, 2048);
            this.fileUriText.setLayoutData((Object)"w 0:100, growx");
            this.fileUriText.addModifyListener(this.getAutoCommitModifyListener());
            Button fileUriSelect = new Button((Composite)fileGroup, 0);
            fileUriSelect.setText("Browse...");
            fileUriSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog fidi = new FileDialog(FileIOWizardPage.this.getShell(), 4096);
                    String filePath = fidi.open();
                    if (filePath != null) {
                        String fileUri = new File(filePath).toURI().toString();
                        FileIOWizardPage.this.fileUriText.setText(fileUri);
                    }
                }
            });
            this.fileUriParamRadio = new Button((Composite)fileGroup, 16);
            this.fileUriParamRadio.setText("File URI from Parameter");
            this.fileUriParamRadio.addSelectionListener(this.getAutoCommitSelectionListener());
            this.fileUriParamRadio.setLayoutData((Object)"wrap");
            this.fileUriGroupManager = new RadioGroupManager((Composite)fileGroup);
            this.fileUriGroupManager.add(this.fileUriRadio, new Control[]{this.fileUriText, fileUriSelect});
            this.fileUriGroupManager.add(this.fileUriParamRadio, new Control[0]);
            if (opName.equals("writeToFile")) {
                Label sep = new Label((Composite)fileGroup, 258);
                sep.setLayoutData((Object)"spanx, growx");
                this.fileWriteAppend = new Button((Composite)fileGroup, 32);
                this.fileWriteAppend.setLayoutData((Object)"spanx");
                this.fileWriteAppend.setText("Append to file");
                this.fileWriteAppend.addSelectionListener(this.getAutoCommitSelectionListener());
            }
            this.setControl((Control)composite);
            this.refresh();
        }

        protected void updatePageComplete() {
            String fileUriString;
            boolean complete = true;
            this.removeMessage("fileURIEmpty");
            if (this.fileUriRadio.getSelection() && (fileUriString = this.fileUriText.getText()).length() == 0) {
                complete = false;
                this.addMessage("fileURIEmpty", 3, "The file URI must not be empty.");
            }
            this.setPageComplete(complete);
        }

        protected void loadData() {
            String opName = this.getData().getOperationName();
            ProcessModelParameter dataParam = null;
            if (opName.equals("readFromFile")) {
                dataParam = this.getData().getParameter(FILEDATA_OUTPUT_PARAM, ActivityConstants.AccessType.WRITE);
            } else if (opName.equals("writeToFile")) {
                dataParam = this.getData().getParameter(FILEDATA_INPUT_PARAM, ActivityConstants.AccessType.READ);
            }
            if (dataParam != null) {
                ActivityConfiguration paramConf = dataParam.getConfiguration();
                if (dataParam.getDataType() == ProcessConstants.AdeptDataType.USERDEFINED) {
                    this.dataTypeGroupManager.select(this.dataTypeUserdefinedRadio);
                    this.dataTypeUserdefinedUdtName.setText(dataParam.getUDTName());
                } else {
                    this.dataTypeGroupManager.select(this.dataTypeStringRadio);
                    String encoding = paramConf.getString("Encoding");
                    if (encoding != null) {
                        this.dataTypeStringEncoding.setText(encoding);
                    }
                }
                String fileUri = paramConf.getString("FileURI");
                String fileUriParam = paramConf.getString("FileURIParameter");
                if (fileUri != null) {
                    this.fileUriText.setText(fileUri);
                    this.fileUriGroupManager.select(this.fileUriRadio);
                } else if (fileUriParam != null) {
                    this.fileUriGroupManager.select(this.fileUriParamRadio);
                }
                Boolean append = paramConf.getBoolean("Append");
                if (append == null) {
                    append = Boolean.FALSE;
                }
                if (opName.equals("writeToFile")) {
                    this.fileWriteAppend.setSelection(append.booleanValue());
                }
            } else {
                this.dataTypeGroupManager.select(this.dataTypeStringRadio);
                this.fileUriGroupManager.select(this.fileUriRadio);
            }
            this.saveData();
        }

        protected void saveData() {
            String opName = this.getData().getOperationName();
            ProcessModelParameter oldParam = null;
            if (opName.equals("readFromFile")) {
                oldParam = this.getData().getParameter(FILEDATA_OUTPUT_PARAM, ActivityConstants.AccessType.WRITE);
            } else if (opName.equals("writeToFile")) {
                oldParam = this.getData().getParameter(FILEDATA_INPUT_PARAM, ActivityConstants.AccessType.READ);
            }
            String newParamName = null;
            ActivityConstants.AccessType newParamAccessType = null;
            if (opName.equals("readFromFile")) {
                newParamName = FILEDATA_OUTPUT_PARAM;
                newParamAccessType = ActivityConstants.AccessType.WRITE;
            } else if (opName.equals("writeToFile")) {
                newParamName = FILEDATA_INPUT_PARAM;
                newParamAccessType = ActivityConstants.AccessType.READ;
            }
            ProcessConstants.AdeptDataType dataType = this.dataTypeStringRadio.getSelection() ? ProcessConstants.AdeptDataType.STRING : ProcessConstants.AdeptDataType.USERDEFINED;
            String udtName = null;
            if (dataType == ProcessConstants.AdeptDataType.USERDEFINED) {
                udtName = this.dataTypeUserdefinedUdtName.getText();
            }
            UUID identifierID = ProcessConstants.UNIVERSAL_IDENTIFIER_ID;
            String description = "parameter to which the file contents will be written";
            ChangeableActivityConfiguration paramConf = Activator.getService().getProcessModelFactory().createConfiguration(null);
            String encoding = this.dataTypeStringEncoding.getText();
            if (encoding.length() > 0) {
                paramConf.setString("Encoding", encoding);
            }
            if (this.fileUriRadio.getSelection()) {
                paramConf.setString("FileURI", this.fileUriText.getText());
            } else {
                paramConf.setString("FileURIParameter", FILENAME_PARAM);
            }
            if (opName.equals("writeToFile")) {
                paramConf.setBoolean("Append", this.fileWriteAppend.getSelection());
            }
            ProcessModelParameter newParam = Activator.getService().getProcessModelFactory().createProcessModelParameter(newParamName, description, dataType, udtName, identifierID, false, false, false, null, (ActivityConfiguration)paramConf, null, null);
            if (oldParam == null) {
                this.getData().addParameter(newParam, newParamAccessType);
            } else {
                this.getData().changeParameter(oldParam, newParam, newParamAccessType);
            }
            ProcessModelParameter oldFileUriParam = this.getData().getParameter(FILENAME_PARAM, ActivityConstants.AccessType.READ);
            if (this.fileUriParamRadio.getSelection()) {
                String description2 = "parameter from which the file URI will be read";
                identifierID = ProcessConstants.UNIVERSAL_IDENTIFIER_ID;
                ProcessModelParameter fileUriParam = Activator.getService().getProcessModelFactory().createProcessModelParameter(FILENAME_PARAM, description2, ProcessConstants.AdeptDataType.URI, null, identifierID, false, false, false, null, null, null, null);
                if (oldFileUriParam == null) {
                    this.getData().addParameter(fileUriParam, ActivityConstants.AccessType.READ);
                } else {
                    this.getData().changeParameter(oldFileUriParam, fileUriParam, ActivityConstants.AccessType.READ);
                }
            } else if (oldFileUriParam != null) {
                this.getData().removeParameter(FILENAME_PARAM, ActivityConstants.AccessType.READ);
            }
        }
    }
}

