/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.ui;

import de.aristaflow.adept2.extensions.tools.environments.AbstractStringFormatComponent;
import de.aristaflow.adept2.extensions.tools.ui.Activator;
import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.ui.util.columnlayout.TableColumnLayout;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;

public class FormatArgumentUIComponent {
    private Control rootControl;
    CheckboxTableViewer viewer;
    private List<SelectionListener> listeners = new ArrayList<SelectionListener>();
    AbstractStringFormatComponent.FormatStyle formatStyle;
    private Set<Parameter> inParams = new HashSet<Parameter>();
    List<Parameter> formatArguments = new ArrayList<Parameter>();
    private Button upButton;
    private Button downButton;

    public FormatArgumentUIComponent(Composite parent) {
        Composite formatArgumentOrderGroup = new Composite(parent, 0);
        this.rootControl = formatArgumentOrderGroup;
        formatArgumentOrderGroup.setLayout((Layout)new MigLayout("wrap, insets 0", "[grow, fill] [fill]"));
        this.viewer = CheckboxTableViewer.newCheckList((Composite)formatArgumentOrderGroup, (int)67584);
        this.viewer.getTable().setLayoutData((Object)"spany, pushy, growy, w 0:n, h 0:n");
        this.upButton = new Button(formatArgumentOrderGroup, 0);
        this.upButton.setLayoutData((Object)"spany, split 2, flowy, aligny top");
        this.upButton.setText("Move Up");
        this.downButton = new Button(formatArgumentOrderGroup, 0);
        this.downButton.setText("Move Down");
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FormatArgumentUIComponent.this.updateButtonStates();
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                Parameter param = (Parameter)element;
                return param.getDataType() != ProcessConstants.AdeptDataType.USERDEFINED;
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (FormatArgumentUIComponent.this.formatArguments.contains(element)) {
                    return 0;
                }
                return 1;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                Parameter param1 = (Parameter)e1;
                Parameter param2 = (Parameter)e2;
                int param1Index = FormatArgumentUIComponent.this.formatArguments.indexOf(e1);
                int param2Index = FormatArgumentUIComponent.this.formatArguments.indexOf(e2);
                if (param1Index == -1 || param2Index == -1) {
                    return param1.getName().compareToIgnoreCase(param2.getName());
                }
                return param1Index - param2Index;
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Parameter param = (Parameter)event.getElement();
                if (event.getChecked()) {
                    FormatArgumentUIComponent.this.formatArguments.add(param);
                } else {
                    FormatArgumentUIComponent.this.formatArguments.remove(param);
                }
                FormatArgumentUIComponent.this.viewer.refresh();
                FormatArgumentUIComponent.this.updateButtonStates();
                FormatArgumentUIComponent.this.fireSelectionEvent();
            }
        });
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatArgumentUIComponent.this.moveUp();
            }
        });
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatArgumentUIComponent.this.moveDown();
            }
        });
        this.viewer.getTable().setLayout((Layout)new TableColumnLayout());
        TableColumn indexColumn = new TableColumn(this.viewer.getTable(), 0);
        indexColumn.setWidth(200);
        new TableColumn(this.viewer.getTable(), 0);
        new TableColumn(this.viewer.getTable(), 0);
    }

    public Control getControl() {
        return this.rootControl;
    }

    public void addSelectionListener(SelectionListener listener) {
        ArgChecks.checkForNull((Object)listener, (String)"listener");
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void setFormatStyle(AbstractStringFormatComponent.FormatStyle formatStyle) {
        ArgChecks.checkForNull((Object)formatStyle, (String)"formatStyle");
        this.formatStyle = formatStyle;
        this.viewer.refresh();
    }

    public void setInputParameters(Collection<? extends Parameter> inParams) {
        Parameter param;
        ArgChecks.checkForNull(inParams, (String)"inParams");
        this.inParams.clear();
        this.inParams.addAll(inParams);
        Parameter[] formatArgumentParameters = AbstractStringFormatComponent.getFormatArgumentParameters(inParams);
        this.formatArguments.clear();
        Parameter[] parameterArray = formatArgumentParameters;
        int n = formatArgumentParameters.length;
        int n2 = 0;
        while (n2 < n) {
            param = parameterArray[n2];
            this.formatArguments.add(param);
            ++n2;
        }
        this.viewer.setInput(this.inParams);
        parameterArray = this.viewer.getTable().getColumns();
        n = parameterArray.length;
        n2 = 0;
        while (n2 < n) {
            Parameter column = parameterArray[n2];
            column.pack();
            ++n2;
        }
        parameterArray = formatArgumentParameters;
        n = formatArgumentParameters.length;
        n2 = 0;
        while (n2 < n) {
            param = parameterArray[n2];
            this.viewer.setChecked((Object)param, true);
            ++n2;
        }
        this.updateButtonStates();
    }

    public List<Parameter> getFormatArgumentParameters() {
        return new ArrayList<Parameter>(this.formatArguments);
    }

    public ChangeableActivityConfiguration adaptParameterConfiguration(Parameter param) {
        ChangeableActivityConfiguration paramConf = Activator.getService().getProcessModelFactory().createConfiguration(param.getConfiguration());
        int formatParamIndex = -1;
        int i = 0;
        while (i < this.formatArguments.size()) {
            Parameter formatParam = this.formatArguments.get(i);
            if (formatParam.getName().equals(param.getName())) {
                formatParamIndex = i;
                break;
            }
            ++i;
        }
        if (formatParamIndex != -1) {
            paramConf.setInteger("ArgumentIndex", (long)formatParamIndex);
        } else {
            paramConf.remove("ArgumentIndex");
        }
        return paramConf;
    }

    protected void updateButtonStates() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        Parameter param = (Parameter)selection.getFirstElement();
        if (param == null || !this.formatArguments.contains(param)) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else {
            int index = this.formatArguments.indexOf(param);
            this.upButton.setEnabled(index > 0);
            this.downButton.setEnabled(index < this.formatArguments.size() - 1);
        }
    }

    protected void moveUp() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        Parameter param = (Parameter)selection.getFirstElement();
        int index = this.formatArguments.indexOf(param);
        if (index > 0) {
            this.formatArguments.remove(index);
            this.formatArguments.add(index - 1, param);
            this.viewer.refresh();
            this.updateButtonStates();
            this.fireSelectionEvent();
        }
    }

    protected void moveDown() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        Parameter param = (Parameter)selection.getFirstElement();
        int index = this.formatArguments.indexOf(param);
        if (index != -1 && index < this.formatArguments.size() - 1) {
            this.formatArguments.remove(index);
            this.formatArguments.add(index + 1, param);
            this.viewer.refresh();
            this.updateButtonStates();
            this.fireSelectionEvent();
        }
    }

    protected void fireSelectionEvent() {
        for (SelectionListener listener : this.listeners) {
            listener.widgetSelected(null);
        }
    }

    private class LabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private LabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            Parameter param = (Parameter)element;
            switch (columnIndex) {
                case 0: {
                    int index = FormatArgumentUIComponent.this.formatArguments.indexOf(param);
                    if (index == -1) {
                        return null;
                    }
                    return Integer.toString(index + FormatArgumentUIComponent.this.formatStyle.firstIndex());
                }
                case 1: {
                    return param.getName();
                }
                case 2: {
                    return param.getDataType().toString();
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            Parameter param = (Parameter)element;
            int index = FormatArgumentUIComponent.this.formatArguments.indexOf(param);
            if (index >= FormatArgumentUIComponent.this.formatStyle.maxArgumentCount()) {
                return FormatArgumentUIComponent.this.getControl().getDisplay().getSystemColor(3);
            }
            return null;
        }
    }
}

