/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.ui;

import de.aristaflow.adept2.extensions.tools.checks.AbstractStringFormatComponentCheck;
import de.aristaflow.adept2.extensions.tools.environments.AbstractStringFormatComponent;
import de.aristaflow.adept2.extensions.tools.ui.Activator;
import de.aristaflow.adept2.extensions.tools.ui.FormatArgumentUIComponent;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizardPage;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.PnPWizardChangeListener;
import de.aristaflow.adept2.ui.util.components.LocaleUIComponent;
import de.aristaflow.adept2.util.LocaleTools;
import java.util.Collection;
import java.util.Locale;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FormattingMailComponentWizard
extends ExecutableComponentWizard {
    public FormattingMailComponentWizard() {
        this.addPage((IWizardPage)new FormattingMailWizardPage(this));
    }

    public void changeNotify(PnPWizardChangeListener.PnPWizardChangeType type, Object affectedObject) {
        super.changeNotify(type, affectedObject);
        switch (type) {
            case READ_PARAMETER_ADDED: 
            case READ_PARAMETER_REMOVED: 
            case READ_PARAMETER_CHANGED: {
                this.refreshAllPages();
            }
        }
    }

    private static class FormattingMailWizardPage
    extends ExecutableComponentWizardPage {
        public static final String PAGE_NAME = "de.aristaflow.tools.mail.FormattingMailer";
        private Text smtpSettingsHostname;
        private Text smtpSettingsPort;
        private Combo smtpSettingsEncryption;
        private Text smtpSettingsUsername;
        private Text smtpSettingsPassword;
        private Text mailTo;
        private Text mailFrom;
        private Text mailSubject;
        private Text mailBody;
        private LocaleUIComponent formatLocale;
        private ComboViewer formatStyle;
        FormatArgumentUIComponent formatArguments;

        public FormattingMailWizardPage(ExecutableComponentWizard pageSet) {
            super(pageSet, PAGE_NAME);
            this.setTitle("Configuration");
            this.setDescription("Sends an email customised with process data using string formatting.");
        }

        public void createControl(Composite parent) {
            Composite page = new Composite(parent, 0);
            page.setLayout((Layout)new MigLayout("wrap, fill", "[grow, fill] []"));
            Group smtpSettingsGroup = new Group(page, 0);
            smtpSettingsGroup.setText("SMTP Server Settings");
            smtpSettingsGroup.setLayout((Layout)new MigLayout("wrap", "[][grow, fill] unrel [][grow, fill]"));
            new Label((Composite)smtpSettingsGroup, 0).setText("Hostname:");
            this.smtpSettingsHostname = new Text((Composite)smtpSettingsGroup, 2048);
            this.smtpSettingsHostname.setLayoutData((Object)"span 3, w 100lp:100lp");
            this.smtpSettingsHostname.addModifyListener(this.getAutoCommitModifyListener());
            new Label((Composite)smtpSettingsGroup, 0).setText("Port:");
            this.smtpSettingsPort = new Text((Composite)smtpSettingsGroup, 2048);
            this.smtpSettingsPort.setLayoutData((Object)"w 100lp:100lp");
            this.smtpSettingsPort.addModifyListener(this.getAutoCommitModifyListener());
            new Label((Composite)smtpSettingsGroup, 0).setText("Encryption:");
            this.smtpSettingsEncryption = new Combo((Composite)smtpSettingsGroup, 8);
            this.smtpSettingsEncryption.add("none");
            this.smtpSettingsEncryption.add("TLS");
            this.smtpSettingsEncryption.add("SSL");
            this.smtpSettingsEncryption.addSelectionListener(this.getAutoCommitSelectionListener());
            new Label((Composite)smtpSettingsGroup, 0).setText("Username:");
            this.smtpSettingsUsername = new Text((Composite)smtpSettingsGroup, 2048);
            this.smtpSettingsUsername.setLayoutData((Object)"w 100lp:100lp");
            this.smtpSettingsUsername.addModifyListener(this.getAutoCommitModifyListener());
            new Label((Composite)smtpSettingsGroup, 0).setText("Password:");
            this.smtpSettingsPassword = new Text((Composite)smtpSettingsGroup, 0x400800);
            this.smtpSettingsPassword.setLayoutData((Object)"w 100lp:100lp");
            this.smtpSettingsPassword.addModifyListener(this.getAutoCommitModifyListener());
            Group formatSettings = new Group(page, 0);
            formatSettings.setLayoutData((Object)"spany, grow");
            formatSettings.setText("Format Settings");
            formatSettings.setLayout((Layout)new MigLayout("wrap", "[][grow, fill]"));
            new Label((Composite)formatSettings, 0).setText("Locale:");
            this.formatLocale = new LocaleUIComponent((Composite)formatSettings);
            this.formatLocale.getCombo().addModifyListener(this.getAutoCommitModifyListener());
            new Label((Composite)formatSettings, 0).setText("Format Style:");
            this.formatStyle = new ComboViewer((Composite)formatSettings, 8);
            this.formatStyle.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.formatStyle.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    AbstractStringFormatComponent.FormatStyle formatStyle = (AbstractStringFormatComponent.FormatStyle)element;
                    int maxArgCount = formatStyle.maxArgumentCount();
                    String text = formatStyle.token();
                    if (maxArgCount != Integer.MAX_VALUE) {
                        text = String.valueOf(text) + " (" + maxArgCount + " args max)";
                    }
                    return text;
                }
            });
            this.formatStyle.setInput((Object)AbstractStringFormatComponent.FormatStyle.values());
            this.formatStyle.addSelectionChangedListener(this.getAutoCommitSelectionChangedListener());
            this.formatStyle.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    AbstractStringFormatComponent.FormatStyle formatStyle = (AbstractStringFormatComponent.FormatStyle)selection.getFirstElement();
                    if (formatStyle != null) {
                        FormattingMailWizardPage.this.formatArguments.setFormatStyle(formatStyle);
                    }
                }
            });
            Label formatSettingsArgumentOrderLabel = new Label((Composite)formatSettings, 0);
            formatSettingsArgumentOrderLabel.setLayoutData((Object)"spanx");
            formatSettingsArgumentOrderLabel.setText("Argument Order:");
            this.formatArguments = new FormatArgumentUIComponent((Composite)formatSettings);
            this.formatArguments.getControl().setLayoutData((Object)"span, push, grow, h 25:150");
            this.formatArguments.addSelectionListener(this.getAutoCommitSelectionListener());
            Text help1 = new Text((Composite)formatSettings, 72);
            help1.setText("Select the input parameters that should be used as format arguments and arrange them in the desired order.");
            help1.setLayoutData((Object)"spanx, growx, w 0:0");
            help1.setBackground(formatSettings.getBackground());
            Group mailGroup = new Group(page, 0);
            mailGroup.setText("Email Content");
            mailGroup.setLayoutData((Object)"pushy, growy");
            mailGroup.setLayout((Layout)new MigLayout("wrap, fill", "[][grow, fill] unrel [][grow, fill]"));
            new Label((Composite)mailGroup, 0).setText("To:");
            this.mailTo = new Text((Composite)mailGroup, 2048);
            this.mailTo.setLayoutData((Object)"w 100lp:100lp");
            this.mailTo.addModifyListener(this.getAutoCommitModifyListener());
            new Label((Composite)mailGroup, 0).setText("From:");
            this.mailFrom = new Text((Composite)mailGroup, 2048);
            this.mailFrom.setLayoutData((Object)"w 100lp:100lp");
            this.mailFrom.addModifyListener(this.getAutoCommitModifyListener());
            new Label((Composite)mailGroup, 0).setText("Subject:");
            this.mailSubject = new Text((Composite)mailGroup, 2048);
            this.mailSubject.setLayoutData((Object)"w 100lp:100lp, span 3");
            this.mailSubject.addModifyListener(this.getAutoCommitModifyListener());
            new Label((Composite)mailGroup, 0).setText("Body:");
            this.mailBody = new Text((Composite)mailGroup, 2818);
            this.mailBody.setLayoutData((Object)"w 100lp:100lp, span 3, pushy, growy");
            this.mailBody.addModifyListener(this.getAutoCommitModifyListener());
            this.setControl((Control)page);
            this.refresh();
        }

        public void commit() {
            super.commit();
            this.checkFormatString(this.mailTo.getText(), "mailTo", "email 'to'");
            this.checkFormatString(this.mailFrom.getText(), "mailFrom", "email 'from'");
            this.checkFormatString(this.mailSubject.getText(), "mailSubject", "email subject");
            this.checkFormatString(this.mailBody.getText(), "mailBody", "email body");
        }

        private void checkFormatString(String formatString, String msgKey, String fieldName) {
            AbstractStringFormatComponent.FormatStyle formatStyle = AbstractStringFormatComponent.FormatStyle.PRINTF_FORMATTER;
            Locale locale = LocaleTools.parseLocaleString((String)this.formatLocale.getCombo().getText());
            Object[] testFormatArguments = AbstractStringFormatComponentCheck.getTestFormatArguments((Collection)this.getData().getParameters(ActivityConstants.AccessType.READ));
            String errMsg = "Error in %s:\n%s: %s";
            try {
                AbstractStringFormatComponent.format((AbstractStringFormatComponent.FormatStyle)formatStyle, (String)formatString, (Locale)locale, (Object[])testFormatArguments);
                this.removeMessage(msgKey);
            }
            catch (AbstractStringFormatComponent.FormatException ex) {
                Throwable cause = ex.getCause();
                String msg = errMsg;
                msg = String.format(msg, fieldName, cause.getClass().getName(), cause.getMessage());
                this.addMessage(msgKey, 3, msg);
            }
        }

        protected void loadData() {
            this.smtpSettingsHostname.setText(this.confGet("MailSMTPHostname"));
            this.smtpSettingsPort.setText(this.confGet("MailSMTPPort"));
            if (Boolean.TRUE.equals(this.getData().getConfiguration().getBoolean("MailSMTPUseTLS"))) {
                this.smtpSettingsEncryption.select(1);
            } else if (Boolean.TRUE.equals(this.getData().getConfiguration().getBoolean("MailSMTPUseSSL"))) {
                this.smtpSettingsEncryption.select(2);
            } else {
                this.smtpSettingsEncryption.select(0);
            }
            this.smtpSettingsUsername.setText(this.confGet("MailSMTPUsername"));
            this.smtpSettingsPassword.setText(this.confGet("MailSMTPPassword"));
            this.mailTo.setText(this.confGet("MailTo"));
            this.mailFrom.setText(this.confGet("MailFrom"));
            this.mailSubject.setText(this.confGet("MailSubject"));
            this.mailBody.setText(this.confGet("MailBody"));
            this.formatLocale.getCombo().setText(this.confGet("FormatLocale"));
            AbstractStringFormatComponent.FormatStyle formatStyle = AbstractStringFormatComponent.FormatStyle.fromToken((String)this.confGet("FormatStyle"));
            if (formatStyle == null) {
                formatStyle = AbstractStringFormatComponent.FormatStyle.PRINTF_FORMATTER;
            }
            this.formatStyle.setSelection((ISelection)new StructuredSelection((Object)formatStyle));
            this.formatArguments.setInputParameters(this.getData().getParameters(ActivityConstants.AccessType.READ));
        }

        protected void saveData() {
            ChangeableActivityConfiguration conf = this.getData().getConfiguration();
            conf.setString("MailSMTPHostname", this.smtpSettingsHostname.getText());
            conf.setString("MailSMTPPort", this.smtpSettingsPort.getText());
            switch (this.smtpSettingsEncryption.getSelectionIndex()) {
                case 1: {
                    conf.setBoolean("MailSMTPUseTLS", true);
                    conf.setBoolean("MailSMTPUseSSL", false);
                    break;
                }
                case 2: {
                    conf.setBoolean("MailSMTPUseTLS", false);
                    conf.setBoolean("MailSMTPUseSSL", true);
                    break;
                }
                default: {
                    conf.setBoolean("MailSMTPUseTLS", false);
                    conf.setBoolean("MailSMTPUseSSL", false);
                }
            }
            conf.setString("MailSMTPUsername", this.smtpSettingsUsername.getText());
            conf.setString("MailSMTPPassword", this.smtpSettingsPassword.getText());
            conf.setString("MailTo", this.mailTo.getText());
            conf.setString("MailFrom", this.mailFrom.getText());
            conf.setString("MailSubject", this.mailSubject.getText());
            conf.setString("MailBody", this.mailBody.getText());
            if (this.formatLocale.getCombo().getText().trim().equals("")) {
                conf.remove("FormatLocale");
            } else {
                conf.setString("FormatLocale", this.formatLocale.getCombo().getText());
            }
            AbstractStringFormatComponent.FormatStyle formatStyle = (AbstractStringFormatComponent.FormatStyle)((StructuredSelection)this.formatStyle.getSelection()).getFirstElement();
            conf.setString("FormatStyle", formatStyle.token());
            for (ProcessModelParameter param : this.getData().getParameters(ActivityConstants.AccessType.READ)) {
                ChangeableActivityConfiguration paramConf = this.formatArguments.adaptParameterConfiguration((Parameter)param);
                ProcessModelParameter newParam = Activator.getService().getProcessModelFactory().createProcessModelParameter(param.getName(), param.getDescription(), param.getDataType(), param.getUDTName(), param.getIdentifierID(), param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), (ActivityConfiguration)paramConf, (PluginDataContainer)param, param.getUserAttributes());
                this.getData().changeParameter(param, newParam, ActivityConstants.AccessType.READ);
            }
        }
    }
}

