/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.ui;

import de.aristaflow.adept2.extensions.tools.environments.AbstractStringFormatComponent;
import de.aristaflow.adept2.extensions.tools.ui.Activator;
import de.aristaflow.adept2.extensions.tools.ui.FormatArgumentUIComponent;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizardPage;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.PnPWizardChangeListener;
import de.aristaflow.adept2.ui.util.components.LocaleUIComponent;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StringFormatComponentWizard
extends ExecutableComponentWizard {
    public StringFormatComponentWizard() {
        this.addPage((IWizardPage)new StringFormatWizardPage(this));
    }

    public void changeNotify(PnPWizardChangeListener.PnPWizardChangeType type, Object affectedObject) {
        super.changeNotify(type, affectedObject);
        switch (type) {
            case READ_PARAMETER_ADDED: 
            case READ_PARAMETER_REMOVED: 
            case READ_PARAMETER_CHANGED: {
                this.refreshAllPages();
            }
        }
    }

    private static class StringFormatWizardPage
    extends ExecutableComponentWizardPage {
        public static final String PAGE_NAME = "de.aristaflow.tools.StringFormat";
        private LocaleUIComponent formatLocale;
        private ComboViewer formatStyle;
        FormatArgumentUIComponent formatArguments;

        public StringFormatWizardPage(ExecutableComponentWizard pageSet) {
            super(pageSet, PAGE_NAME);
            this.setTitle("Configuration");
            this.setDescription("Format strings using process data.");
        }

        public void createControl(Composite parent) {
            Composite page = new Composite(parent, 0);
            page.setLayout((Layout)new MigLayout("debug 500, wrap, fill", "[grow, fill]"));
            Group formatSettingsArea = new Group(page, 0);
            formatSettingsArea.setLayoutData((Object)"growy");
            formatSettingsArea.setText("Format Settings");
            formatSettingsArea.setLayout((Layout)new MigLayout("debug 500, wrap", "[][grow, fill]"));
            new Label((Composite)formatSettingsArea, 0).setText("Locale:");
            this.formatLocale = new LocaleUIComponent((Composite)formatSettingsArea);
            this.formatLocale.getCombo().addModifyListener(this.getAutoCommitModifyListener());
            new Label((Composite)formatSettingsArea, 0).setText("Format Style:");
            this.formatStyle = new ComboViewer((Composite)formatSettingsArea, 8);
            this.formatStyle.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.formatStyle.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    AbstractStringFormatComponent.FormatStyle formatStyle = (AbstractStringFormatComponent.FormatStyle)element;
                    int maxArgCount = formatStyle.maxArgumentCount();
                    String text = formatStyle.token();
                    if (maxArgCount != Integer.MAX_VALUE) {
                        text = String.valueOf(text) + " (" + maxArgCount + " args max)";
                    }
                    return text;
                }
            });
            this.formatStyle.setInput((Object)AbstractStringFormatComponent.FormatStyle.values());
            this.formatStyle.addSelectionChangedListener(this.getAutoCommitSelectionChangedListener());
            this.formatStyle.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    AbstractStringFormatComponent.FormatStyle formatStyle = (AbstractStringFormatComponent.FormatStyle)selection.getFirstElement();
                    if (formatStyle != null) {
                        StringFormatWizardPage.this.formatArguments.setFormatStyle(formatStyle);
                    }
                }
            });
            Label formatSettingsArgumentOrderLabel = new Label((Composite)formatSettingsArea, 0);
            formatSettingsArgumentOrderLabel.setLayoutData((Object)"spanx");
            formatSettingsArgumentOrderLabel.setText("Argument Order:");
            this.formatArguments = new FormatArgumentUIComponent((Composite)formatSettingsArea);
            this.formatArguments.getControl().setLayoutData((Object)"span, push, grow, h 25:150");
            this.formatArguments.addSelectionListener(this.getAutoCommitSelectionListener());
            Text help1 = new Text((Composite)formatSettingsArea, 64);
            help1.setText("Select the input parameters that should be used as format arguments and arrange them in the desired order.");
            help1.setLayoutData((Object)"spanx, growx, w 0:0");
            help1.setBackground(formatSettingsArea.getBackground());
            Text help2 = new Text(page, 64);
            help2.setText("For each string to be formatted an output parameter must be created. The format string itself can be defined in its activity parameter configuration or come from an input parameter with the same name.");
            help2.setLayoutData((Object)"spanx, growx, w 0:0");
            help2.setBackground(page.getBackground());
            this.setControl((Control)page);
            this.refresh();
            this.commit();
        }

        protected void loadData() {
            this.formatLocale.getCombo().setText(this.confGet("FormatLocale"));
            AbstractStringFormatComponent.FormatStyle formatStyle = AbstractStringFormatComponent.FormatStyle.fromToken((String)this.confGet("FormatStyle"));
            if (formatStyle == null) {
                formatStyle = AbstractStringFormatComponent.FormatStyle.PRINTF_FORMATTER;
            }
            this.formatStyle.setSelection((ISelection)new StructuredSelection((Object)formatStyle));
            this.formatArguments.setInputParameters(this.getData().getParameters(ActivityConstants.AccessType.READ));
        }

        protected void saveData() {
            ChangeableActivityConfiguration conf = this.getData().getConfiguration();
            if (this.formatLocale.getCombo().getText().trim().equals("")) {
                conf.remove("FormatLocale");
            } else {
                conf.setString("FormatLocale", this.formatLocale.getCombo().getText());
            }
            AbstractStringFormatComponent.FormatStyle formatStyle = (AbstractStringFormatComponent.FormatStyle)((StructuredSelection)this.formatStyle.getSelection()).getFirstElement();
            conf.setString("FormatStyle", formatStyle.token());
            for (ProcessModelParameter param : this.getData().getParameters(ActivityConstants.AccessType.READ)) {
                ChangeableActivityConfiguration paramConf = this.formatArguments.adaptParameterConfiguration((Parameter)param);
                ProcessModelParameter newParam = Activator.getService().getProcessModelFactory().createProcessModelParameter(param.getName(), param.getDescription(), param.getDataType(), param.getUDTName(), param.getIdentifierID(), param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), (ActivityConfiguration)paramConf, (PluginDataContainer)param, param.getUserAttributes());
                this.getData().changeParameter(param, newParam, ActivityConstants.AccessType.READ);
            }
        }
    }
}

