/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.ui;

import de.aristaflow.adept2.extensions.tools.ui.Activator;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizardPage;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ValueProvidingComponentWizard
extends ExecutableComponentWizard {
    public ValueProvidingComponentWizard() {
        this.addPage((IWizardPage)new ValueProvidingWizardPage(this));
    }

    static class ParameterContentProvider
    implements IStructuredContentProvider {
        ParameterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Set) {
                Set set = (Set)inputElement;
                return set.toArray(new ProcessModelParameter[set.size()]);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class ParameterLabelProvider
    extends ColumnLabelProvider {
        ParameterLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ProcessModelParameter) {
                ProcessModelParameter param = (ProcessModelParameter)element;
                return param.getName();
            }
            return null;
        }
    }

    static class ValueEditingSupport
    extends EditingSupport {
        private final ValueProvidingWizardPage page;
        private final TableViewer tv;
        private CellEditor editor;

        public ValueEditingSupport(ValueProvidingWizardPage page, TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.page = page;
            this.tv = viewer;
        }

        protected void setValue(Object element, Object objValue) {
            if (element instanceof Parameter && objValue instanceof String) {
                Parameter p = (Parameter)element;
                String value = (String)objValue;
                if (p.getDataType() == ProcessConstants.AdeptDataType.FLOAT) {
                    value = value.replaceAll(",", ".");
                }
                this.page.values.put(p.getName(), value);
                this.tv.update(element, null);
                this.page.commit();
            }
        }

        protected Object getValue(Object element) {
            if (element instanceof Parameter) {
                String value = this.page.values.get(((Parameter)element).getName());
                return value == null ? "" : value;
            }
            return "";
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.editor == null) {
                this.editor = new TextCellEditor((Composite)this.tv.getTable());
            }
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }
    }

    private static class ValueLabelProvider
    extends ColumnLabelProvider {
        private final Map<String, String> values;

        ValueLabelProvider(Map<String, String> values) {
            this.values = values;
        }

        public String getText(Object element) {
            if (element instanceof Parameter) {
                return this.values.get(((Parameter)element).getName());
            }
            return null;
        }
    }

    private static class ValueProvidingWizardPage
    extends ExecutableComponentWizardPage {
        TableViewer tv;
        final Map<String, String> values = new HashMap<String, String>();
        private final ProcessModelFactory pmf;

        public ValueProvidingWizardPage(ExecutableComponentWizard pageSet) {
            super(pageSet, "de.aristaflow.tools.ValueProvidingEnvironment");
            this.setTitle("Configuration");
            this.setDescription("Set the value for each output parameter.");
            this.pmf = Activator.getService().getProcessModelFactory();
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new FillLayout());
            this.tv = new TableViewer(container, 100356);
            this.tv.getTable().setHeaderVisible(true);
            this.tv.getTable().setLinesVisible(true);
            TableViewerColumn pc = new TableViewerColumn(this.tv, 16384);
            pc.getColumn().setText("Parameter");
            pc.getColumn().setWidth(150);
            pc.setLabelProvider((CellLabelProvider)new ParameterLabelProvider());
            TableViewerColumn vc = new TableViewerColumn(this.tv, 16384);
            vc.getColumn().setText("Value");
            vc.getColumn().setWidth(350);
            vc.setLabelProvider((CellLabelProvider)new ValueLabelProvider(this.values));
            vc.setEditingSupport((EditingSupport)new ValueEditingSupport(this, this.tv));
            this.tv.setContentProvider((IContentProvider)new ParameterContentProvider());
            this.setControl((Control)container);
            this.refresh();
        }

        protected void loadData() {
            Set outParams = this.getData().getParameters(ActivityConstants.AccessType.WRITE);
            for (ProcessModelParameter param : outParams) {
                this.values.put(param.getName(), param.getConfiguration().getString("DefaultParameterValue"));
            }
            this.tv.setInput((Object)outParams);
        }

        protected void saveData() {
            boolean complete = true;
            for (ProcessModelParameter p : this.getData().getParameters(ActivityConstants.AccessType.WRITE)) {
                String oldValue = p.getConfiguration().getString("DefaultParameterValue");
                String newValue = this.values.get(p.getName());
                if (newValue == null || newValue.length() <= 0 || newValue.equals(oldValue)) continue;
                boolean bl = complete = complete && this.checkAndChangeParameterValue(p, oldValue, newValue);
            }
            this.setPageComplete(complete);
        }

        private boolean checkAndChangeParameterValue(ProcessModelParameter p, String oldValue, String newValue) {
            ChangeableActivityConfiguration conf = this.pmf.createChangeableActivityConfiguration(p.getConfiguration());
            boolean success = false;
            switch (p.getDataType()) {
                case BOOLEAN: {
                    Boolean b = ConfigurationTools.parseBoolean((String)newValue);
                    if (b == null) break;
                    conf.setBoolean("DefaultParameterValue", b.booleanValue());
                    success = true;
                    break;
                }
                case INTEGER: {
                    Long l = ConfigurationTools.parseInteger((String)newValue);
                    if (l == null) break;
                    conf.setInteger("DefaultParameterValue", l.longValue());
                    success = true;
                    break;
                }
                case FLOAT: {
                    Double f = ConfigurationTools.parseFloat((String)newValue);
                    if (f == null) break;
                    conf.setFloat("DefaultParameterValue", f.doubleValue());
                    success = true;
                    break;
                }
                case STRING: {
                    conf.setString("DefaultParameterValue", newValue);
                    success = true;
                    break;
                }
                case DATE: {
                    Date d = ConfigurationTools.parseDate((String)newValue);
                    if (d == null) break;
                    conf.setDate("DefaultParameterValue", d);
                    success = true;
                    break;
                }
                case URI: {
                    URI uri = ConfigurationTools.parseURI((String)newValue);
                    if (uri == null) break;
                    conf.setURI("DefaultParameterValue", uri);
                    success = true;
                    break;
                }
                case USERDEFINED: {
                    byte[] bytes = ConfigurationTools.parseUDT((String)newValue);
                    if (bytes == null) break;
                    conf.setUDT("DefaultParameterValue", bytes);
                    success = true;
                }
            }
            if (success) {
                this.removeMessage(p.getName());
                ProcessModelParameter newParam = this.pmf.createProcessModelParameter(p.getName(), p.getDescription(), p.getDataType(), p.getUDTName(), p.getIdentifierID(), p.isOptional(), p.isVirtual(), p.isFailure(), p.getDefaultValue(), (ActivityConfiguration)conf, (PluginDataContainer)p, p.getUserAttributes());
                this.getData().changeParameter(p, newParam, ActivityConstants.AccessType.WRITE);
            } else {
                String msg = String.format("'%s' is not accepted as %s value.", newValue, p.getDataType().name());
                this.addMessage(p.getName(), 3, msg);
                conf.setString("DefaultParameterValue", newValue);
                ProcessModelParameter newParam = this.pmf.createProcessModelParameter(p.getName(), p.getDescription(), p.getDataType(), p.getUDTName(), p.getIdentifierID(), p.isOptional(), p.isVirtual(), p.isFailure(), p.getDefaultValue(), (ActivityConfiguration)conf, (PluginDataContainer)p, p.getUserAttributes());
                this.getData().changeParameter(p, newParam, ActivityConstants.AccessType.WRITE);
            }
            return success;
        }
    }
}

