/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.tools.ui;

import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizardPage;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.ui.util.RadioGroupManager;
import de.aristaflow.adept2.util.Base64;
import de.aristaflow.adept2.util.FileTools;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.miginfocom.swt.MigLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class XSLTComponentWizard
extends ExecutableComponentWizard {
    public static final String PAGE_NAME = "de.aristaflow.xml.XSLT#transform";

    public XSLTComponentWizard() {
        this.addPage((IWizardPage)new XSLTWizardPage(this));
    }

    private static class XSLTWizardPage
    extends ExecutableComponentWizardPage {
        RadioGroupManager stylesheetSourceRadioGroup;
        Button stylesheetEmbedded;
        Button stylesheetDynamic;
        private Text stylesheetDynamicUrl;
        private RadioGroupManager xmlInputDataTypeRadioGroup;
        private Button xmlInputDataTypeString;
        private Button xmlInputDataTypeUserdefined;
        private Text xmlInputDataTypeUserdefinedUdtName;
        private RadioGroupManager xmlOutputDataTypeRadioGroup;
        private Button xmlOutputDataTypeString;
        private Button xmlOutputDataTypeUserdefined;
        private Text xmlOutputDataTypeUserdefinedUdtName;

        public XSLTWizardPage(XSLTComponentWizard pageSet) {
            super((ExecutableComponentWizard)pageSet, XSLTComponentWizard.PAGE_NAME);
            this.setTitle("Transformation");
            this.setDescription("Performs an XSL Transformation.");
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new MigLayout("wrap", "[grow, fill]"));
            Group stylesheetGroup = new Group(composite, 0);
            stylesheetGroup.setText("XSL Stylesheet");
            stylesheetGroup.setLayout((Layout)new MigLayout("wrap", "[][grow]"));
            Label stylesheetSourceLabel = new Label((Composite)stylesheetGroup, 0);
            stylesheetSourceLabel.setLayoutData((Object)"spanx");
            stylesheetSourceLabel.setText("Stylesheet Source:");
            this.stylesheetDynamic = new Button((Composite)stylesheetGroup, 16);
            this.stylesheetDynamic.setText("dynamic from URL");
            this.stylesheetDynamicUrl = new Text((Composite)stylesheetGroup, 2048);
            this.stylesheetDynamicUrl.setLayoutData((Object)"growx");
            this.stylesheetDynamicUrl.addModifyListener(this.getAutoCommitModifyListener());
            this.stylesheetEmbedded = new Button((Composite)stylesheetGroup, 16);
            this.stylesheetEmbedded.setText("embedded");
            this.stylesheetEmbedded.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (XSLTWizardPage.this.stylesheetEmbedded.getSelection() && !XSLTWizardPage.this.embedStylesheet()) {
                        XSLTWizardPage.this.stylesheetEmbedded.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                (this).XSLTWizardPage.this.stylesheetSourceRadioGroup.select((this).XSLTWizardPage.this.stylesheetDynamic);
                            }
                        });
                    }
                }
            });
            Button stylesheetEmbeddedLoad = new Button((Composite)stylesheetGroup, 0);
            stylesheetEmbeddedLoad.setText("Load...");
            stylesheetEmbeddedLoad.setLayoutData((Object)"right");
            stylesheetEmbeddedLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    XSLTWizardPage.this.embedStylesheet();
                }
            });
            this.stylesheetSourceRadioGroup = new RadioGroupManager((Composite)stylesheetGroup);
            this.stylesheetSourceRadioGroup.add(this.stylesheetDynamic, new Control[]{this.stylesheetDynamicUrl});
            this.stylesheetSourceRadioGroup.add(this.stylesheetEmbedded, new Control[]{stylesheetEmbeddedLoad});
            Group xmlInputGroup = new Group(composite, 0);
            xmlInputGroup.setText("XML Input");
            xmlInputGroup.setLayout((Layout)new MigLayout());
            Label xmlInputDataTypeLabel = new Label((Composite)xmlInputGroup, 0);
            xmlInputDataTypeLabel.setText("Parameter data type:");
            xmlInputDataTypeLabel.setLayoutData((Object)"spanx, wrap");
            this.xmlInputDataTypeString = new Button((Composite)xmlInputGroup, 16);
            this.xmlInputDataTypeString.setLayoutData((Object)"spanx, wrap");
            this.xmlInputDataTypeString.setText(ProcessConstants.AdeptDataType.STRING.toString());
            this.xmlInputDataTypeString.addSelectionListener(this.getAutoCommitSelectionListener());
            this.xmlInputDataTypeUserdefined = new Button((Composite)xmlInputGroup, 16);
            this.xmlInputDataTypeUserdefined.setText(ProcessConstants.AdeptDataType.USERDEFINED.toString());
            this.xmlInputDataTypeUserdefined.addSelectionListener(this.getAutoCommitSelectionListener());
            Label xmlInputDataTypeUserdefinedUdtNameLabel = new Label((Composite)xmlInputGroup, 0);
            xmlInputDataTypeUserdefinedUdtNameLabel.setLayoutData((Object)"gapx 20lp");
            xmlInputDataTypeUserdefinedUdtNameLabel.setText("UDT name:");
            this.xmlInputDataTypeUserdefinedUdtName = new Text((Composite)xmlInputGroup, 2048);
            this.xmlInputDataTypeUserdefinedUdtName.setLayoutData((Object)"pushx, growx");
            this.xmlInputDataTypeUserdefinedUdtName.addModifyListener(this.getAutoCommitModifyListener());
            this.xmlInputDataTypeRadioGroup = new RadioGroupManager((Composite)xmlInputGroup);
            this.xmlInputDataTypeRadioGroup.add(this.xmlInputDataTypeUserdefined, new Control[]{xmlInputDataTypeUserdefinedUdtNameLabel, this.xmlInputDataTypeUserdefinedUdtName});
            this.xmlInputDataTypeRadioGroup.select(this.xmlInputDataTypeUserdefined);
            Group xmlOutputGroup = new Group(composite, 0);
            xmlOutputGroup.setText("XML Output");
            xmlOutputGroup.setLayout((Layout)new MigLayout());
            Label xmlOutputDataTypeLabel = new Label((Composite)xmlOutputGroup, 0);
            xmlOutputDataTypeLabel.setText("Parameter data type:");
            xmlOutputDataTypeLabel.setLayoutData((Object)"spanx, wrap");
            this.xmlOutputDataTypeString = new Button((Composite)xmlOutputGroup, 16);
            this.xmlOutputDataTypeString.setLayoutData((Object)"spanx, wrap");
            this.xmlOutputDataTypeString.setText(ProcessConstants.AdeptDataType.STRING.toString());
            this.xmlOutputDataTypeString.addSelectionListener(this.getAutoCommitSelectionListener());
            this.xmlOutputDataTypeUserdefined = new Button((Composite)xmlOutputGroup, 16);
            this.xmlOutputDataTypeUserdefined.setText(ProcessConstants.AdeptDataType.USERDEFINED.toString());
            this.xmlOutputDataTypeUserdefined.addSelectionListener(this.getAutoCommitSelectionListener());
            Label xmlOutputDataTypeUserdefinedUdtNameLabel = new Label((Composite)xmlOutputGroup, 0);
            xmlOutputDataTypeUserdefinedUdtNameLabel.setLayoutData((Object)"gapx 20lp");
            xmlOutputDataTypeUserdefinedUdtNameLabel.setText("UDT name:");
            this.xmlOutputDataTypeUserdefinedUdtName = new Text((Composite)xmlOutputGroup, 2048);
            this.xmlOutputDataTypeUserdefinedUdtName.setLayoutData((Object)"pushx, growx");
            this.xmlOutputDataTypeUserdefinedUdtName.addModifyListener(this.getAutoCommitModifyListener());
            this.xmlOutputDataTypeRadioGroup = new RadioGroupManager((Composite)xmlOutputGroup);
            this.xmlOutputDataTypeRadioGroup.add(this.xmlOutputDataTypeUserdefined, new Control[]{xmlOutputDataTypeUserdefinedUdtNameLabel, this.xmlOutputDataTypeUserdefinedUdtName});
            this.xmlOutputDataTypeRadioGroup.select(this.xmlOutputDataTypeUserdefined);
            this.setControl((Control)composite);
            this.refresh();
            this.commit();
        }

        boolean embedStylesheet() {
            FileDialog fidi = new FileDialog(this.getShell(), 4096);
            fidi.setFilterExtensions(new String[]{"*.xsl"});
            fidi.setFilterNames(new String[]{"XSL Stylesheet"});
            String filePath = fidi.open();
            if (filePath != null) {
                File xslFile = new File(filePath);
                try {
                    byte[] xslBytes = FileTools.toByteArray((File)xslFile);
                    String xslString = Base64.encodeBytes((byte[])xslBytes, (int)2);
                    this.getData().getConfiguration().setString("Stylesheet", xslString);
                    this.commit();
                }
                catch (IOException ex) {
                    String msg = "Could not read the XSL stylesheet file!";
                    StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
                    return false;
                }
                return true;
            }
            return false;
        }

        protected void updatePageComplete() {
            String stylesheetUrl;
            boolean complete = true;
            if (this.stylesheetDynamic.getSelection() && (stylesheetUrl = this.stylesheetDynamicUrl.getText()).length() == 0) {
                complete = false;
            }
            this.setPageComplete(complete);
        }

        protected void loadData() {
            ProcessModelParameter xmlOutputParam;
            ChangeableActivityConfiguration conf = this.getData().getConfiguration();
            String stylesheet = conf.getString("Stylesheet");
            String stylesheetUri = conf.getString("StylesheetURI");
            if (stylesheet != null) {
                this.stylesheetSourceRadioGroup.select(this.stylesheetEmbedded);
            } else {
                this.stylesheetSourceRadioGroup.select(this.stylesheetDynamic);
                if (stylesheetUri != null) {
                    this.stylesheetDynamicUrl.setText(stylesheetUri);
                } else {
                    this.stylesheetDynamicUrl.setText("");
                }
            }
            ProcessModelParameter xmlInputParam = this.getData().getParameter("inputXML", ActivityConstants.AccessType.READ);
            if (xmlInputParam != null) {
                ProcessConstants.AdeptDataType dataType = xmlInputParam.getDataType();
                if (dataType == ProcessConstants.AdeptDataType.STRING) {
                    this.xmlInputDataTypeRadioGroup.select(this.xmlInputDataTypeString);
                } else {
                    this.xmlInputDataTypeRadioGroup.select(this.xmlInputDataTypeUserdefined);
                    String udtName = xmlInputParam.getUDTName();
                    if (udtName == null) {
                        udtName = "";
                    }
                    this.xmlInputDataTypeUserdefinedUdtName.setText(udtName);
                }
            }
            if ((xmlOutputParam = this.getData().getParameter("outputXML", ActivityConstants.AccessType.WRITE)) != null) {
                ProcessConstants.AdeptDataType dataType = xmlOutputParam.getDataType();
                if (dataType == ProcessConstants.AdeptDataType.STRING) {
                    this.xmlOutputDataTypeRadioGroup.select(this.xmlOutputDataTypeString);
                } else {
                    this.xmlOutputDataTypeRadioGroup.select(this.xmlOutputDataTypeUserdefined);
                    String udtName = xmlOutputParam.getUDTName();
                    if (udtName == null) {
                        udtName = "";
                    }
                    this.xmlOutputDataTypeUserdefinedUdtName.setText(udtName);
                }
            }
        }

        protected void saveData() {
            String udtName;
            ProcessConstants.AdeptDataType dataType;
            ChangeableActivityConfiguration conf = this.getData().getConfiguration();
            if (this.stylesheetDynamic.getSelection()) {
                conf.setString("StylesheetURI", this.stylesheetDynamicUrl.getText());
                conf.remove("Stylesheet");
            } else {
                conf.remove("StylesheetURI");
            }
            ProcessModelParameter oldXmlInputParam = this.getData().getParameter("inputXML", ActivityConstants.AccessType.READ);
            String description = "input parameter for the XML document to be transformed";
            if (this.xmlInputDataTypeUserdefined.getSelection()) {
                dataType = ProcessConstants.AdeptDataType.USERDEFINED;
                udtName = this.xmlInputDataTypeUserdefinedUdtName.getText();
            } else {
                dataType = ProcessConstants.AdeptDataType.STRING;
                udtName = null;
            }
            UUID identifierID = ProcessConstants.UNIVERSAL_IDENTIFIER_ID;
            ProcessModelParameter newXmlInputParam = Activator.getService().getProcessModelFactory().createProcessModelParameter("inputXML", description, dataType, udtName, identifierID, false, false, false, null, null, null, null);
            if (oldXmlInputParam == null) {
                this.getData().addParameter(newXmlInputParam, ActivityConstants.AccessType.READ);
            } else {
                this.getData().changeParameter(oldXmlInputParam, newXmlInputParam, ActivityConstants.AccessType.READ);
            }
            ProcessModelParameter oldXmlOutputParam = this.getData().getParameter("outputXML", ActivityConstants.AccessType.WRITE);
            description = "output parameter for the transformed XML document";
            if (this.xmlOutputDataTypeUserdefined.getSelection()) {
                dataType = ProcessConstants.AdeptDataType.USERDEFINED;
                udtName = this.xmlOutputDataTypeUserdefinedUdtName.getText();
            } else {
                dataType = ProcessConstants.AdeptDataType.STRING;
                udtName = null;
            }
            identifierID = ProcessConstants.UNIVERSAL_IDENTIFIER_ID;
            ProcessModelParameter newXmlOutputParam = Activator.getService().getProcessModelFactory().createProcessModelParameter("outputXML", description, dataType, udtName, identifierID, false, false, false, null, null, null, null);
            if (oldXmlOutputParam == null) {
                this.getData().addParameter(newXmlOutputParam, ActivityConstants.AccessType.WRITE);
            } else {
                this.getData().changeParameter(oldXmlOutputParam, newXmlOutputParam, ActivityConstants.AccessType.WRITE);
            }
        }
    }
}

