/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultDecisionID;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.RootTreeNode;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeNode;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.DecisionID;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.TreeChangeListener;
import de.aristaflow.adept2.extensions.xorsupport.ui.BranchTreeContentProvider;
import de.aristaflow.adept2.extensions.xorsupport.ui.ComparableViewerSorter;
import de.aristaflow.adept2.extensions.xorsupport.ui.ExpressionOrderWindow;
import de.aristaflow.adept2.extensions.xorsupport.ui.SaveLoadHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class AssignBranchesWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "de.aristaflow.rules.XOR#branches";
    protected List<DecisionID> listModel = new ArrayList<DecisionID>();
    protected BranchTreeManager treeManager;
    protected TreeViewer branchTree;
    protected SashForm container;
    protected SashForm bottomContainer;
    protected Composite leftPanel;
    protected Composite rightPanel;
    protected TabFolder selectedCombinationTab;
    protected Text selectedPath;
    protected Text selectedDisjunction;
    protected ListViewer decisionIDList;
    protected MarkerLabelProvider<DecisionID> decisionIDListLabelProvider;
    protected Text decisionIDText;
    protected Button delDecisionID;
    protected Button setDecisionID;
    protected Button addAutoDecisionID;
    protected Button saveButton;
    protected Button reorderButton;
    protected Button jumpNextButton;
    protected DecisionID selectedDecisionID;
    protected Set<DecisionID> updatedIDs = new HashSet<DecisionID>();
    protected static final String DNF_SELECTED_DECISION_ID = "Decision statement (DNF) for selected decision ID";
    protected static final String SELECTED_PATH = "Conjunction for selected predicate combination";
    protected static final String SELECTED_DECISION_ID = "Selected decision ID:";
    protected static final String NO_PATH_SELECTED = "(no predicate selected)";
    protected static final String NO_DECISION_ID_SELECTED = "(no decision ID selected)";
    protected static final String ADD = "Add";
    protected static final String SET = "Set";
    protected static final String ADD_AUTO = "Add Auto";
    protected static final String ADD_AUTO_TOOLTIP = "Adds a decision ID whose label is automatically updated to show the decision statement.";
    protected static final String DELETE = "Delete";
    protected static final String TITLE = "Decision IDs";
    protected static final String CONFIRM_SUBTREESET_MSG = "This will overwrite the decision IDs of all items in this subtree.";
    protected static final String CONFIRM_DEL_BRANCHID = "Delete the selected decision ID?";
    protected static final String COLUMN0_TEXT = "Description";
    protected static final String COLUMN1_TEXT = "Decision ID";
    protected static final String REORDER_EXPRESSIONS = "Reorder dimensions...";
    protected static final String JUMP_NEXT_UNASSIGNED = "Find node with unassigned ID";
    protected static final String E_NOT_ALL_BRANCHES_ASSIGNED = "There is still 1 tree node with an unassigned decision ID left!";
    protected static final String E_NOT_ALL_BRANCHES_ASSIGNED_PLURAL = "There are still %s tree nodes with unassigned decision IDs left!";
    protected static final String E_DECISION_ID_WITHOUT_PREDICATE = "1 decision ID is not assigned to any predicate combination.";
    protected static final String E_DECISION_IDS_WITHOUT_PREDICATE = "%s decision IDs are not assigned to any predicate combination.";
    protected static final String DESCRIPTION = "Please assign decision IDs to all of the predicate combinations here. The decision IDs will be mapped to actual edges in the next step.";
    protected static final String UNASSIGNED_MARKER = "<unassigned> ";
    protected static final String AUTO = "<auto>";
    protected static final String[] decisionIDProps = new String[]{"decisionID"};
    protected boolean needTreeRefresh = false;

    public AssignBranchesWizardPage(BranchTreeManager treeManager) {
        super(PAGE_NAME, TITLE, null);
        this.treeManager = treeManager;
    }

    public void createControl(Composite parent) {
        this.container = new SashForm(parent, 512);
        this.setControl((Control)this.container);
        this.selectedCombinationTab = new TabFolder((Composite)this.container, 2048);
        this.selectedPath = new Text((Composite)this.selectedCombinationTab, 2626);
        this.selectedPath.setBackground(Display.getDefault().getSystemColor(22));
        this.selectedPath.setEditable(false);
        this.selectedPath.setLayoutData((Object)new GridData(4, 4, true, true));
        this.selectedDisjunction = new Text((Composite)this.selectedCombinationTab, 2626);
        this.selectedDisjunction.setBackground(Display.getDefault().getSystemColor(22));
        this.selectedDisjunction.setEditable(false);
        TabItem tabItem = new TabItem(this.selectedCombinationTab, 0);
        tabItem.setText(SELECTED_PATH);
        tabItem.setControl((Control)this.selectedPath);
        tabItem = new TabItem(this.selectedCombinationTab, 0);
        tabItem.setText(DNF_SELECTED_DECISION_ID);
        tabItem.setControl((Control)this.selectedDisjunction);
        this.bottomContainer = new SashForm((Composite)this.container, 256);
        this.container.setWeights(new int[]{1, 5});
        this.leftPanel = new Composite((Composite)this.bottomContainer, 0);
        this.leftPanel.setLayout((Layout)new GridLayout(2, false));
        Tree branchTreeTree = new Tree(this.leftPanel, 68356);
        branchTreeTree.setHeaderVisible(true);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        branchTreeTree.setLayoutData((Object)gd);
        TreeColumn col = new TreeColumn(branchTreeTree, 16384);
        col.setText(COLUMN0_TEXT);
        col.setWidth(300);
        col = new TreeColumn(branchTreeTree, 16384);
        col.setText(COLUMN1_TEXT);
        col.setWidth(60);
        this.branchTree = new TreeViewer(branchTreeTree);
        this.branchTree.setColumnProperties(new String[]{"description", "decisionID"});
        this.reorderButton = new Button(this.leftPanel, 8);
        this.reorderButton.setText(REORDER_EXPRESSIONS);
        this.reorderButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                new ExpressionOrderWindow(AssignBranchesWizardPage.this.getWizard().getContainer().getShell(), AssignBranchesWizardPage.this.treeManager);
            }
        });
        this.jumpNextButton = new Button(this.leftPanel, 8);
        this.jumpNextButton.setText(JUMP_NEXT_UNASSIGNED);
        this.jumpNextButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BranchTreeNode nextNode = AssignBranchesWizardPage.this.treeManager.getOverallRoot().nextUnassignedDecisionID();
                AssignBranchesWizardPage.this.branchTree.setSelection((ISelection)new StructuredSelection((Object)nextNode), true);
            }
        });
        this.rightPanel = new Composite((Composite)this.bottomContainer, 0);
        this.bottomContainer.setWeights(new int[]{3, 2});
        this.rightPanel.setLayout((Layout)new GridLayout(2, false));
        Label tmpLabel = new Label(this.rightPanel, 0);
        tmpLabel.setText(SELECTED_DECISION_ID);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        tmpLabel.setLayoutData((Object)gd);
        this.decisionIDText = new Text(this.rightPanel, 2052);
        this.decisionIDText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DecisionIDTextListener decisionIDTextLnr = new DecisionIDTextListener();
        this.decisionIDText.addFocusListener((FocusListener)decisionIDTextLnr);
        this.decisionIDText.addModifyListener((ModifyListener)decisionIDTextLnr);
        this.decisionIDText.addTraverseListener((TraverseListener)decisionIDTextLnr);
        this.decisionIDText.addSelectionListener((SelectionListener)decisionIDTextLnr);
        this.setDecisionID = new Button(this.rightPanel, 8);
        this.setDecisionID.setText(SET);
        this.setDecisionID.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.setDecisionID.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AssignBranchesWizardPage.this.decideSetOrAddDecisionID();
            }
        });
        this.decisionIDList = new ListViewer(this.rightPanel, 2820);
        gd = new GridData(4, 4, true, true);
        gd.verticalSpan = 2;
        this.decisionIDList.setSorter((ViewerSorter)ComparableViewerSorter.sharedInstance);
        this.decisionIDList.getList().setLayoutData((Object)gd);
        this.decisionIDList.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DecisionID selItem = (DecisionID)((IStructuredSelection)AssignBranchesWizardPage.this.decisionIDList.getSelection()).getFirstElement();
                AssignBranchesWizardPage.this.setDecisionIDTextToID(selItem);
                AssignBranchesWizardPage.this.updateInputWidgets();
                AssignBranchesWizardPage.this.selectedCombinationTab.setSelection(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AssignBranchesWizardPage.this.doSetDecisionID();
            }
        });
        this.decisionIDListLabelProvider = new MarkerLabelProvider();
        this.decisionIDList.setLabelProvider(this.decisionIDListLabelProvider);
        this.decisionIDList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.decisionIDList.setInput(this.listModel);
        this.addAutoDecisionID = new Button(this.rightPanel, 8);
        this.addAutoDecisionID.setText(ADD_AUTO);
        this.addAutoDecisionID.setToolTipText(ADD_AUTO_TOOLTIP);
        this.addAutoDecisionID.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addAutoDecisionID.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AssignBranchesWizardPage.this.doAddDecisionID(null);
            }
        });
        this.delDecisionID = new Button(this.rightPanel, 8);
        this.delDecisionID.setText(DELETE);
        this.delDecisionID.setLayoutData((Object)new GridData(4, 128, false, true));
        this.delDecisionID.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AssignBranchesWizardPage.this.doDelDecisionID();
            }
        });
        this.branchTree.setContentProvider((IContentProvider)new BranchTreeContentProvider(this.treeManager));
        this.treeManager.getChangeListeners().add(new TreeChangeListener(){
            private final List<BranchTreeNode> updateList = new ArrayList<BranchTreeNode>();

            public void treeChanged(TreeChangeListener.TreeChangeKind changeKind, List<BranchTreeNode> affectedNode) {
                if (!AssignBranchesWizardPage.this.isCurrentPage()) {
                    AssignBranchesWizardPage.this.needTreeRefresh = true;
                    return;
                }
                switch (changeKind) {
                    case TREE_REBUILT: {
                        AssignBranchesWizardPage.this.loadTree();
                        break;
                    }
                    case SUBTREE_ADDED: 
                    case SUBTREE_REMOVED: {
                        BranchTreeNode lastParent = null;
                        for (BranchTreeNode node : affectedNode) {
                            BranchTreeNode parent = node.getParent();
                            if (parent == lastParent) continue;
                            AssignBranchesWizardPage.this.branchTree.refresh((Object)parent);
                            this.needsUpdateParentDecisionIDs(parent);
                            lastParent = parent;
                        }
                        AssignBranchesWizardPage.this.branchTree.expandAll();
                        break;
                    }
                    case NODE_UPDATED: {
                        for (BranchTreeNode node : affectedNode) {
                            AssignBranchesWizardPage.this.branchTree.update((Object)node, null);
                            this.needsUpdateParentDecisionIDs(node);
                        }
                        break;
                    }
                    case SUBTREE_UPDATED: {
                        for (BranchTreeNode node : affectedNode) {
                            AssignBranchesWizardPage.this.branchTree.refresh((Object)node, true);
                            this.needsUpdateParentDecisionIDs(node);
                        }
                        break;
                    }
                }
                this.updateParentDecisionIDs();
                AssignBranchesWizardPage.this.checkPageComplete();
            }

            private void updateParentDecisionIDs() {
                if (this.updateList.size() > 0) {
                    AssignBranchesWizardPage.this.branchTree.update(this.updateList.toArray(), decisionIDProps);
                    this.updateList.clear();
                }
            }

            private void needsUpdateParentDecisionIDs(BranchTreeNode node) {
                BranchTreeNode parent = node.getParent();
                while (parent != null && !(parent instanceof RootTreeNode) && !this.updateList.contains(parent)) {
                    this.updateList.add(parent);
                    parent = parent.getParent();
                }
            }
        });
        this.branchTree.setLabelProvider((IBaseLabelProvider)new DecisionIDLabelProvider());
        this.branchTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ITreeSelection sel = (ITreeSelection)event.getSelection();
                AssignBranchesWizardPage.this.selectedDecisionID = null;
                TreePath[] selPaths = sel.getPaths();
                if (selPaths.length > 0) {
                    TreePath path = selPaths[0];
                    AssignBranchesWizardPage.this.selectedPath.setText(AssignBranchesWizardPage.pathToString(path));
                    if (AssignBranchesWizardPage.this.selectsPredicateNode(path)) {
                        AssignBranchesWizardPage.this.selectedDecisionID = ((BranchTreeNode)path.getLastSegment()).getSubtreeDecisionID();
                    }
                } else {
                    AssignBranchesWizardPage.this.selectedPath.setText(AssignBranchesWizardPage.NO_PATH_SELECTED);
                }
                if (AssignBranchesWizardPage.this.selectedDecisionID != null) {
                    AssignBranchesWizardPage.this.setDecisionIDTextToID(AssignBranchesWizardPage.this.selectedDecisionID);
                } else {
                    AssignBranchesWizardPage.this.decisionIDText.setText("");
                    AssignBranchesWizardPage.this.decisionIDList.getList().deselectAll();
                }
                AssignBranchesWizardPage.this.updateInputWidgets();
                AssignBranchesWizardPage.this.selectedCombinationTab.setSelection(0);
            }
        });
        this.saveButton = SaveLoadHelper.createSaveButton(this.rightPanel, (IWizardPage)this, this.treeManager);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.saveButton.setLayoutData((Object)gd);
        this.loadDecisionIDList();
        this.loadTree();
        this.setPageComplete(false);
        this.setDescription(DESCRIPTION);
        this.container.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                AssignBranchesWizardPage.this.loadDecisionIDList();
                AssignBranchesWizardPage.this.branchTree.refresh();
                AssignBranchesWizardPage.this.branchTree.expandAll();
                AssignBranchesWizardPage.this.checkPageComplete();
                AssignBranchesWizardPage.this.needTreeRefresh = false;
            }
        });
    }

    protected boolean selectsPredicateNode(TreePath path) {
        return ((BranchTreeNode)path.getLastSegment()).getPredicate() != null;
    }

    protected boolean isDecisionIDPresent(String id) {
        return id.length() > 0 && (id.equals("<none>") || id.equals(AUTO) || this.findIDWithLabel(id) != null);
    }

    protected void updateInputWidgets() {
        DecisionID selection;
        boolean enableAdd = false;
        boolean enableSet = false;
        boolean enableDel = false;
        boolean enable = false;
        TreePath[] selPaths = ((ITreeSelection)this.branchTree.getSelection()).getPaths();
        if (selPaths.length > 0) {
            enable = this.selectsPredicateNode(selPaths[0]);
        }
        if (enable) {
            String enteredID = this.decisionIDText.getText();
            enableSet = this.decisionIDList.getList().getSelectionIndex() >= 0 && (this.selectedDecisionID == null || this.selectedDecisionID.getLabel() == null || !this.selectedDecisionID.getLabel().equals(enteredID));
            enableAdd = !this.isDecisionIDPresent(enteredID);
            boolean bl = enableDel = this.decisionIDList.getList().getSelectionIndex() > 0;
        }
        if ((selection = (DecisionID)((IStructuredSelection)this.decisionIDList.getSelection()).getFirstElement()) == null || selection.equals(DecisionID.UNASSIGNED)) {
            this.selectedDisjunction.setText(NO_DECISION_ID_SELECTED);
        } else {
            String statement;
            if (selection.equals(DecisionID.UNASSIGNED)) {
                statement = NO_DECISION_ID_SELECTED;
            } else {
                statement = selection.calculateStatement();
                if (statement == null) {
                    statement = NO_DECISION_ID_SELECTED;
                }
            }
            this.selectedDisjunction.setText(statement);
        }
        this.decisionIDList.getList().setEnabled(enable);
        this.decisionIDText.setEnabled(enable);
        this.setDecisionID.setEnabled(enableSet || enableAdd);
        this.delDecisionID.setEnabled(enableDel);
        this.addAutoDecisionID.setEnabled(enable);
    }

    protected static String pathToString(TreePath path) {
        StringBuilder selText = new StringBuilder();
        int i = 1;
        while (i < path.getSegmentCount()) {
            selText.append('{').append(path.getSegment(i)).append('}').append(" && ");
            ++i;
        }
        if (selText.length() > " && ".length()) {
            if (((BranchTreeNode)path.getLastSegment()).getChildren().size() > 0) {
                selText.append("...");
            } else {
                selText.delete(selText.length() - " && ".length(), selText.length());
            }
            return selText.toString();
        }
        return NO_PATH_SELECTED;
    }

    protected void doAddDecisionID(String enteredID) {
        if (enteredID != null && enteredID.length() == 0) {
            return;
        }
        DefaultDecisionID newID = new DefaultDecisionID(this.treeManager, this.treeManager.getNextDecisionIDIndex(), enteredID);
        this.treeManager.getAvailableDecisionIDs().add(newID);
        this.listModel.add((DecisionID)newID);
        this.decisionIDList.add((Object)newID);
        this.decisionIDList.setSelection((ISelection)new StructuredSelection((Object)newID));
        this.setDecisionID((DecisionID)newID);
    }

    protected void doSetDecisionID() {
        DecisionID selID = (DecisionID)((IStructuredSelection)this.decisionIDList.getSelection()).getFirstElement();
        if (selID != null) {
            this.setDecisionID(selID);
        }
    }

    protected void decideSetOrAddDecisionID() {
        if (this.isDecisionIDPresent(this.decisionIDText.getText())) {
            this.doSetDecisionID();
        } else {
            this.doAddDecisionID(this.decisionIDText.getText());
        }
    }

    protected void doDelDecisionID() {
        DecisionID selID = (DecisionID)((IStructuredSelection)this.decisionIDList.getSelection()).getFirstElement();
        if (selID != null && !selID.equals(DecisionID.UNASSIGNED) && MessageDialog.openQuestion((Shell)this.getShell(), (String)TITLE, (String)CONFIRM_DEL_BRANCHID)) {
            this.treeManager.removeDecisionID(selID);
            this.listModel.remove(selID);
            this.decisionIDList.remove((Object)selID);
            this.selectedDisjunction.setText(NO_DECISION_ID_SELECTED);
            this.checkPageComplete();
        }
    }

    protected void setDecisionID(DecisionID selection) {
        TreePath path;
        if (selection == null) {
            return;
        }
        ITreeSelection sel = (ITreeSelection)this.branchTree.getSelection();
        TreePath[] selPaths = sel.getPaths();
        HashSet<DecisionID> treeUpdateIDs = new HashSet<DecisionID>();
        if (selPaths.length > 0 && this.selectsPredicateNode(path = selPaths[0])) {
            BranchTreeNode selectedNode = (BranchTreeNode)path.getLastSegment();
            if (selectedNode.getChildren().size() > 0) {
                if (selectedNode.getSubtreeDecisionID() != null || MessageDialog.openConfirm((Shell)this.getShell(), (String)TITLE, (String)CONFIRM_SUBTREESET_MSG)) {
                    this.collectLeafIDs(selectedNode, treeUpdateIDs);
                    this.updatedIDs.addAll(treeUpdateIDs);
                    selectedNode.setDecisionID(selection, true);
                    this.selectedDecisionID = selection;
                }
            } else {
                this.updatedIDs.add(selectedNode.getDecisionID());
                treeUpdateIDs.add(selectedNode.getDecisionID());
                selectedNode.setDecisionID(selection, false);
                this.selectedDecisionID = selection;
            }
        }
        this.setDecisionIDTextToID(selection);
        this.updatedIDs.add(selection);
        treeUpdateIDs.add(selection);
        this.updateInputWidgets();
        ArrayList<BranchTreeNode> updatedNodes = new ArrayList<BranchTreeNode>();
        this.collectNodesWithID(this.treeManager.getOverallRoot(), treeUpdateIDs, updatedNodes);
        this.branchTree.update(updatedNodes.toArray(), decisionIDProps);
        this.checkPageComplete();
    }

    protected void collectLeafIDs(BranchTreeNode node, Set<DecisionID> result) {
        if (node.getChildren().size() == 0) {
            result.add(node.getDecisionID());
        } else {
            for (BranchTreeNode child : node.getChildren()) {
                this.collectLeafIDs(child, result);
            }
        }
    }

    protected void collectNodesWithID(BranchTreeNode node, Set<DecisionID> ids, List<BranchTreeNode> result) {
        if (ids.contains(node.getSubtreeDecisionID())) {
            result.add(node);
        }
        for (BranchTreeNode child : node.getChildren()) {
            this.collectNodesWithID(child, ids, result);
        }
    }

    protected void checkPageComplete() {
        HashSet assignedIDs = new HashSet();
        int numUnassigned = this.treeManager.getOverallRoot().numberOfUnassignedDecisionIDs(assignedIDs);
        this.updatedIDs.addAll(this.decisionIDListLabelProvider.markers.keySet());
        this.decisionIDListLabelProvider.markers.clear();
        if (numUnassigned > 0) {
            this.jumpNextButton.setEnabled(true);
            if (numUnassigned == 1) {
                this.setErrorMessage(E_NOT_ALL_BRANCHES_ASSIGNED);
            } else {
                this.setErrorMessage(String.format(E_NOT_ALL_BRANCHES_ASSIGNED_PLURAL, numUnassigned));
            }
            this.setPageComplete(false);
        } else {
            this.jumpNextButton.setEnabled(false);
            if (assignedIDs.size() < this.treeManager.getAvailableDecisionIDs().size()) {
                numUnassigned = this.treeManager.getAvailableDecisionIDs().size() - assignedIDs.size();
                if (numUnassigned == 1) {
                    this.setErrorMessage(E_DECISION_ID_WITHOUT_PREDICATE);
                } else {
                    this.setErrorMessage(String.format(E_DECISION_IDS_WITHOUT_PREDICATE, numUnassigned));
                }
                for (DecisionID id : this.treeManager.getAvailableDecisionIDs()) {
                    if (assignedIDs.contains(id)) continue;
                    this.decisionIDListLabelProvider.markers.put(id, UNASSIGNED_MARKER);
                    this.updatedIDs.add(id);
                }
                this.setPageComplete(false);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        }
        this.decisionIDList.update(this.updatedIDs.toArray(), null);
        this.updatedIDs.clear();
    }

    public void loadTree() {
        this.branchTree.setInput((Object)this.treeManager.getOverallRoot());
        this.branchTree.expandAll();
        this.branchTree.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{this.treeManager.getBranchTreeRoot()})));
    }

    public void loadDecisionIDList() {
        this.listModel.clear();
        this.listModel.add(DecisionID.UNASSIGNED);
        this.listModel.addAll(this.treeManager.getAvailableDecisionIDs());
        this.decisionIDList.refresh();
    }

    protected void setDecisionIDTextToID(DecisionID selItem) {
        String selText = "";
        if (selItem != null) {
            selText = selItem.getLabel() != null ? selItem.toString() : AUTO;
        }
        this.decisionIDText.setText(selText);
    }

    protected DecisionID findIDWithLabel(String label) {
        for (DecisionID id : this.treeManager.getAvailableDecisionIDs()) {
            if (id.getLabel() == null || !id.getLabel().equals(label)) continue;
            return id;
        }
        return null;
    }

    protected static class DecisionIDLabelProvider
    implements ITableLabelProvider {
        protected DecisionIDLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            BranchTreeNode node = (BranchTreeNode)element;
            switch (columnIndex) {
                case 0: {
                    return node.toString();
                }
                case 1: {
                    if (node instanceof RootTreeNode) {
                        return "";
                    }
                    DecisionID id = node.getSubtreeDecisionID();
                    if (id != null) {
                        return id.toString();
                    }
                    return "";
                }
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    protected class DecisionIDTextListener
    implements ModifyListener,
    TraverseListener,
    SelectionListener,
    FocusListener {
        protected DecisionIDTextListener() {
        }

        public void focusGained(FocusEvent e) {
            if (AssignBranchesWizardPage.this.decisionIDText.getText().equals("<none>")) {
                AssignBranchesWizardPage.this.decisionIDText.setText("");
            } else {
                AssignBranchesWizardPage.this.decisionIDText.selectAll();
            }
        }

        public void modifyText(ModifyEvent e) {
            String selText = AssignBranchesWizardPage.this.decisionIDText.getText();
            if (selText.equals(AssignBranchesWizardPage.AUTO) || selText.equals("<none>")) {
                return;
            }
            DecisionID selID = AssignBranchesWizardPage.this.findIDWithLabel(selText);
            if (selID != null) {
                AssignBranchesWizardPage.this.decisionIDList.setSelection((ISelection)new StructuredSelection((Object)selID), true);
            } else {
                AssignBranchesWizardPage.this.decisionIDList.getList().deselectAll();
            }
            AssignBranchesWizardPage.this.updateInputWidgets();
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 4) {
                e.doit = false;
                e.detail = 0;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            AssignBranchesWizardPage.this.decideSetOrAddDecisionID();
        }

        public void widgetSelected(SelectionEvent e) {
        }

        public void focusLost(FocusEvent e) {
        }
    }

    protected static class MarkerLabelProvider<T>
    extends LabelProvider {
        public final Map<T, String> markers = new HashMap<T, String>();

        protected MarkerLabelProvider() {
        }

        public String getText(Object element) {
            String marker = this.markers.get(element);
            if (marker != null) {
                return String.valueOf(marker) + element.toString();
            }
            return element.toString();
        }
    }
}

