/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultEdgeAssignment;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.EdgeAssignment;
import de.aristaflow.adept2.extensions.xorsupport.ui.ComparableViewerSorter;
import de.aristaflow.adept2.extensions.xorsupport.ui.EdgeTreeContentProvider;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ActivityPnPWizardData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class AssignEdgesWizardPage
extends WizardPage
implements IPageChangingListener {
    public static final String PAGE_NAME = "de.aristaflow.rules.XOR#edges";
    protected static final String S_PLEASE_SELECT_ONLY_A_SINGLE_EDGE_IN_THE_TREE = "Please select only a single edge in the tree on the left.";
    protected static final String S_PLEASE_SELECT_A_DECISION_ID_IN_THE_LIST = "Please select a decision ID in the list on the right.";
    protected static final String S_PLEASE_SELECT_AN_ITEM_IN_THE_TREE = "Please select an item in the tree on the left.";
    protected static final String NO_EDGE_SELECTED = "(no edge selected)";
    protected static final String DNF_SELECTED_EDGE = "Decision statement (DNF) for selected edge";
    protected static final String S_EXPLANATION = "Select a decision ID in the list of unassigned decision IDs and an edge in the assignment tree and click \">\" to assign a decision ID to an edge. \nSelect a decision ID in the assignment tree and click \"<\" to undo an assignment.";
    protected static final String S_UNASSIGNED_DECISION_IDS = "Unassigned decision IDs";
    protected static final String S_DECISION_ID_ASSIGNMENTS = "Assignments of decision IDs to edges";
    protected static final String TITLE = "Assign Edges";
    protected static final String S_ASSIGN = "Assign";
    protected static final String S_UNASSIGN = "Unassign";
    protected static final String S_STATEMENT_FOR = "Statement for";
    protected static final String S_DESCRIPTION = "Please assign the decision IDs to the actual edges of the XOR decision node.";
    protected static final String E_NOT_ALL_BRANCHES_ASSIGNED_PLURAL = "There are still %d unassigned decision IDs left";
    protected static final String E_NOT_ALL_BRANCHES_ASSIGNED = "There is still 1 unassigned decision ID left";
    protected static final String E_NOT_ALL_EDGES_ASSIGNED_PLURAL = "There are still %d edges that are not associated with a decision ID";
    protected static final String E_NOT_ALL_EDGES_ASSIGNED = "There is still 1 edge that is not associated with a decision ID";
    protected static final String DNF_SELECTED_DECISION_IDS = "Decision statement (DNF) for selected decision IDs";
    private static final int LEFT_RIGHT_BUTTON_SIZE = 25;
    protected List<EdgeAssignment> edgeList;
    protected Collection<DecisionStatement> decisionIDList;
    protected SashForm container;
    protected Composite bottomContainer;
    protected TreeViewer tree;
    protected Button moveRight;
    protected Button moveLeft;
    protected ListViewer decisionIDs;
    protected TabFolder selectedCombinationTab;
    protected Text selectedEdgeDisjunction;
    protected Text selectedDecisionIDDisjunction;
    protected ActivityPnPWizardData wizardData;
    protected static final Comparator<EdgeAssignment> edgeAssignmentComparator = new Comparator<EdgeAssignment>(){

        @Override
        public int compare(EdgeAssignment o1, EdgeAssignment o2) {
            long ec2;
            long ec1 = o1.getEdge().getEdgeCode();
            if (ec1 > (ec2 = o2.getEdge().getEdgeCode())) {
                return 1;
            }
            if (ec1 < ec2) {
                return -1;
            }
            return 0;
        }
    };

    public AssignEdgesWizardPage(ActivityPnPWizardData wizardData) {
        super(PAGE_NAME, TITLE, null);
        this.wizardData = wizardData;
        this.edgeList = new ArrayList<EdgeAssignment>();
        this.loadAssignmentsFromWizardData();
    }

    public void createControl(Composite parent) {
        this.container = new SashForm(parent, 512);
        this.setControl((Control)this.container);
        this.selectedCombinationTab = new TabFolder((Composite)this.container, 2048);
        this.selectedEdgeDisjunction = new Text((Composite)this.selectedCombinationTab, 2626);
        this.selectedEdgeDisjunction.setBackground(Display.getDefault().getSystemColor(22));
        this.selectedEdgeDisjunction.setEditable(false);
        this.selectedDecisionIDDisjunction = new Text((Composite)this.selectedCombinationTab, 2626);
        this.selectedDecisionIDDisjunction.setBackground(Display.getDefault().getSystemColor(22));
        this.selectedDecisionIDDisjunction.setEditable(false);
        TabItem tabItem = new TabItem(this.selectedCombinationTab, 0);
        tabItem.setText(DNF_SELECTED_EDGE);
        tabItem.setControl((Control)this.selectedEdgeDisjunction);
        tabItem = new TabItem(this.selectedCombinationTab, 0);
        tabItem.setText(DNF_SELECTED_DECISION_IDS);
        tabItem.setControl((Control)this.selectedDecisionIDDisjunction);
        this.bottomContainer = new Composite((Composite)this.container, 0);
        this.container.setWeights(new int[]{1, 5});
        this.bottomContainer.setLayout((Layout)new GridLayout(3, false));
        Label caption = new Label(this.bottomContainer, 0);
        caption.setText(S_UNASSIGNED_DECISION_IDS);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        caption.setLayoutData((Object)gd);
        new Label(this.bottomContainer, 0).setText(S_DECISION_ID_ASSIGNMENTS);
        this.decisionIDs = new ListViewer(this.bottomContainer, 2562);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 2;
        this.decisionIDs.getList().setLayoutData((Object)gd);
        this.decisionIDs.setSorter((ViewerSorter)ComparableViewerSorter.sharedInstance);
        this.decisionIDs.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AssignEdgesWizardPage.this.selectedCombinationTab.setSelection(1);
                AssignEdgesWizardPage.this.checkButtonsEnabled(true, false);
            }
        });
        this.decisionIDs.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (AssignEdgesWizardPage.this.moveRight.isEnabled()) {
                    AssignEdgesWizardPage.this.moveRight();
                }
            }
        });
        this.moveRight = new Button(this.bottomContainer, 131076);
        this.moveRight.setToolTipText(S_ASSIGN);
        gd = new GridData(4, 1024, false, true);
        gd.heightHint = 25;
        gd.widthHint = 25;
        this.moveRight.setLayoutData((Object)gd);
        this.moveRight.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AssignEdgesWizardPage.this.moveRight();
            }
        });
        this.tree = new TreeViewer(this.bottomContainer, 2818);
        this.tree.setContentProvider((IContentProvider)new EdgeTreeContentProvider(this.edgeList));
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreePath[] selPaths = ((ITreeSelection)event.getSelection()).getPaths();
                if (selPaths.length > 0 && selPaths[0].getLastSegment() instanceof EdgeAssignment) {
                    AssignEdgesWizardPage.this.selectedCombinationTab.setSelection(0);
                } else {
                    AssignEdgesWizardPage.this.selectedCombinationTab.setSelection(1);
                }
                AssignEdgesWizardPage.this.checkButtonsEnabled(true, true);
            }
        });
        this.tree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (AssignEdgesWizardPage.this.moveLeft.isEnabled()) {
                    AssignEdgesWizardPage.this.moveLeft();
                }
            }
        });
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 2;
        this.tree.getTree().setLayoutData((Object)gd);
        this.tree.setInput(this.edgeList);
        this.tree.expandAll();
        this.moveLeft = new Button(this.bottomContainer, 16388);
        this.moveLeft.setToolTipText(S_UNASSIGN);
        gd = new GridData(4, 128, false, true);
        gd.heightHint = 25;
        gd.widthHint = 25;
        this.moveLeft.setLayoutData((Object)gd);
        this.moveLeft.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AssignEdgesWizardPage.this.moveLeft();
            }
        });
        this.checkButtonsEnabled(false, false);
        Label description = new Label(this.bottomContainer, 64);
        description.setText(S_EXPLANATION);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        description.setLayoutData((Object)gd);
        this.setDescription(S_DESCRIPTION);
    }

    public void handlePageChanging(PageChangingEvent event) {
        if (this.wizardData != null) {
            this.loadAssignmentsFromWizardData();
        }
        this.loadDecisionIDList();
        this.tree.refresh();
        this.tree.expandAll();
    }

    protected void checkButtonsEnabled(boolean updateWizardButtons, boolean useTreeIDs) {
        ITreeSelection treeSel = (ITreeSelection)this.tree.getSelection();
        IStructuredSelection listSel = (IStructuredSelection)this.decisionIDs.getSelection();
        TreePath[] selPaths = treeSel.getPaths();
        boolean haveSingleAssignmentSelection = false;
        if (selPaths.length > 0) {
            HashSet<EdgeAssignment> selectedAssignments = new HashSet<EdgeAssignment>();
            int i = 0;
            while (i < selPaths.length) {
                selectedAssignments.add((EdgeAssignment)selPaths[i].getFirstSegment());
                ++i;
            }
            StringBuilder res = new StringBuilder();
            res.append(S_STATEMENT_FOR).append(" [");
            for (EdgeAssignment ea : selectedAssignments) {
                res.append(ea.getEdge().getEdgeCode()).append(", ");
            }
            res.replace(res.length() - 2, res.length(), "]:\n");
            for (EdgeAssignment ea : selectedAssignments) {
                for (DecisionStatement ds : ea.getAssociatedDecisionIDs()) {
                    res.append(ds.getDecisionStatement()).append('\n');
                }
            }
            this.selectedEdgeDisjunction.setText(res.toString());
            haveSingleAssignmentSelection = selectedAssignments.size() == 1;
        } else {
            this.selectedEdgeDisjunction.setText(NO_EDGE_SELECTED);
        }
        ArrayList<DecisionStatement> selectedIDs = new ArrayList<DecisionStatement>();
        if (useTreeIDs) {
            TreePath[] treePathArray = selPaths;
            int n = selPaths.length;
            int ea = 0;
            while (ea < n) {
                TreePath tp = treePathArray[ea];
                if (tp.getLastSegment() instanceof DecisionStatement) {
                    selectedIDs.add((DecisionStatement)tp.getLastSegment());
                }
                ++ea;
            }
        } else if (listSel.getFirstElement() != null) {
            for (DecisionStatement id : listSel) {
                selectedIDs.add(id);
            }
        }
        if (selectedIDs.size() > 0) {
            this.selectedDecisionIDDisjunction.setText(this.getDisjunctionFromDecisionIDs(selectedIDs, true));
        } else {
            this.selectedDecisionIDDisjunction.setText("(no decision ID selected)");
        }
        if (treeSel.getFirstElement() != null) {
            this.moveLeft.setEnabled(true);
            this.moveLeft.setToolTipText(S_UNASSIGN);
        } else {
            this.moveLeft.setEnabled(false);
            this.moveLeft.setToolTipText(S_PLEASE_SELECT_AN_ITEM_IN_THE_TREE);
        }
        if (haveSingleAssignmentSelection) {
            if (listSel.getFirstElement() != null) {
                this.moveRight.setEnabled(true);
                this.moveRight.setToolTipText(S_ASSIGN);
            } else {
                this.moveRight.setEnabled(false);
                this.moveRight.setToolTipText(S_PLEASE_SELECT_A_DECISION_ID_IN_THE_LIST);
            }
        } else {
            this.moveRight.setEnabled(false);
            this.moveRight.setToolTipText(treeSel.getFirstElement() == null ? S_PLEASE_SELECT_AN_ITEM_IN_THE_TREE : S_PLEASE_SELECT_ONLY_A_SINGLE_EDGE_IN_THE_TREE);
        }
        if (updateWizardButtons) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    protected void loadAssignmentsFromWizardData() {
        long id;
        int n;
        int n2;
        long[] lArray;
        long[] decisionIDs;
        DefaultEdgeAssignment edgeAssignment;
        Node successor;
        Edge edge;
        int succ;
        this.decisionIDList = this.wizardData.getDecisionStatements();
        this.edgeList.clear();
        int nodeID = this.wizardData.getNodeData().getNode().getID();
        Map idsForEdges = this.wizardData.getDecisionIDsForEdgeCode();
        int[] nArray = this.wizardData.getNodeData().getProcessTemplate().getSuccByEdgeType(nodeID, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_CONTROL});
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            succ = nArray[n4];
            edge = this.wizardData.getNodeData().getProcessTemplate().getEdge(nodeID, succ, ProcessConstants.EdgeType.ET_CONTROL);
            successor = this.wizardData.getNodeData().getProcessTemplate().getNode(succ);
            edgeAssignment = new DefaultEdgeAssignment(edge, successor);
            decisionIDs = (long[])idsForEdges.get(edge.getEdgeCode());
            if (decisionIDs != null) {
                lArray = decisionIDs;
                n2 = decisionIDs.length;
                n = 0;
                while (n < n2) {
                    id = lArray[n];
                    for (DecisionStatement ds : this.decisionIDList) {
                        if (ds.getDecisionID() != id) continue;
                        edgeAssignment.getAssociatedDecisionIDs().add(ds);
                        break;
                    }
                    ++n;
                }
            }
            this.edgeList.add((EdgeAssignment)edgeAssignment);
            ++n4;
        }
        nArray = this.wizardData.getNodeData().getProcessTemplate().getSuccByEdgeType(nodeID, new ProcessConstants.EdgeType[]{ProcessConstants.EdgeType.ET_LOOP});
        n3 = nArray.length;
        n4 = 0;
        while (n4 < n3) {
            succ = nArray[n4];
            edge = this.wizardData.getNodeData().getProcessTemplate().getEdge(nodeID, succ, ProcessConstants.EdgeType.ET_LOOP);
            successor = this.wizardData.getNodeData().getProcessTemplate().getNode(succ);
            edgeAssignment = new DefaultEdgeAssignment(edge, successor);
            decisionIDs = (long[])idsForEdges.get(edge.getEdgeCode());
            if (decisionIDs != null) {
                lArray = decisionIDs;
                n2 = decisionIDs.length;
                n = 0;
                while (n < n2) {
                    id = lArray[n];
                    for (DecisionStatement ds : this.decisionIDList) {
                        if (ds.getDecisionID() != id) continue;
                        edgeAssignment.getAssociatedDecisionIDs().add(ds);
                        break;
                    }
                    ++n;
                }
            }
            this.edgeList.add((EdgeAssignment)edgeAssignment);
            ++n4;
        }
        Collections.sort(this.edgeList, edgeAssignmentComparator);
    }

    protected String getDisjunctionFromDecisionIDs(List<DecisionStatement> decisionIDs, boolean printIDs) {
        StringBuilder s = new StringBuilder();
        if (printIDs) {
            s.append(S_STATEMENT_FOR).append(" [");
            for (DecisionStatement id : decisionIDs) {
                s.append(id);
                s.append(", ");
            }
            s.replace(s.length() - 2, s.length(), "]:\n");
        }
        for (DecisionStatement id : decisionIDs) {
            s.append(id.getDecisionStatement());
            s.append(" || ");
            s.append("\n");
        }
        if (s.length() > 0) {
            return s.substring(0, s.length() - " || ".length());
        }
        return "";
    }

    public void loadDecisionIDList() {
        this.decisionIDs.getList().removeAll();
        for (DecisionStatement id : this.decisionIDList) {
            boolean isAssigned = false;
            for (EdgeAssignment e : this.edgeList) {
                if (!e.getAssociatedDecisionIDs().contains(id)) continue;
                isAssigned = true;
                break;
            }
            if (isAssigned) continue;
            this.decisionIDs.add((Object)id);
        }
    }

    public void setDecisionStatements(Collection<DecisionStatement> statements) {
        this.decisionIDList = statements;
    }

    public IWizardPage getNextPage() {
        this.saveChanges();
        return super.getNextPage();
    }

    public void saveChanges() {
        if (this.wizardData != null) {
            this.wizardData.setDecisionIDsForEdgeCode(this.generateEdgeCodeForDecisionID());
        }
    }

    public Map<Long, long[]> generateEdgeCodeForDecisionID() {
        HashMap<Long, long[]> result = new HashMap<Long, long[]>();
        for (EdgeAssignment ea : this.edgeList) {
            long[] decisionIDs = new long[ea.getAssociatedDecisionIDs().size()];
            int i = 0;
            while (i < decisionIDs.length) {
                decisionIDs[i] = ((DecisionStatement)ea.getAssociatedDecisionIDs().get(i)).getDecisionID();
                ++i;
            }
            result.put(ea.getEdge().getEdgeCode(), decisionIDs);
        }
        return result;
    }

    public boolean isPageComplete() {
        if (this.decisionIDs == null) {
            return false;
        }
        String msg = "";
        int numEl = this.decisionIDs.getList().getItemCount();
        if (numEl != 0) {
            msg = numEl > 1 ? String.format(E_NOT_ALL_BRANCHES_ASSIGNED_PLURAL, numEl) : E_NOT_ALL_BRANCHES_ASSIGNED;
        }
        int numUnassignedEdges = 0;
        for (EdgeAssignment e : this.edgeList) {
            if (e.getAssociatedDecisionIDs().size() != 0) continue;
            ++numUnassignedEdges;
        }
        if (numUnassignedEdges != 0) {
            if (msg.length() > 0) {
                msg = String.valueOf(msg) + "\n";
            }
            if (numUnassignedEdges != 0) {
                msg = numUnassignedEdges > 1 ? String.valueOf(msg) + String.format(E_NOT_ALL_EDGES_ASSIGNED_PLURAL, numUnassignedEdges) : String.valueOf(msg) + E_NOT_ALL_EDGES_ASSIGNED;
            }
        }
        if (msg.length() > 0) {
            this.setErrorMessage(msg);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void moveRight() {
        EdgeAssignment ea = (EdgeAssignment)((ITreeSelection)this.tree.getSelection()).getPaths()[0].getFirstSegment();
        for (DecisionStatement id : (StructuredSelection)this.decisionIDs.getSelection()) {
            ea.getAssociatedDecisionIDs().add(id);
            this.decisionIDs.remove((Object)id);
        }
        this.tree.refresh((Object)ea);
        this.tree.expandAll();
        this.checkButtonsEnabled(true, true);
        this.selectedCombinationTab.setSelection(0);
    }

    protected void moveLeft() {
        TreePath[] treePathArray = ((ITreeSelection)this.tree.getSelection()).getPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            EdgeAssignment ea = (EdgeAssignment)path.getFirstSegment();
            if (path.getSegmentCount() == 2) {
                DecisionStatement id = (DecisionStatement)path.getLastSegment();
                if (ea.getAssociatedDecisionIDs().remove(id)) {
                    this.decisionIDs.add((Object)id);
                }
            } else if (path.getSegmentCount() == 1) {
                this.decisionIDs.add(ea.getAssociatedDecisionIDs().toArray());
                ea.getAssociatedDecisionIDs().clear();
            }
            ++n2;
        }
        this.tree.refresh();
        this.tree.expandAll();
        this.checkButtonsEnabled(true, false);
        this.selectedCombinationTab.setSelection(1);
    }
}

