/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.core.covercheck.CoverCheck;
import de.aristaflow.adept2.extensions.xorsupport.core.covercheck.CoverageError;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultPredicate;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Interval;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.PredicateType;
import de.aristaflow.adept2.extensions.xorsupport.ui.PredicatesWizardPage;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class CoverCheckComposite
extends Composite {
    protected Tree errorList;
    protected Button addUncovered;
    protected Button addSingleUncovered;
    protected Button buttonGoTo;
    protected Expression expression;
    protected List<CoverageError> errors;
    protected boolean errorState;
    protected PredicatesWizardPage predPage;
    protected static final String ERROR_NODEFCOVERFORVARS = "Can not add a default coverage for variables.";
    protected static final String LIST_LABEL = "Detected coverage errors:";
    protected static final String ADD_ALL_SHORT = "Add all";
    protected static final String ADD_ALL = "Add predicates for all uncovered intervals.";
    protected static final String ADD_SINGLE_SHORT = "Add";
    protected static final String ADD_SINGLE = "Add predicate for the selected uncovered interval.";
    protected static final String GOTO_SHORT = "Go to";
    protected static final String TITLE = "Cover check";
    protected static final String NO_ERRORS = "All intervals are covered - no errors found";
    protected static final String MSG_COULD_NOT_ADD_PRED = "Could not find a valid predicate to correct error \"%s\".";

    public CoverCheckComposite(Composite parent, int style, PredicatesWizardPage predPage) {
        super(parent, style);
        this.predPage = predPage;
        this.createControl();
    }

    public void createControl() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.setBackgroundMode(0);
        this.setBackground(Display.getDefault().getSystemColor(22));
        this.errorList = new Tree((Composite)this, 68356);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        this.errorList.setLayoutData((Object)gd);
        this.errorList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selection = e.item.getData();
                boolean enableAdd = false;
                boolean enableGoTo = false;
                if (selection != null) {
                    if (selection instanceof CoverageError) {
                        enableAdd = CoverCheckComposite.this.canAddPredicate((CoverageError)selection);
                    } else if (selection instanceof Predicate) {
                        enableGoTo = true;
                    }
                }
                CoverCheckComposite.this.addSingleUncovered.setEnabled(enableAdd);
                CoverCheckComposite.this.buttonGoTo.setEnabled(enableGoTo);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Object selection = e.item.getData();
                if (selection != null) {
                    CoverageError ce;
                    if (selection instanceof Predicate) {
                        CoverCheckComposite.this.predPage.focusPredicate((Predicate)selection);
                    } else if (selection instanceof CoverageError && CoverCheckComposite.this.canAddPredicate(ce = (CoverageError)selection)) {
                        CoverCheckComposite.this.addUncoveredPredicate(ce);
                    }
                }
            }
        });
        this.addUncovered = new Button((Composite)this, 8);
        this.addUncovered.setText(ADD_ALL_SHORT);
        this.addUncovered.setToolTipText(ADD_ALL);
        this.addUncovered.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addUncovered.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoverCheckComposite.this.addUncoveredPredicates();
            }
        });
        this.addSingleUncovered = new Button((Composite)this, 8);
        this.addSingleUncovered.setText(ADD_SINGLE_SHORT);
        this.addSingleUncovered.setToolTipText(ADD_SINGLE);
        this.addSingleUncovered.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.addSingleUncovered.setEnabled(false);
        this.addSingleUncovered.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selObject = CoverCheckComposite.this.errorList.getSelection()[0].getData();
                if (selObject instanceof CoverageError) {
                    CoverCheckComposite.this.addUncoveredPredicate((CoverageError)selObject);
                }
            }
        });
        this.buttonGoTo = new Button((Composite)this, 8);
        this.buttonGoTo.setText(GOTO_SHORT);
        this.buttonGoTo.setLayoutData((Object)new GridData(4, 128, false, true));
        this.buttonGoTo.setEnabled(false);
        this.buttonGoTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selObject = CoverCheckComposite.this.errorList.getSelection()[0].getData();
                if (selObject instanceof Predicate) {
                    CoverCheckComposite.this.predPage.focusPredicate((Predicate)selObject);
                }
            }
        });
    }

    protected boolean canAddPredicate(CoverageError ce) {
        switch (ce.getErrorType()) {
            case INTERVAL_NOT_COVERED: 
            case VALUE_NOT_COVERED: 
            case NULL_NOT_COVERED: 
            case VARCONSTRAINT_NOT_COVERED: {
                return true;
            }
        }
        return false;
    }

    protected boolean addUncoveredPredicate(CoverageError ce) {
        CoverableDataType type = this.expression.getDataType();
        Interval interval = ce.getAffectedInterval();
        try {
            if (type != CoverableDataType.BOOLEAN) {
                switch (ce.getErrorType()) {
                    case INTERVAL_NOT_COVERED: {
                        DefaultPredicate pred = interval.getLowerBound().getValue().equals(type.getMinValue().getValue()) && interval.isLowerBoundIncluded() ? (interval.getUpperBound().getValue().equals(type.getMaxValue().getValue()) ? new DefaultPredicate(PredicateType.ISNOT_NULL, this.expression) : (interval.isUpperBoundIncluded() ? new DefaultPredicate(PredicateType.LESS_OR_EQUAL, this.expression, interval.getUpperBound()) : new DefaultPredicate(PredicateType.LESS_THAN, this.expression, interval.getUpperBound()))) : (interval.getUpperBound().getValue().equals(type.getMaxValue().getValue()) ? (interval.isLowerBoundIncluded() ? new DefaultPredicate(PredicateType.GREATER_OR_EQUAL, this.expression, interval.getLowerBound()) : new DefaultPredicate(PredicateType.GREATER_THAN, this.expression, interval.getLowerBound())) : new DefaultPredicate(PredicateType.IN_INTERVAL, this.expression, interval.getLowerBound(), interval.getUpperBound(), interval.isLowerBoundIncluded(), interval.isUpperBoundIncluded()));
                        this.predPage.addPredicateComposite((Predicate)pred);
                        break;
                    }
                    case VALUE_NOT_COVERED: {
                        DefaultPredicate pred = new DefaultPredicate(PredicateType.EQUALS, this.expression, interval.getLowerBound());
                        this.predPage.addPredicateComposite((Predicate)pred);
                        break;
                    }
                    case NULL_NOT_COVERED: {
                        DefaultPredicate pred = new DefaultPredicate(PredicateType.IS_NULL, this.expression);
                        this.predPage.addPredicateComposite((Predicate)pred);
                        break;
                    }
                    case VARCONSTRAINT_NOT_COVERED: {
                        DefaultPredicate pred = new DefaultPredicate(PredicateType.CONSTRAINT_NOT_SATISFIED, this.expression);
                        this.predPage.addPredicateComposite((Predicate)pred);
                    }
                }
            } else {
                switch (ce.getErrorType()) {
                    case INTERVAL_NOT_COVERED: {
                        DefaultPredicate pred = new DefaultPredicate(PredicateType.IS_TRUE, this.expression);
                        this.predPage.addPredicateComposite((Predicate)pred);
                        pred = new DefaultPredicate(PredicateType.IS_FALSE, this.expression);
                        this.predPage.addPredicateComposite((Predicate)pred);
                        break;
                    }
                    case VALUE_NOT_COVERED: {
                        DefaultPredicate pred = interval.getLowerBound().equals(CoverableDataType.BOOLEAN.FALSE) ? new DefaultPredicate(PredicateType.IS_FALSE, this.expression) : new DefaultPredicate(PredicateType.IS_TRUE, this.expression);
                        this.predPage.addPredicateComposite((Predicate)pred);
                        break;
                    }
                    case NULL_NOT_COVERED: {
                        DefaultPredicate pred = new DefaultPredicate(PredicateType.IS_NULL, this.expression);
                        this.predPage.addPredicateComposite((Predicate)pred);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)String.format(MSG_COULD_NOT_ADD_PRED, ce));
        }
        return false;
    }

    protected void addUncoveredPredicates() {
        for (CoverageError ce : this.errors) {
            if (!this.addUncoveredPredicate(ce)) continue;
            this.checkErrors();
            this.addUncoveredPredicates();
            return;
        }
        this.checkErrors();
    }

    public void clearErrors() {
        this.errorList.removeAll();
        this.predPage.unmarkAllPredicates();
        this.addUncovered.setEnabled(false);
        this.addSingleUncovered.setEnabled(false);
        this.buttonGoTo.setEnabled(false);
        this.predPage.errorStatusChanged(false);
    }

    public boolean checkErrors() {
        boolean haveUncovered = false;
        this.errorList.removeAll();
        this.predPage.unmarkAllPredicates();
        this.errors = CoverCheck.checkCoverage((Expression)this.expression);
        if (this.errors.size() > 0) {
            this.errorList.setForeground(Display.getDefault().getSystemColor(3));
            this.errorState = true;
            block4: for (CoverageError ce : this.errors) {
                TreeItem errorItem = new TreeItem(this.errorList, 0);
                errorItem.setData((Object)ce);
                errorItem.setText(ce.toString());
                switch (ce.getErrorType()) {
                    case INTERVAL_COVERED_TWICE: 
                    case VALUE_COVERED_TWICE: 
                    case NULL_COVERED_TWICE: 
                    case VARCONSTRAINT_COVERED_TWICE: 
                    case VARCONSTRAINT_NOT_NECESSARY: {
                        String errMsg = ce.toString();
                        Predicate[] predicateArray = ce.getAffectedPredicates();
                        int n = predicateArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Predicate p = predicateArray[n2];
                            this.predPage.markPredicateAsError(p, errMsg);
                            TreeItem predItem = new TreeItem(errorItem, 0);
                            predItem.setData((Object)p);
                            predItem.setText(p.toString());
                            ++n2;
                        }
                        continue block4;
                    }
                    case INTERVAL_NOT_COVERED: 
                    case VALUE_NOT_COVERED: 
                    case NULL_NOT_COVERED: 
                    case VARCONSTRAINT_NOT_COVERED: {
                        haveUncovered = true;
                    }
                }
            }
        } else {
            this.errorList.setForeground(Display.getDefault().getSystemColor(6));
            TreeItem errorItem = new TreeItem(this.errorList, 0);
            errorItem.setText(NO_ERRORS);
            this.errorState = false;
        }
        this.addUncovered.setEnabled(haveUncovered);
        this.addSingleUncovered.setEnabled(false);
        this.buttonGoTo.setEnabled(false);
        this.predPage.errorStatusChanged(this.errorState);
        return this.errorState;
    }

    public boolean hasErrors() {
        return this.errorState;
    }

    public int getNumberOfErrors() {
        return this.errors == null ? 0 : this.errors.size();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
        this.checkErrors();
    }
}

