/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.EdgeAssignment;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class EdgeTreeContentProvider
implements ITreeContentProvider {
    protected List<EdgeAssignment> edges;

    public EdgeTreeContentProvider(List<EdgeAssignment> edges) {
        this.edges = edges;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof List) {
            return ((List)parentElement).toArray();
        }
        if (parentElement instanceof EdgeAssignment) {
            Object[] decisionIDs = ((EdgeAssignment)parentElement).getAssociatedDecisionIDs().toArray();
            Arrays.sort(decisionIDs);
            return decisionIDs;
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof EdgeAssignment) {
            return this.edges;
        }
        if (element instanceof DecisionStatement) {
            for (EdgeAssignment ea : this.edges) {
                if (!ea.getAssociatedDecisionIDs().contains(element)) continue;
                return ea;
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof List) {
            return ((List)element).size() > 0;
        }
        if (element instanceof EdgeAssignment) {
            return ((EdgeAssignment)element).getAssociatedDecisionIDs().size() > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

