/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.ui.ErrorMessage;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.eclipse.jface.wizard.WizardPage;

public class ErrorMessageList {
    protected final PriorityQueue<ErrorMessage> errorList = new PriorityQueue();
    protected WizardPage wizardPage;

    public ErrorMessage getMostSevere() {
        return this.errorList.peek();
    }

    public void add(ErrorMessage msg) {
        this.errorList.add(msg);
        this.updateWizardPage();
    }

    public ErrorMessage addError(Object owner, String message, int severity) {
        ErrorMessage rv = new ErrorMessage(owner, message, severity);
        this.add(rv);
        return rv;
    }

    public void remove(ErrorMessage msg) {
        this.errorList.remove(msg);
        this.updateWizardPage();
    }

    public void removeForOwner(Object owner) {
        Iterator<ErrorMessage> it = this.errorList.iterator();
        while (it.hasNext()) {
            ErrorMessage em = it.next();
            if (em.owner != owner) continue;
            it.remove();
        }
        this.updateWizardPage();
    }

    public void updateWizardPage() {
        ErrorMessage em = this.getMostSevere();
        if (em == null) {
            this.wizardPage.setErrorMessage(null);
        } else {
            this.wizardPage.setErrorMessage(em.message);
        }
    }

    public ErrorMessageList(WizardPage client) {
        this.wizardPage = client;
    }
}

