/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.core.parser.Parser;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.ParserException;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.SubExpression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.VariableManager;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.ExpressionType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.PredicateType;
import de.aristaflow.adept2.extensions.xorsupport.ui.LeftHandSideWizardPage;
import de.aristaflow.adept2.extensions.xorsupport.ui.SquigglyStyledText;
import java.util.HashSet;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;

public class ExpressionComposite
extends Composite {
    protected static final String WARNING_DELETE_PREDICATES = "All current predicates will be deleted. Do you wish to continue?";
    protected static final String STRING_DIMENSION = "Dimension %s";
    protected static final String STRING_CONFIRM = "Confirm";
    protected static final String ERROR_EMPTY_EXPRESSION = "Empty expressions are not allowed";
    protected static final String ERROR_FULLY_CONSTANT_EXPRESSION = "Expressions must contain at least one variable!";
    protected IWizard wizard;
    protected LeftHandSideWizardPage parentPage;
    protected Label dimensionLabel;
    protected SquigglyStyledText expressionText;
    protected ComboViewer comboExpressionType;
    protected Button deleteExpression;
    protected Expression expression;
    protected String errorMessage;
    protected boolean isAutomaticUpdate = false;
    protected String lastExpressionText = null;

    public ExpressionComposite(IWizard wizard, LeftHandSideWizardPage parent, Composite parentContainer, Expression ex, int dimNumber) {
        super(parentContainer, 0);
        this.wizard = wizard;
        this.parentPage = parent;
        this.expression = ex;
        this.setLayout((Layout)this.createMarginLessGridLayout(4));
        this.dimensionLabel = new Label((Composite)this, 0);
        this.setDimensionNumber(dimNumber);
        this.expressionText = new SquigglyStyledText(this, 2052);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.expressionText.setLayoutData(gd);
        this.expressionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ExpressionComposite.this.wizard.getContainer().getCurrentPage() != null) {
                    ExpressionComposite.this.wizard.getContainer().updateButtons();
                }
            }
        });
        this.expressionText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ExpressionComposite.this.parentPage.setActiveExpressionText(ExpressionComposite.this.expressionText);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.expressionText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.detail = 16;
                }
            }
        });
        this.expressionText.setFocus();
        this.comboExpressionType = new ComboViewer((Composite)this, 8);
        this.updateCombo(this.expression.getDataType());
        this.expressionToComboSelection();
        this.comboExpressionType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ExpressionComposite.this.isAutomaticUpdate || ExpressionComposite.this.expression.getPredicates().size() == 0 || ExpressionComposite.this.showWarning()) {
                    if (!ExpressionComposite.this.isAutomaticUpdate) {
                        ExpressionComposite.this.expression.getPredicates().clear();
                    }
                    ExpressionComposite.this.expression.setType((ExpressionType)ExpressionComposite.this.comboExpressionType.getElementAt(ExpressionComposite.this.comboExpressionType.getCombo().getSelectionIndex()));
                    if (!ExpressionComposite.this.isAutomaticUpdate) {
                        ExpressionComposite.this.wizard.getContainer().updateButtons();
                    }
                } else {
                    ExpressionComposite.this.expressionToComboSelection();
                }
            }
        });
        this.deleteExpression = new Button((Composite)this, 0);
        this.deleteExpression.setText("Delete");
        this.deleteExpression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExpressionComposite.this.expression.getPredicates().size() != 0 && !ExpressionComposite.this.showWarning()) {
                    return;
                }
                if (ExpressionComposite.this.parentPage.getActiveExpressionText() == ExpressionComposite.this.expressionText) {
                    ExpressionComposite.this.parentPage.setActiveExpressionText(null);
                }
                ExpressionComposite.this.parentPage.deleteExpression(ExpressionComposite.this);
            }
        });
        if (ex.getLeftHandSide() != null) {
            this.lastExpressionText = ex.getLeftHandSide().toString();
            this.expressionText.setText(this.lastExpressionText);
        }
    }

    protected GridLayout createMarginLessGridLayout(int numColumns) {
        GridLayout gl = new GridLayout(numColumns, false);
        gl.marginBottom = 0;
        gl.marginHeight = 0;
        gl.marginTop = 0;
        return gl;
    }

    protected boolean showWarning() {
        if (this.expression.getPredicates().size() == 1 && ((Predicate)this.expression.getPredicates().get(0)).getType() == PredicateType.IS_NULL) {
            return true;
        }
        MessageBox mb = new MessageBox(this.getShell(), 196);
        mb.setText(STRING_CONFIRM);
        mb.setMessage(WARNING_DELETE_PREDICATES);
        return mb.open() == 64;
    }

    protected void updateCombo(CoverableDataType type) {
        int oldIdx = this.comboExpressionType.getCombo().getSelectionIndex();
        this.comboExpressionType.getCombo().removeAll();
        if (type == null || type.getSupportedExpressionTypes().contains(ExpressionType.VAR_COMP_CONST)) {
            this.comboExpressionType.add((Object)ExpressionType.VAR_COMP_CONST);
        }
        if (type == null || type.getSupportedExpressionTypes().contains(ExpressionType.VAR_COMP_VAR)) {
            this.comboExpressionType.add((Object)ExpressionType.VAR_COMP_VAR);
        }
        if (oldIdx < this.comboExpressionType.getCombo().getItemCount()) {
            this.comboExpressionType.getCombo().select(oldIdx);
        } else {
            this.comboExpressionType.getCombo().select(0);
        }
    }

    protected void expressionToComboSelection() {
        this.isAutomaticUpdate = true;
        if (this.expression.getDataType() == null || this.expression.getType() == ExpressionType.VAR_COMP_CONST) {
            this.comboExpressionType.setSelection((ISelection)new StructuredSelection((Object)ExpressionType.VAR_COMP_CONST));
        } else {
            this.comboExpressionType.setSelection((ISelection)new StructuredSelection((Object)ExpressionType.VAR_COMP_VAR));
        }
        this.isAutomaticUpdate = false;
    }

    public void setDimensionNumber(int dimNumber) {
        this.dimensionLabel.setText(String.format(STRING_DIMENSION, dimNumber));
    }

    public boolean checkExpression() {
        SubExpression newLHS;
        block14: {
            String exprStr;
            this.errorMessage = null;
            this.expressionText.getSquiggleList().clear();
            this.lastExpressionText = exprStr = this.expressionText.getText();
            if (exprStr.equals("")) {
                this.errorMessage = ERROR_EMPTY_EXPRESSION;
                return false;
            }
            newLHS = Parser.parse((String)exprStr, (VariableManager)this.expression.getTreeManager().getVariables());
            HashSet usedVars = new HashSet();
            newLHS.determineUsedVariables(usedVars);
            if (usedVars.size() != 0) break block14;
            this.expressionText.addSquiggleRange(0, exprStr.length(), ERROR_FULLY_CONSTANT_EXPRESSION);
            this.errorMessage = ERROR_FULLY_CONSTANT_EXPRESSION;
            return false;
        }
        try {
            if (this.expression.getDataType() != null && !this.expression.getDataType().isDataTypeCompatible(newLHS.getDataType())) {
                if (this.expression.getPredicates().size() == 0 || this.showWarning()) {
                    this.expression.getPredicates().clear();
                    this.updateCombo((CoverableDataType)newLHS.getDataType());
                    this.expression.setLeftHandSide(newLHS);
                    this.expressionToComboSelection();
                } else {
                    this.lastExpressionText = this.expression.getLeftHandSide().toString();
                    this.expressionText.setText(this.lastExpressionText);
                }
            } else {
                if ((this.expression.getLeftHandSide() == null || this.expression.getLeftHandSide().canBeNull()) && !newLHS.canBeNull()) {
                    ListIterator predListIt = this.expression.getPredicates().listIterator();
                    while (predListIt.hasNext()) {
                        Predicate pred = (Predicate)predListIt.next();
                        switch (pred.getType()) {
                            case IS_NULL: 
                            case ISNOT_NULL: {
                                predListIt.remove();
                            }
                        }
                    }
                }
                this.updateCombo((CoverableDataType)newLHS.getDataType());
                this.expression.setLeftHandSide(newLHS);
                this.expressionToComboSelection();
            }
            return true;
        }
        catch (ParserException ex) {
            if (ex.getStartPosition() != ex.getEndPosition()) {
                this.expressionText.addSquiggleRange(ex.getStartPosition(), ex.getEndPosition() - ex.getStartPosition() - 1, ex.getMessage());
            }
            this.errorMessage = ex.getMessage();
            return false;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void refreshExpressionText() {
        this.lastExpressionText = this.expression.getLeftHandSide().toString();
        this.expressionText.setText(this.lastExpressionText);
    }
}

