/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class ExpressionOrderWindow {
    protected static final String S_CANCEL = "Cancel";
    protected static final String S_OK = "OK";
    protected static final String S_REORDER_DIMENSIONS = "Reorder dimensions";
    protected Shell window;
    protected List expressionList;
    protected Composite rightSide;
    protected Button moveUpButton;
    protected Button moveDownButton;
    protected Composite buttonPanel;
    protected Button applyButton;
    protected Button cancelButton;
    protected BranchTreeManager treeManager;
    protected int[] permutation;

    public ExpressionOrderWindow(Shell parent, BranchTreeManager treeManager) {
        this.treeManager = treeManager;
        this.permutation = new int[treeManager.getExpressionList().size()];
        int i = 0;
        while (i < this.permutation.length) {
            this.permutation[i] = i;
            ++i;
        }
        this.window = new Shell(parent, 2144);
        this.window.setText(S_REORDER_DIMENSIONS);
        this.window.setLayout((Layout)new GridLayout(2, false));
        this.expressionList = new List((Composite)this.window, 2560);
        for (Expression ex : treeManager.getExpressionList()) {
            this.expressionList.add(ex.getLeftHandSide().toString());
        }
        this.expressionList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ExpressionOrderWindow.this.updateButtons();
            }
        });
        GridData gd = new GridData();
        gd.widthHint = 200;
        gd.heightHint = 200;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.expressionList.setLayoutData((Object)gd);
        this.rightSide = new Composite((Composite)this.window, 0);
        this.rightSide.setLayout((Layout)new GridLayout(1, false));
        this.moveUpButton = new Button(this.rightSide, 132);
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int idx = ExpressionOrderWindow.this.expressionList.getSelectionIndex();
                String tmpS = ExpressionOrderWindow.this.expressionList.getItem(idx);
                ExpressionOrderWindow.this.expressionList.setItem(idx, ExpressionOrderWindow.this.expressionList.getItem(idx - 1));
                ExpressionOrderWindow.this.expressionList.setItem(idx - 1, tmpS);
                ExpressionOrderWindow.this.expressionList.select(idx - 1);
                int tmpI = ExpressionOrderWindow.this.permutation[idx];
                ExpressionOrderWindow.this.permutation[idx] = ExpressionOrderWindow.this.permutation[idx - 1];
                ExpressionOrderWindow.this.permutation[idx - 1] = tmpI;
                ExpressionOrderWindow.this.updateButtons();
            }
        });
        this.moveDownButton = new Button(this.rightSide, 1028);
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int idx = ExpressionOrderWindow.this.expressionList.getSelectionIndex();
                String tmpS = ExpressionOrderWindow.this.expressionList.getItem(idx);
                ExpressionOrderWindow.this.expressionList.setItem(idx, ExpressionOrderWindow.this.expressionList.getItem(idx + 1));
                ExpressionOrderWindow.this.expressionList.setItem(idx + 1, tmpS);
                ExpressionOrderWindow.this.expressionList.select(idx + 1);
                int tmpI = ExpressionOrderWindow.this.permutation[idx];
                ExpressionOrderWindow.this.permutation[idx] = ExpressionOrderWindow.this.permutation[idx + 1];
                ExpressionOrderWindow.this.permutation[idx + 1] = tmpI;
                ExpressionOrderWindow.this.updateButtons();
            }
        });
        this.buttonPanel = new Composite((Composite)this.window, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.buttonPanel.setLayoutData((Object)gd);
        this.buttonPanel.setLayout((Layout)new RowLayout());
        this.applyButton = new Button(this.buttonPanel, 8);
        this.applyButton.setText(S_OK);
        this.applyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ExpressionOrderWindow.this.treeManager.swapExpressions(ExpressionOrderWindow.this.permutation);
                ExpressionOrderWindow.this.window.setVisible(false);
                ExpressionOrderWindow.this.window.dispose();
            }
        });
        this.cancelButton = new Button(this.buttonPanel, 8);
        this.cancelButton.setText(S_CANCEL);
        this.cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ExpressionOrderWindow.this.window.setVisible(false);
                ExpressionOrderWindow.this.window.dispose();
            }
        });
        this.window.setSize(this.window.computeSize(-1, -1));
        this.window.setVisible(true);
    }

    protected void updateButtons() {
        int idx = this.expressionList.getSelectionIndex();
        this.moveDownButton.setEnabled(idx >= 0 && idx < this.permutation.length - 1);
        this.moveUpButton.setEnabled(idx > 0);
    }
}

