/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultExpression;
import de.aristaflow.adept2.extensions.xorsupport.core.parser.Parser;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.ExpressionType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.FunctionSignature;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.OperatorType;
import de.aristaflow.adept2.extensions.xorsupport.ui.ExpressionComposite;
import de.aristaflow.adept2.extensions.xorsupport.ui.SquigglyStyledText;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class LeftHandSideWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "de.aristaflow.rules.XOR#dimensions";
    protected static final String STRING_DIMENSION_EXPRESSION = "Left-hand side expressions for dimensions";
    protected static final String STRING_COMPARE_EXPRESSION_TO = "Compare expression to";
    protected static final String STRING_ADD_EXPRESSION = "Add dimension";
    protected static final String TITLE = "Dimensions";
    protected static final String STRING_FUNCTIONS = "Functions";
    protected static final String STRING_OPERATORS = "Operators";
    protected static final String STRING_VARIABLES = "Variables";
    protected static final String STRING_DOUBLECLICK_LISTS = "Double-click on the lists to insert the selection into the currently selected expression.";
    protected static final String STRING_DESCRIPTION = "Please specify the dimensions you want to use here and enter expressions that will evaluate the dimensions' values at run time.";
    private Composite expressionListComposite;
    private Button addExpression;
    private ListViewer variableList;
    private ListViewer operatorList;
    private ListViewer functionList;
    private SquigglyStyledText activeExpressionText = null;
    private BranchTreeManager treeManager;
    private int expressionCounter = 0;

    public LeftHandSideWizardPage(BranchTreeManager treeManager) {
        super(PAGE_NAME, TITLE, null);
        this.treeManager = treeManager;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label exprLabel = new Label(container, 0);
        exprLabel.setText(STRING_DIMENSION_EXPRESSION);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        exprLabel.setLayoutData((Object)gd);
        Label compareLabel = new Label(container, 0);
        compareLabel.setText(STRING_COMPARE_EXPRESSION_TO);
        compareLabel.setAlignment(131072);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        compareLabel.setLayoutData((Object)gd);
        ScrolledComposite sc = new ScrolledComposite(container, 2560);
        sc.setExpandHorizontal(true);
        this.expressionListComposite = new Composite((Composite)sc, 0);
        this.expressionListComposite.setLayout((Layout)new FillLayout(512));
        sc.setContent((Control)this.expressionListComposite);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.heightHint = 300;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        sc.setLayoutData((Object)gd);
        this.expressionListComposite.setSize(this.expressionListComposite.computeSize(-1, -1));
        this.addExpression = new Button(container, 0);
        this.addExpression.setText(STRING_ADD_EXPRESSION);
        this.addExpression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LeftHandSideWizardPage.this.addExpression();
                LeftHandSideWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        new Label(container, 0).setLayoutData((Object)gd);
        new Label(container, 0).setText(STRING_VARIABLES);
        new Label(container, 0).setText(STRING_OPERATORS);
        new Label(container, 0).setText(STRING_FUNCTIONS);
        this.variableList = new ListViewer(container, 2568);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 100;
        gd.grabExcessVerticalSpace = true;
        this.variableList.getList().setLayoutData((Object)gd);
        this.variableList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((String)e1).toLowerCase().compareTo(((String)e2).toLowerCase());
            }
        });
        this.variableList.add(this.treeManager.getVariables().getKnownVariables().keySet().toArray());
        IDoubleClickListener addText = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (LeftHandSideWizardPage.this.activeExpressionText != null && !LeftHandSideWizardPage.this.activeExpressionText.isDisposed()) {
                    ListViewer v = (ListViewer)event.getSource();
                    String text = LeftHandSideWizardPage.this.activeExpressionText.getText();
                    text = String.valueOf(text.substring(0, ((LeftHandSideWizardPage)LeftHandSideWizardPage.this).activeExpressionText.getSelection().x)) + v.getElementAt(v.getList().getSelectionIndex()) + text.substring(((LeftHandSideWizardPage)LeftHandSideWizardPage.this).activeExpressionText.getSelection().y);
                    LeftHandSideWizardPage.this.activeExpressionText.setText(text);
                }
            }
        };
        this.variableList.addDoubleClickListener(addText);
        this.operatorList = new ListViewer(container, 2568);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 100;
        gd.grabExcessVerticalSpace = true;
        this.operatorList.getList().setLayoutData((Object)gd);
        this.operatorList.add((Object[])OperatorType.values());
        this.operatorList.addDoubleClickListener(addText);
        this.functionList = new ListViewer(container, 2568);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 100;
        gd.grabExcessVerticalSpace = true;
        this.functionList.getList().setLayoutData((Object)gd);
        this.functionList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((FunctionSignature)e1).getExternalName().toLowerCase().compareTo(((FunctionSignature)e2).getExternalName().toLowerCase());
            }
        });
        for (List l : Parser.knownFunctions.values()) {
            this.functionList.add(l.toArray());
        }
        this.functionList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (LeftHandSideWizardPage.this.activeExpressionText != null) {
                    ListViewer v = (ListViewer)event.getSource();
                    String text = LeftHandSideWizardPage.this.activeExpressionText.getText();
                    text = String.valueOf(text.substring(0, ((LeftHandSideWizardPage)LeftHandSideWizardPage.this).activeExpressionText.getSelection().x)) + ((FunctionSignature)v.getElementAt(v.getList().getSelectionIndex())).getEmptyTemplate() + text.substring(((LeftHandSideWizardPage)LeftHandSideWizardPage.this).activeExpressionText.getSelection().y);
                    LeftHandSideWizardPage.this.activeExpressionText.setText(text);
                }
            }
        });
        Label addDoubleClickLabel = new Label(container, 0);
        addDoubleClickLabel.setText(STRING_DOUBLECLICK_LISTS);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        addDoubleClickLabel.setLayoutData((Object)gd);
        this.reloadExpressionList(false);
        this.setControl((Control)container);
        this.setDescription(STRING_DESCRIPTION);
        container.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                LeftHandSideWizardPage.this.reloadVariableList();
                LeftHandSideWizardPage.this.reloadExpressionList(false);
            }
        });
    }

    public void reloadVariableList() {
        this.variableList.getList().removeAll();
        this.variableList.add(this.treeManager.getVariables().getKnownVariables().keySet().toArray());
    }

    public void reloadExpressionList(boolean textRefreshOnly) {
        if (textRefreshOnly) {
            Control[] controlArray = this.expressionListComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control ec = controlArray[n2];
                ((ExpressionComposite)ec).refreshExpressionText();
                ++n2;
            }
        } else {
            this.expressionCounter = 0;
            Control[] controlArray = this.expressionListComposite.getChildren();
            int n = controlArray.length;
            int n3 = 0;
            while (n3 < n) {
                Control ec = controlArray[n3];
                if (ec instanceof ExpressionComposite) {
                    ec.dispose();
                }
                ++n3;
            }
            if (this.treeManager.getExpressionList().size() == 0) {
                this.addExpression();
            } else {
                for (Expression ex : this.treeManager.getExpressionList()) {
                    new ExpressionComposite(this.getWizard(), this, this.expressionListComposite, ex, ++this.expressionCounter);
                    this.expressionListComposite.setSize(this.expressionListComposite.computeSize(-1, -1));
                    this.expressionListComposite.layout(true);
                }
            }
        }
    }

    public void addExpression() {
        DefaultExpression ex = new DefaultExpression(ExpressionType.VAR_COMP_CONST, null, this.treeManager);
        this.treeManager.getExpressionList().add(ex);
        new ExpressionComposite(this.getWizard(), this, this.expressionListComposite, (Expression)ex, ++this.expressionCounter);
        this.expressionListComposite.setSize(this.expressionListComposite.computeSize(-1, -1));
        this.expressionListComposite.layout(true);
    }

    public void deleteExpression(ExpressionComposite ex) {
        this.treeManager.getExpressionList().remove(ex.expression);
        ex.dispose();
        this.expressionCounter = 0;
        Control[] controlArray = this.expressionListComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            ((ExpressionComposite)c).setDimensionNumber(++this.expressionCounter);
            ++n2;
        }
        this.expressionListComposite.setSize(this.expressionListComposite.computeSize(-1, -1));
        this.expressionListComposite.layout(true);
        this.getWizard().getContainer().updateButtons();
    }

    public boolean checkExpressions() {
        this.setErrorMessage(null);
        if (this.treeManager.getExpressionList().size() == 0) {
            return false;
        }
        StringBuilder error = new StringBuilder();
        boolean res = true;
        int counter = 1;
        Control[] controlArray = this.expressionListComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            ExpressionComposite ec = (ExpressionComposite)c;
            if (counter == this.expressionListComposite.getChildren().length && (ec.expressionText.getText() == null || ec.expressionText.getText().equals(""))) {
                ec.setFocus();
            }
            boolean singleRes = ec.checkExpression();
            res &= singleRes;
            if (!singleRes) {
                error.append(ec.getErrorMessage());
                error.append("\n");
            }
            ++counter;
            ++n2;
        }
        if (!res) {
            this.setErrorMessage(error.toString());
        }
        return res;
    }

    public boolean canFlipToNextPage() {
        return this.checkExpressions();
    }

    public void setActiveExpressionText(SquigglyStyledText activeExpressionText) {
        this.activeExpressionText = activeExpressionText;
    }

    public SquigglyStyledText getActiveExpressionText() {
        return this.activeExpressionText;
    }
}

