/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.AtomicElement;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Constant;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Interval;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.NumberDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.PredicateType;
import de.aristaflow.adept2.extensions.xorsupport.ui.ComparableViewerSorter;
import de.aristaflow.adept2.extensions.xorsupport.ui.PredicateTable;
import de.aristaflow.adept2.extensions.xorsupport.ui.SquigglyStyledText;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PredicateComposite
extends Composite {
    protected Composite parentContainer;
    protected ComboViewer operator;
    protected ComboViewer[] varCombos = new ComboViewer[2];
    protected SquigglyStyledText[] constTexts = new SquigglyStyledText[2];
    protected Combo comboLowerBound;
    protected Combo comboUpperBound;
    protected Label boundsSeparatorLabel;
    protected Label expressionLabel;
    protected Expression expression;
    protected Predicate predicate;
    protected PredicateTable parentTbl;
    protected boolean noSelectionEvent = false;
    protected static final ViewerComparator variableComparator = new ViewerComparator();
    protected final VerifyKeyListener verifyListener = new VerifyKeyListener(){

        public void verifyKey(VerifyEvent e) {
            e.doit = e.character == '\u0000' || e.character == '\b' || e.character == '\u007f' || PredicateComposite.this.expression.getDataType().isCharacterAllowed(e.character);
        }
    };
    protected final ModifyListener updateModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (!PredicateComposite.this.noSelectionEvent) {
                PredicateComposite.this.updatePredicate(true);
            }
        }
    };
    protected final SelectionListener updateSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (!PredicateComposite.this.noSelectionEvent) {
                PredicateComposite.this.updatePredicate(true);
            }
        }
    };
    protected static final String ERROR_INVALID_VALUE = "Invalid value entered";
    protected static final String ERROR_INVALID_BOUNDS = "The interval's lower bound is greater than the upper bound";
    protected static final String ERROR_INVERSE_BOUNDS = "The interval's upper bound is larger than the lower bound";
    protected static final String ERROR_NULL_INTERVAL = "This interval is empty";
    protected static final String EXCLUSIVE = "Exclusive";
    protected static final String DELETE = "Delete";

    public PredicateComposite(Composite parent, PredicateTable predTable) {
        super(parent, 0);
        this.parentContainer = parent;
        this.parentTbl = predTable;
        this.setLayout((Layout)this.createMarginLessGridLayout(2));
        this.expressionLabel = new Label((Composite)this, 0);
        this.operator = new ComboViewer((Composite)this, 8);
        this.operator.setSorter((ViewerSorter)ComparableViewerSorter.sharedInstance);
        this.operator.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (PredicateComposite.this.noSelectionEvent) {
                    return;
                }
                PredicateComposite.this.predicateChanged(true);
            }
        });
        this.createWidgets();
        this.createEmptyLayout();
    }

    public void setPredicate(Predicate pred) {
        this.noSelectionEvent = true;
        this.predicate = pred;
        this.operator.setSelection((ISelection)new StructuredSelection((Object)this.predicate.getType()));
        this.predicateChanged(false);
        this.noSelectionEvent = false;
    }

    public void setBackground(Color color) {
        this.boundsSeparatorLabel.setBackground(color);
        this.expressionLabel.setBackground(color);
        super.setBackground(color);
    }

    public void setForeground(Color color) {
        this.boundsSeparatorLabel.setForeground(color);
        this.expressionLabel.setForeground(color);
        super.setForeground(color);
    }

    public void setExpression(Expression expr) {
        this.noSelectionEvent = true;
        this.expression = expr;
        this.expressionLabel.setText(expr.getLeftHandSide().toString());
        Map m = this.expression.getDataType().getSupportedPredicateMap();
        Set supportedPredicates = (Set)m.get(this.expression.getType());
        boolean exprCanBeNull = this.expression.getLeftHandSide().canBeNull();
        this.operator.getCombo().removeAll();
        if (expr.getType().isConstantComparison()) {
            for (PredicateType pType : supportedPredicates) {
                if (!exprCanBeNull && (pType == PredicateType.IS_NULL || pType == PredicateType.ISNOT_NULL)) continue;
                this.operator.add((Object)pType);
            }
        } else {
            int numVars = this.loadVariableList(this.varCombos[0]);
            this.loadVariableList(this.varCombos[1]);
            for (PredicateType pType : supportedPredicates) {
                if (pType.getNumberOfConstants() > numVars || numVars < 2 && pType == PredicateType.CONSTRAINT_NOT_SATISFIED || !exprCanBeNull && (pType == PredicateType.IS_NULL || pType == PredicateType.ISNOT_NULL)) continue;
                this.operator.add((Object)pType);
            }
        }
        this.noSelectionEvent = false;
    }

    protected GridLayout createMarginLessGridLayout(int numColumns) {
        GridLayout gl = new GridLayout(numColumns, false);
        gl.marginBottom = 0;
        gl.marginHeight = 0;
        gl.marginTop = 0;
        return gl;
    }

    protected void createWidgets() {
        this.comboLowerBound = new Combo((Composite)this, 8);
        this.comboLowerBound.add("(");
        this.comboLowerBound.add("[");
        this.comboLowerBound.addSelectionListener(this.updateSelectionListener);
        ComboViewer cv = new ComboViewer((Composite)this, 8);
        cv.setComparator(variableComparator);
        cv.getCombo().addSelectionListener(this.updateSelectionListener);
        this.varCombos[0] = cv;
        SquigglyStyledText sst = new SquigglyStyledText(this, 2052);
        sst.addVerifyKeyListener(this.verifyListener);
        sst.addModifyListener(this.updateModifyListener);
        this.constTexts[0] = sst;
        this.boundsSeparatorLabel = new Label((Composite)this, 0);
        this.boundsSeparatorLabel.setText(" , ");
        cv = new ComboViewer((Composite)this, 8);
        cv.setComparator(variableComparator);
        cv.getCombo().addSelectionListener(this.updateSelectionListener);
        this.varCombos[1] = cv;
        sst = new SquigglyStyledText(this, 2052);
        sst.addVerifyKeyListener(this.verifyListener);
        sst.addModifyListener(this.updateModifyListener);
        this.constTexts[1] = sst;
        this.comboUpperBound = new Combo((Composite)this, 8);
        this.comboUpperBound.add(")");
        this.comboUpperBound.add("]");
        this.comboUpperBound.addSelectionListener(this.updateSelectionListener);
    }

    protected int loadVariableList(ComboViewer cv) {
        CoverableDataType dataType = this.expression.getDataType();
        Set lhsVars = this.expression.getLHSVariables();
        cv.getCombo().removeAll();
        int numVars = 0;
        for (Variable v : this.expression.getTreeManager().getVariables().getKnownVariables().values()) {
            if (lhsVars.contains(v) || !v.getDataType().isDataTypeCompatible((DataType)dataType)) continue;
            cv.add((Object)v);
            ++numVars;
        }
        return numVars;
    }

    protected Control createEntryWidget(int index, AtomicElement value) {
        if (!this.expression.getType().isConstantComparison()) {
            ComboViewer cv = this.varCombos[index];
            cv.getCombo().setVisible(true);
            if (value == null) {
                cv.getCombo().select(0);
            } else {
                cv.setSelection((ISelection)new StructuredSelection((Object)value));
            }
            return cv.getCombo();
        }
        SquigglyStyledText sst = this.constTexts[index];
        sst.setVisible(true);
        sst.getSquiggleList().clear();
        if (value != null) {
            sst.setText(value.toString());
        } else {
            sst.setText(this.expression.getDataType().getDefaultValue().toString());
        }
        if (this.expression.getDataType() instanceof NumberDataType) {
            sst.setAlignment(131072);
        } else {
            sst.setAlignment(16384);
        }
        return sst;
    }

    protected void createIntervalLayout(AtomicElement lowerBound, AtomicElement upperBound) {
        this.setLayout((Layout)this.createMarginLessGridLayout(7));
        this.clearData();
        this.comboLowerBound.setLayoutData((Object)new GridData());
        this.comboLowerBound.setVisible(true);
        if (this.predicate.isLowerBoundIncluded()) {
            this.comboLowerBound.select(1);
        } else {
            this.comboLowerBound.select(0);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Control c1 = this.createEntryWidget(0, lowerBound);
        c1.setLayoutData((Object)gd);
        this.boundsSeparatorLabel.setVisible(true);
        this.boundsSeparatorLabel.setLayoutData((Object)new GridData());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Control c2 = this.createEntryWidget(1, upperBound);
        c2.setLayoutData((Object)gd);
        this.comboUpperBound.setLayoutData((Object)new GridData());
        this.comboUpperBound.setVisible(true);
        if (this.predicate.isUpperBoundIncluded()) {
            this.comboUpperBound.select(1);
        } else {
            this.comboUpperBound.select(0);
        }
    }

    protected void createSingleValueLayout(AtomicElement value) {
        this.setLayout((Layout)this.createMarginLessGridLayout(3));
        this.clearData();
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Control c = this.createEntryWidget(0, value);
        c.setLayoutData((Object)gd);
    }

    protected void createEmptyLayout() {
        this.setLayout((Layout)this.createMarginLessGridLayout(3));
        this.clearData();
        this.boundsSeparatorLabel.setLayoutData((Object)new GridData());
    }

    protected void clearData() {
        this.hideControl((Control)this.comboLowerBound);
        this.hideControl((Control)this.comboUpperBound);
        this.hideControl((Control)this.boundsSeparatorLabel);
        this.hideControl((Control)this.varCombos[0].getCombo());
        this.hideControl((Control)this.varCombos[1].getCombo());
        this.hideControl((Control)this.constTexts[0]);
        this.hideControl((Control)this.constTexts[1]);
    }

    private void hideControl(Control c) {
        GridData gd = new GridData();
        gd.exclude = true;
        c.setLayoutData((Object)gd);
        c.setVisible(false);
    }

    protected void predicateChanged(boolean updateParent) {
        this.noSelectionEvent = true;
        PredicateType predType = (PredicateType)this.operator.getElementAt(this.operator.getCombo().getSelectionIndex());
        if (predType != null) {
            switch (predType) {
                case IS_NULL: 
                case ISNOT_NULL: 
                case CONSTRAINT_NOT_SATISFIED: 
                case IS_TRUE: 
                case IS_FALSE: {
                    this.createEmptyLayout();
                    break;
                }
                case LESS_THAN: 
                case LESS_OR_EQUAL: 
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_OR_EQUAL: 
                case GREATER_THAN: {
                    this.createSingleValueLayout(this.predicate.getLowerBound());
                    break;
                }
                case IN_INTERVAL: 
                case NOTIN_INTERVAL: {
                    this.createIntervalLayout(this.predicate.getLowerBound(), this.predicate.getUpperBound());
                }
            }
        } else {
            this.createEmptyLayout();
        }
        this.layout(true);
        this.updatePredicate(updateParent);
        this.noSelectionEvent = false;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public void markAsError(boolean isError, String message) {
        this.markAsError(isError, message, false, true, new Control[]{this.operator.getCombo()});
    }

    public void markAsError(boolean isError, String message, Control ... controls) {
        this.markAsError(isError, message, true, false, controls);
    }

    public void markAsError(boolean isError, String message, boolean notifyParent, boolean overwriteOld, Control ... controls) {
        if (isError) {
            Color yellow = Display.getDefault().getSystemColor(7);
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                String newMsg;
                Control c = controlArray[n2];
                c.setBackground(yellow);
                newMsg = overwriteOld ? message : ((newMsg = c.getToolTipText()) != null && newMsg.length() > 0 ? String.valueOf(newMsg) + "\n" + message : message);
                c.setToolTipText(newMsg);
                ++n2;
            }
            if (notifyParent) {
                this.parentTbl.predicateHasError(this.predicate, message, 5);
            }
        } else {
            Control[] controlArray = controls;
            int n = controls.length;
            int n3 = 0;
            while (n3 < n) {
                Control c = controlArray[n3];
                c.setBackground(Display.getDefault().getSystemColor(25));
                c.setToolTipText(null);
                ++n3;
            }
            if (notifyParent) {
                this.parentTbl.clearPredicateErrors(this.predicate);
            }
        }
    }

    protected AtomicElement readConstantValue(int index) {
        SquigglyStyledText widget = this.constTexts[index];
        widget.getSquiggleList().clear();
        this.markAsError(false, null, true, false, new Control[]{widget});
        Constant val = this.expression.getDataType().parseFromString(widget.getText());
        if (val == null) {
            widget.addSquiggleRange(0, widget.getText().length() - 1, ERROR_INVALID_VALUE);
        }
        return val;
    }

    protected AtomicElement readVariableValue(int index) {
        ComboViewer widget = this.varCombos[index];
        this.markAsError(false, null, true, false, new Control[]{widget.getCombo()});
        return (Variable)widget.getElementAt(widget.getCombo().getSelectionIndex());
    }

    public boolean updatePredicate(boolean updateParent) {
        AtomicElement val1 = null;
        AtomicElement val2 = null;
        PredicateType type = (PredicateType)this.operator.getElementAt(this.operator.getCombo().getSelectionIndex());
        if (type == null) {
            return false;
        }
        boolean includeLowerBound = type.isIncludingLowerBound();
        boolean includeUpperBound = type.isIncludingUpperBound();
        if (this.expression.getType().isConstantComparison()) {
            if (type.getNumberOfConstants() >= 1) {
                val1 = this.readConstantValue(0);
            }
            if (type.getNumberOfConstants() >= 2) {
                val2 = this.readConstantValue(1);
            }
        } else {
            if (type.getNumberOfConstants() >= 1) {
                val1 = this.readVariableValue(0);
            }
            if (type.getNumberOfConstants() >= 2) {
                val2 = this.readVariableValue(1);
            }
        }
        switch (type) {
            case LESS_THAN: 
            case LESS_OR_EQUAL: 
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_OR_EQUAL: 
            case GREATER_THAN: {
                if (val1 != null) break;
                return false;
            }
            case IN_INTERVAL: 
            case NOTIN_INTERVAL: {
                if (val1 == null || val2 == null) {
                    return false;
                }
                this.markAsError(false, null, true, false, new Control[]{this.comboLowerBound, this.comboUpperBound});
                includeLowerBound = this.comboLowerBound.getSelectionIndex() == 1;
                boolean bl = includeUpperBound = this.comboUpperBound.getSelectionIndex() == 1;
                if (this.expression.getType().isConstantComparison()) {
                    Interval iv;
                    CoverableDataType dt = this.expression.getDataType();
                    if (dt.getComparator().compare(val1.getValue(), val2.getValue()) > 0) {
                        this.markAsError(true, ERROR_INVERSE_BOUNDS, true, false, new Control[]{this.constTexts[0], this.constTexts[1]});
                        return false;
                    }
                    try {
                        iv = dt.makeInterval(val1, val2, includeLowerBound, includeUpperBound);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.markAsError(true, ERROR_INVALID_BOUNDS, true, false, new Control[]{this.constTexts[0], this.constTexts[1]});
                        return false;
                    }
                    if (iv != null) break;
                    this.markAsError(true, ERROR_NULL_INTERVAL, true, false, new Control[]{this.constTexts[0], this.constTexts[1], this.comboLowerBound, this.comboUpperBound});
                    return false;
                }
                if (!val1.equals(val2) || includeLowerBound && includeUpperBound) break;
                this.markAsError(true, ERROR_NULL_INTERVAL, true, false, new Control[]{this.varCombos[0].getCombo(), this.varCombos[1].getCombo(), this.comboLowerBound, this.comboUpperBound});
                return false;
            }
        }
        this.predicate.setType(type);
        this.predicate.setLowerBound(val1);
        this.predicate.setUpperBound(val2);
        this.predicate.setLowerBoundIncluded(includeLowerBound);
        this.predicate.setUpperBoundIncluded(includeUpperBound);
        if (updateParent) {
            this.parentTbl.predicateUpdated(this.predicate);
        }
        return true;
    }
}

