/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultPredicate;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.AtomicElement;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.CoverableDataType;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.PredicateType;
import de.aristaflow.adept2.extensions.xorsupport.ui.PredicateComposite;
import de.aristaflow.adept2.extensions.xorsupport.ui.PredicatesWizardPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PredicateTable {
    protected Table table;
    protected Expression expression;
    protected PredicateComposite predicateComp;
    protected TableEditor predicateEditor;
    protected List<TableRowInfo> rowInfoList = new ArrayList<TableRowInfo>();
    protected TableColumn colPred;
    protected TableColumn colExclusive;
    protected TableColumn colDelete;
    protected TableColumn colError;
    protected TableRowInfo lastSelRow = null;
    protected Image tableRowFiller;
    protected PredicatesWizardPage wizardPage;
    protected final SelectionListener deleteButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableRowInfo ri = (TableRowInfo)e.widget.getData();
            PredicateTable.this.deletePredicate(ri);
        }
    };
    protected final SelectionListener exclusiveButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TableRowInfo ri = (TableRowInfo)e.widget.getData();
            ri.predicate.setExclusionPredicate(((Button)e.widget).getSelection());
        }
    };
    protected final FocusListener tableFocusListener = new FocusListener(){
        private final Runnable focusRunnable = new Runnable(){

            @Override
            public void run() {
                Control focusControl = Display.getCurrent().getFocusControl();
                if (focusControl != null && focusControl.getParent() != null && focusControl.getShell() == (this).PredicateTable.this.table.getShell() && !PredicateTable.hasParent(focusControl, (Composite)(this).PredicateTable.this.table)) {
                    (this).PredicateTable.this.predicateComp.setVisible(false);
                }
            }
        };

        public void focusLost(FocusEvent e) {
            e.display.asyncExec(this.focusRunnable);
        }

        public void focusGained(FocusEvent e) {
            if (PredicateTable.this.lastSelRow != null && !PredicateTable.this.predicateComp.isVisible()) {
                PredicateTable.this.predicateComp.setVisible(true);
            }
        }
    };
    protected final Color lightYellow = new Color((Device)Display.getDefault(), 255, 255, 127);
    protected static final String PREDICATE = "Predicate";
    protected static final String EXCLUSIVE = "Exclusive";
    protected static final String DELETE = "Delete";
    protected static final String ERRORS = "Errors";
    protected boolean needRelayout = false;

    public PredicateTable(Composite container, PredicatesWizardPage wizardPage) {
        this.wizardPage = wizardPage;
        this.table = new Table(container, 68096);
        this.predicateComp = new PredicateComposite((Composite)this.table, this);
        this.predicateComp.setVisible(false);
        this.predicateComp.setBackground(Display.getDefault().getSystemColor(26));
        this.predicateComp.setForeground(Display.getDefault().getSystemColor(27));
        this.predicateComp.pack();
        Control[] controlArray = this.predicateComp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.addFocusListener(this.tableFocusListener);
            ++n2;
        }
        this.colPred = new TableColumn(this.table, 16384);
        this.colPred.setText(PREDICATE);
        this.colPred.setWidth(400);
        this.colExclusive = new TableColumn(this.table, 0x1000000);
        this.colExclusive.setText(EXCLUSIVE);
        this.colExclusive.pack();
        this.colDelete = new TableColumn(this.table, 0x1000000);
        this.colDelete.setWidth(70);
        this.colError = new TableColumn(this.table, 16384);
        this.colError.setWidth(300);
        this.colError.setText(ERRORS);
        this.predicateEditor = new TableEditor(this.table);
        this.predicateEditor.grabHorizontal = true;
        this.predicateEditor.minimumWidth = 200;
        this.predicateEditor.minimumHeight = this.predicateComp.getSize().y;
        this.predicateEditor.verticalAlignment = 0x1000000;
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PredicateTable.this.showEditor((TableItem)e.item);
            }
        });
        this.table.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (PredicateTable.this.needRelayout) {
                    PredicateTable.this.needRelayout = false;
                    for (TableRowInfo tri : PredicateTable.this.rowInfoList) {
                        tri.deleteEditor.layout();
                        tri.exclusiveEditor.layout();
                    }
                }
            }
        });
        this.table.addFocusListener(this.tableFocusListener);
    }

    public Table getTable() {
        return this.table;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
        this.predicateComp.setExpression(expression);
        this.loadTable();
    }

    public void clearTable() {
        this.lastSelRow = null;
        this.table.removeAll();
        for (TableRowInfo ri : this.rowInfoList) {
            this.disposeRow(ri);
        }
        this.rowInfoList.clear();
        this.showEditor(null);
    }

    protected void disposeRow(TableRowInfo ri) {
        ri.deleteEditor.getEditor().dispose();
        ri.exclusiveEditor.getEditor().dispose();
        ri.deleteEditor.dispose();
        ri.exclusiveEditor.dispose();
        ri.tableItem.dispose();
    }

    public void loadTable() {
        this.clearTable();
        for (Predicate pred : this.expression.getPredicates()) {
            this.internalAppendPredicate(pred);
        }
    }

    public void appendPredicate() {
        Map m = this.expression.getDataType().getSupportedPredicateMap();
        Set supportedPredicates = (Set)m.get(this.expression.getType());
        DefaultPredicate newPred = null;
        if (this.expression.getLeftHandSide().canBeNull() && supportedPredicates.contains(PredicateType.IS_NULL)) {
            newPred = new DefaultPredicate(PredicateType.IS_NULL, this.expression);
        } else {
            for (PredicateType type : supportedPredicates) {
                if (type == PredicateType.IS_NULL || type == PredicateType.ISNOT_NULL) continue;
                if (this.expression.getDataType().equals(CoverableDataType.STRING) && !type.equals((Object)PredicateType.CONSTRAINT_NOT_SATISFIED)) {
                    type = PredicateType.EQUALS;
                }
                newPred = new DefaultPredicate(type, this.expression, (AtomicElement)this.expression.getDataType().getDefaultValue(), (AtomicElement)this.expression.getDataType().getDefaultValue(), type.isIncludingLowerBound(), type.isIncludingUpperBound());
                break;
            }
        }
        this.appendPredicate((Predicate)newPred);
    }

    protected void deletePredicate(TableRowInfo rowInfo) {
        if (this.lastSelRow == rowInfo) {
            this.showEditor(null);
        }
        this.expression.getPredicates().remove(rowInfo.predicate);
        this.table.remove(this.table.indexOf(rowInfo.tableItem));
        this.rowInfoList.remove(rowInfo);
        this.disposeRow(rowInfo);
        this.wizardPage.updateExpression(true);
        this.needRelayout = true;
    }

    public void appendPredicate(Predicate pred) {
        TableRowInfo tri = this.internalAppendPredicate(pred);
        this.focusPredicate(tri);
        this.wizardPage.updateExpression(true);
    }

    public void focusPredicate(Predicate pred) {
        this.focusPredicate(this.lookupRowInfoFor(pred));
    }

    protected void focusPredicate(TableRowInfo tri) {
        this.table.setSelection(this.table.indexOf(tri.tableItem));
        this.table.showSelection();
        this.showEditor(tri.tableItem);
        this.predicateComp.setFocus();
    }

    protected TableRowInfo internalAppendPredicate(Predicate pred) {
        if (pred.getParent() != this.expression) {
            throw new IllegalArgumentException("The predicate's parent is different from the edited expression.");
        }
        TableRowInfo rowInfo = new TableRowInfo();
        rowInfo.tableItem = new TableItem(this.table, 0);
        rowInfo.tableItem.setText(0, pred.toString());
        rowInfo.tableItem.setData((Object)rowInfo);
        Button exclButton = new Button((Composite)this.table, 32);
        exclButton.setData((Object)rowInfo);
        exclButton.setSelection(pred.isExclusionPredicate());
        exclButton.addSelectionListener(this.exclusiveButtonListener);
        exclButton.pack();
        exclButton.setBackground(this.table.getBackground());
        exclButton.addFocusListener(this.tableFocusListener);
        rowInfo.exclusiveEditor = new TableEditor(this.table);
        Point minSize = exclButton.getSize();
        rowInfo.exclusiveEditor.minimumWidth = minSize.x;
        rowInfo.exclusiveEditor.minimumHeight = minSize.y;
        rowInfo.exclusiveEditor.verticalAlignment = 0x1000000;
        rowInfo.exclusiveEditor.setColumn(1);
        rowInfo.exclusiveEditor.setItem(rowInfo.tableItem);
        rowInfo.exclusiveEditor.setEditor((Control)exclButton);
        Button deleteButton = new Button((Composite)this.table, 8);
        deleteButton.setText(DELETE);
        deleteButton.addSelectionListener(this.deleteButtonListener);
        deleteButton.setData((Object)rowInfo);
        deleteButton.pack();
        deleteButton.addFocusListener(this.tableFocusListener);
        rowInfo.deleteEditor = new TableEditor(this.table);
        minSize = deleteButton.getSize();
        rowInfo.deleteEditor.minimumWidth = minSize.x;
        rowInfo.deleteEditor.minimumHeight = minSize.y;
        rowInfo.deleteEditor.verticalAlignment = 0x1000000;
        rowInfo.deleteEditor.setColumn(2);
        rowInfo.deleteEditor.setItem(rowInfo.tableItem);
        rowInfo.deleteEditor.setEditor((Control)deleteButton);
        if (this.tableRowFiller == null) {
            this.tableRowFiller = new Image(null, 1, Math.max(this.predicateEditor.minimumHeight, Math.max(rowInfo.deleteEditor.minimumHeight, rowInfo.exclusiveEditor.minimumHeight)));
        }
        rowInfo.tableItem.setImage(3, this.tableRowFiller);
        rowInfo.predicate = pred;
        this.rowInfoList.add(rowInfo);
        this.needRelayout = true;
        return rowInfo;
    }

    protected void showEditor(TableItem item) {
        if (this.lastSelRow != null) {
            this.lastSelRow.exclusiveEditor.getEditor().setBackground(Display.getDefault().getSystemColor(25));
        }
        if (item == null) {
            this.predicateComp.setVisible(false);
            this.predicateEditor.setEditor(null);
            this.lastSelRow = null;
        } else {
            Color selBg = Display.getDefault().getSystemColor(26);
            TableRowInfo rowInfo = (TableRowInfo)item.getData();
            rowInfo.exclusiveEditor.getEditor().setBackground(selBg);
            this.predicateComp.setPredicate(rowInfo.predicate);
            this.predicateComp.markAsError(rowInfo.hasErrors, rowInfo.errorMessage);
            this.predicateComp.setVisible(true);
            this.predicateEditor.setEditor((Control)this.predicateComp, item, 0);
            this.lastSelRow = rowInfo;
        }
    }

    protected TableRowInfo lookupRowInfoFor(Predicate pred) {
        for (TableRowInfo tri : this.rowInfoList) {
            if (tri.predicate != pred) continue;
            return tri;
        }
        return null;
    }

    public void predicateUpdated(Predicate pred) {
        TableRowInfo predRow = this.lookupRowInfoFor(pred);
        predRow.tableItem.setText(0, pred.toString());
        this.wizardPage.updateExpression(true);
    }

    public void variableOrderChanged() {
        for (TableRowInfo tri : this.rowInfoList) {
            if (tri.predicate.getType() != PredicateType.CONSTRAINT_NOT_SATISFIED) continue;
            tri.tableItem.setText(0, tri.predicate.toString());
        }
    }

    public void predicateHasError(Predicate pred, String text, int severity) {
        this.wizardPage.getErrorMessageList().addError(pred, text, severity);
    }

    public void clearPredicateErrors(Predicate pred) {
        this.wizardPage.getErrorMessageList().removeForOwner(pred);
    }

    public void markRowAsError(Predicate pred, String errorMsg) {
        this.markRowAsError(this.lookupRowInfoFor(pred), errorMsg);
    }

    protected void markRowAsError(TableRowInfo ri, String errorMsg) {
        if (ri == null) {
            return;
        }
        if (this.lastSelRow == ri) {
            this.predicateComp.markAsError(true, errorMsg);
        }
        ri.tableItem.setBackground(this.lightYellow);
        ri.errorMessage = ri.errorMessage == null || ri.errorMessage.length() == 0 ? errorMsg : String.valueOf(ri.errorMessage) + "\n " + errorMsg;
        ri.tableItem.setText(3, ri.errorMessage.replace('\n', ';'));
        ri.hasErrors = true;
    }

    public void unmarkAllRows() {
        Color defBg = Display.getDefault().getSystemColor(25);
        for (TableRowInfo ri : this.rowInfoList) {
            ri.tableItem.setBackground(defBg);
            ri.tableItem.setText(3, "");
            ri.hasErrors = false;
            ri.errorMessage = "";
        }
        if (this.predicateComp.isVisible()) {
            this.predicateComp.markAsError(false, null);
        }
    }

    public void markRowsContaining(List<Variable> vars, String msg, boolean mustContainBoth) {
        block3: for (TableRowInfo tri : this.rowInfoList) {
            if (mustContainBoth) {
                switch (tri.predicate.getType()) {
                    case IN_INTERVAL: 
                    case NOTIN_INTERVAL: {
                        if (!vars.contains(tri.predicate.getLowerBound()) || !vars.contains(tri.predicate.getUpperBound())) continue block3;
                        this.markRowAsError(tri, msg);
                    }
                }
                continue;
            }
            if (tri.predicate.getType().getNumberOfConstants() >= 1 && vars.contains(tri.predicate.getLowerBound())) {
                this.markRowAsError(tri, msg);
                continue;
            }
            if (tri.predicate.getType().getNumberOfConstants() < 2 || !vars.contains(tri.predicate.getUpperBound())) continue;
            this.markRowAsError(tri, msg);
        }
    }

    public boolean commitChanges() {
        if (this.lastSelRow != null) {
            return this.predicateComp.updatePredicate(false);
        }
        return true;
    }

    protected static boolean hasParent(Control child, Composite parentToFind) {
        if (child == null) {
            return false;
        }
        if (child == parentToFind) {
            return true;
        }
        return PredicateTable.hasParent((Control)child.getParent(), parentToFind);
    }

    protected static class TableRowInfo {
        public TableItem tableItem;
        public TableEditor exclusiveEditor;
        public TableEditor deleteEditor;
        public Predicate predicate;
        public boolean hasErrors;
        public String errorMessage;

        protected TableRowInfo() {
        }
    }
}

