/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultVariable;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.PredicateType;
import de.aristaflow.adept2.extensions.xorsupport.ui.CoverCheckComposite;
import de.aristaflow.adept2.extensions.xorsupport.ui.ErrorMessageList;
import de.aristaflow.adept2.extensions.xorsupport.ui.PredicateTable;
import de.aristaflow.adept2.extensions.xorsupport.ui.SaveLoadHelper;
import de.aristaflow.adept2.extensions.xorsupport.util.Graph;
import java.util.List;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class PredicatesWizardPage
extends WizardPage
implements IPageChangedListener {
    public static final String PAGE_NAME = "de.aristaflow.rules.XOR#predicates";
    protected Button addPredicate;
    protected Button saveButton;
    protected Composite container;
    protected Composite predListContainer;
    protected Label varSizesLabelCaption;
    protected Label varSizesLabel;
    protected ExpandBar errorBar;
    protected ExpandItem errorItem;
    protected ComboViewer expressionsCombo;
    protected CoverCheckComposite coverCheckComp;
    protected BranchTreeManager treeManager;
    protected boolean[] isExpressionOK;
    protected int currentExpressionIndex = -1;
    protected boolean noSelectionEvents = false;
    protected ErrorMessageList errorMessageList;
    protected PredicateTable predicateTable;
    protected static final String DIMENSION = "Dimension:";
    protected static final String COVER_ERROR_MSG = "There are coverage errors. See the list at the bottom for details.";
    protected static final String TITLE = "Predicates";
    protected static final String ADD_PREDICATE = "Add predicate";
    protected static final String IMPLIED_VAR_SIZES = "Required variable order:";
    protected static final String CIRCULAR_VARIABLES = "The global relative sizes of the following variables form a cycle: ";
    protected static final String NO_TOTAL_ORDER = "Cannot deduce the correct required variable ordering from the given predicates.";
    protected static final String NO_TOTAL_ORDER_MULTIPLE_STARTOREND = "Hint: I need to know if either ";
    protected static final String NO_TOTAL_ORDER_CYCLE = "The relative sizes of the following variables form a cycle: ";
    protected static final String NO_VALID_ORDER = "No valid order.";
    protected static final String NO_ERRORS = "OK";
    protected static final String HAS_ERRORS = "has errors";
    protected static final String STATUS_UNKNOWN = "status unknown";
    protected static final String ERROR_LIST_ERRORS = "Detected coverage errors - %s error(s) found";
    protected static final String NUMBER_ZERO = "no";
    protected static final String DESCRIPTION = "Please specify predicates to partition the dimensions' values here. Every partition represents (part of) a decision alternative you can assign a decision ID to in the next step.";
    protected boolean needExprListRefresh = false;
    private Label errorIndicator;

    public PredicatesWizardPage(BranchTreeManager treeManager) {
        super(PAGE_NAME, TITLE, null);
        this.treeManager = treeManager;
        this.errorMessageList = new ErrorMessageList(this);
        this.setPageComplete(false);
    }

    public void addPredicateComposite(Predicate pred) {
        this.predicateTable.appendPredicate(pred);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(3, false));
        new Label(this.container, 0).setText(DIMENSION);
        this.expressionsCombo = new ComboViewer(this.container, 8);
        this.expressionsCombo.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.expressionsCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Expression ex = (Expression)element;
                int exPos = PredicatesWizardPage.this.treeManager.getExpressionList().indexOf(ex);
                String isOK = exPos >= 0 && PredicatesWizardPage.this.isExpressionOK != null && exPos < PredicatesWizardPage.this.isExpressionOK.length ? (PredicatesWizardPage.this.isExpressionOK[exPos] ? PredicatesWizardPage.NO_ERRORS : PredicatesWizardPage.HAS_ERRORS) : PredicatesWizardPage.STATUS_UNKNOWN;
                return String.valueOf(exPos + 1) + ":\u00c2\u00ab" + (ex.getLeftHandSide() != null ? ex.getLeftHandSide().toString() : "null") + "\u00c2\u00bb [" + (ex.getDataType() != null ? ex.getDataType().toString() : "null") + "]: " + ex.getType().getDescription() + "  -  " + isOK;
            }
        });
        this.expressionsCombo.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!PredicatesWizardPage.this.noSelectionEvents) {
                    PredicatesWizardPage.this.loadExpression(PredicatesWizardPage.this.expressionsCombo.getCombo().getSelectionIndex());
                }
            }
        });
        this.errorIndicator = new Label(this.container, 0);
        this.errorIndicator.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        new Label(this.container, 258).setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
        Label dimPredLabel = new Label(this.container, 0);
        dimPredLabel.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).indent(0, 10).create());
        dimPredLabel.setText("Predicates of the dimension:");
        this.predListContainer = new Composite(this.container, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 200;
        gd.widthHint = 600;
        gd.horizontalSpan = 3;
        this.predListContainer.setLayoutData((Object)gd);
        this.predListContainer.setLayout((Layout)new GridLayout(2, false));
        this.predicateTable = new PredicateTable(this.predListContainer, this);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.predicateTable.getTable().setLayoutData((Object)gd);
        this.addPredicate = new Button(this.predListContainer, 8);
        this.addPredicate.setText(ADD_PREDICATE);
        this.addPredicate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PredicatesWizardPage.this.predicateTable.appendPredicate();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.addPredicate.setLayoutData((Object)gd);
        this.varSizesLabelCaption = new Label(this.predListContainer, 0);
        this.varSizesLabelCaption.setText(IMPLIED_VAR_SIZES);
        this.varSizesLabelCaption.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.saveButton = SaveLoadHelper.createSaveButton(this.predListContainer, (IWizardPage)this, this.treeManager);
        this.saveButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.varSizesLabel = new Label(this.predListContainer, 0);
        this.varSizesLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.errorBar = new ExpandBar(this.container, 0);
        this.errorBar.addExpandListener(new ExpandListener(){

            public void itemCollapsed(ExpandEvent e) {
                PredicatesWizardPage.this.relayoutExpandBar((ExpandItem)e.item);
            }

            public void itemExpanded(ExpandEvent e) {
                PredicatesWizardPage.this.relayoutExpandBar((ExpandItem)e.item);
            }
        });
        this.coverCheckComp = new CoverCheckComposite((Composite)this.errorBar, 0, this);
        this.errorItem = new ExpandItem(this.errorBar, 0);
        this.errorItem.setText(ERROR_LIST_ERRORS);
        this.errorItem.setControl((Control)this.coverCheckComp);
        this.errorItem.setHeight(160);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        gd.heightHint = this.errorBar.computeSize((int)-1, (int)-1).y;
        this.errorBar.setLayoutData((Object)gd);
        this.setDescription(DESCRIPTION);
        this.setControl((Control)this.container);
        this.container.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                PredicatesWizardPage.this.refreshExpressionList();
                if (PredicatesWizardPage.this.treeManager.getExpressionList().size() > 0) {
                    PredicatesWizardPage.this.loadExpression(0);
                }
                PredicatesWizardPage.this.needExprListRefresh = false;
            }
        });
    }

    public void pageChanged(PageChangedEvent event) {
        this.refreshExpressionList();
        if (this.treeManager.getExpressionList().size() > 0) {
            this.loadExpression(0);
        }
        this.needExprListRefresh = false;
    }

    public void refreshExpressionList() {
        if (!this.isCurrentPage()) {
            this.needExprListRefresh = true;
            return;
        }
        this.expressionsCombo.getCombo().removeAll();
        this.isExpressionOK = new boolean[this.treeManager.getExpressionList().size()];
        this.expressionsCombo.add(this.treeManager.getExpressionList().toArray());
        this.currentExpressionIndex = -1;
        this.predicateTable.clearTable();
    }

    public void loadExpression(int index) {
        if (!this.isCurrentPage()) {
            return;
        }
        this.noSelectionEvents = true;
        if (this.currentExpressionIndex >= 0) {
            this.updateExpression(false);
        }
        this.currentExpressionIndex = index;
        this.expressionsCombo.getCombo().select(index);
        Expression exp = this.getCurrentExpression();
        boolean haveVar = !exp.getType().isConstantComparison();
        this.varSizesLabel.setVisible(haveVar);
        this.varSizesLabelCaption.setVisible(haveVar);
        if (exp.getLeftHandSide() != null) {
            this.predicateTable.setExpression(exp);
            this.coverCheckComp.setExpression(exp);
            if (exp.getPredicates().size() == 0) {
                this.predicateTable.appendPredicate();
            }
        }
        this.noSelectionEvents = false;
        this.updateExpression(true);
    }

    public void markPredicateAsError(Predicate pred, String errorMsg) {
        this.predicateTable.markRowAsError(pred, errorMsg);
    }

    public void unmarkAllPredicates() {
        this.predicateTable.unmarkAllRows();
    }

    public void focusPredicate(Predicate pred) {
        this.predicateTable.focusPredicate(pred);
    }

    public boolean updateExpression(boolean modifyPageComplete) {
        boolean res = true;
        res = this.predicateTable.commitChanges();
        this.getErrorMessageList().removeForOwner((Object)this);
        Expression exp = this.getCurrentExpression();
        if (!exp.getType().isConstantComparison()) {
            Graph topSorter = new Graph();
            for (Predicate pred : exp.getPredicates()) {
                PredicateType predType = pred.getType();
                if (predType.getNumberOfConstants() >= 1) {
                    topSorter.addNode((Object)((Variable)pred.getLowerBound()));
                }
                if (predType.getNumberOfConstants() != 2) continue;
                Variable var1 = (Variable)pred.getLowerBound();
                Variable var2 = (Variable)pred.getUpperBound();
                topSorter.addNode((Object)var1);
                topSorter.addNode((Object)var2);
                if (var1.equals(var2)) continue;
                topSorter.addEdge((Object)var1, (Object)var2);
            }
            exp.getVariableOrder().clear();
            int totalOrderRes = topSorter.definesTotalOrdering();
            if (totalOrderRes != 0) {
                String errorMessage = null;
                if ((totalOrderRes & 3) != 0 && (totalOrderRes & 4) == 0) {
                    StringBuilder errMsg = new StringBuilder();
                    errMsg.append(NO_TOTAL_ORDER);
                    errMsg.append('\n');
                    errMsg.append(NO_TOTAL_ORDER_MULTIPLE_STARTOREND);
                    for (Variable var1 : topSorter.getResult()) {
                        if (topSorter.getOutDegree((Object)var1) != 0) continue;
                        for (Variable var2 : topSorter.getResult()) {
                            if (var1 == var2 || topSorter.getInDegree((Object)var2) != 0 || topSorter.existsPath((Object)var2, (Object)var1)) continue;
                            errMsg.append(var1.getName()).append("\u00e2\u2030\u00a4").append(var2.getName()).append(" or ");
                        }
                    }
                    errMsg.delete(errMsg.length() - 4, errMsg.length());
                    errorMessage = errMsg.toString();
                    this.predicateTable.markRowsContaining(topSorter.getResult(), errorMessage, false);
                } else if (!topSorter.sort()) {
                    List cycleNodes = topSorter.getCycleNodes();
                    errorMessage = "Cannot deduce the correct required variable ordering from the given predicates.\nThe relative sizes of the following variables form a cycle: " + DefaultVariable.variableListToString((List)cycleNodes, (String)", ");
                    this.predicateTable.markRowsContaining(cycleNodes, errorMessage, true);
                }
                if (errorMessage != null) {
                    this.getErrorMessageList().addError((Object)this, errorMessage, 8);
                    res = false;
                    this.varSizesLabel.setText(NO_VALID_ORDER);
                    this.varSizesLabel.setForeground(Display.getDefault().getSystemColor(3));
                }
            }
            if (res) {
                List resList = topSorter.getResult();
                exp.getVariableOrder().addAll(resList);
                this.predicateTable.variableOrderChanged();
                BranchTreeManager.VariableOrderResult orderRes = this.treeManager.calculateGlobalVariableOrdering();
                if (!orderRes.success) {
                    String msg = CIRCULAR_VARIABLES + DefaultVariable.variableListToString((List)orderRes.cycleNodes, (String)", ");
                    this.getErrorMessageList().addError((Object)this, msg, 6);
                    this.predicateTable.markRowsContaining(orderRes.cycleNodes, msg, true);
                    int i = 0;
                    while (i < this.treeManager.getExpressionList().size()) {
                        Expression expr = (Expression)this.treeManager.getExpressionList().get(i);
                        if (!expr.getType().isConstantComparison()) {
                            for (Predicate pred : expr.getPredicates()) {
                                if (!orderRes.cycleNodes.contains(pred.getLowerBound()) || !orderRes.cycleNodes.contains(pred.getUpperBound())) continue;
                                this.isExpressionOK[i] = false;
                                this.expressionsCombo.refresh((Object)expr);
                                this.updateGlobalErrorIndicator();
                                break;
                            }
                        }
                        ++i;
                    }
                    res = false;
                }
                this.varSizesLabel.setText(DefaultVariable.variableListToString((List)resList, (String)"\u00e2\u2030\u00a4"));
                this.varSizesLabel.setForeground(Display.getDefault().getSystemColor(21));
            }
        }
        if (res) {
            res &= !this.coverCheckComp.checkErrors();
        } else {
            this.coverCheckComp.clearErrors();
        }
        if (this.isExpressionOK != null) {
            this.isExpressionOK[this.currentExpressionIndex] = res;
        }
        if (modifyPageComplete) {
            this.noSelectionEvents = true;
            this.setPageComplete(res);
            this.noSelectionEvents = false;
        }
        this.noSelectionEvents = true;
        this.expressionsCombo.refresh((Object)exp);
        this.updateGlobalErrorIndicator();
        this.noSelectionEvents = false;
        return res;
    }

    private void updateGlobalErrorIndicator() {
        boolean allOk = true;
        boolean[] blArray = this.isExpressionOK;
        int n = this.isExpressionOK.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isExpressionOK = blArray[n2];
            if (!isExpressionOK) {
                allOk = false;
                break;
            }
            ++n2;
        }
        this.errorIndicator.setVisible(!allOk);
        this.setPageComplete(allOk);
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public IWizardPage getPreviousPage() {
        if (!this.noSelectionEvents && this.isCurrentPage()) {
            this.updateExpression(false);
        }
        return super.getPreviousPage();
    }

    public void errorStatusChanged(boolean haveError) {
        if (haveError) {
            this.errorMessageList.addError((Object)this.coverCheckComp, COVER_ERROR_MSG, -5);
            this.errorItem.setText(String.format(ERROR_LIST_ERRORS, this.coverCheckComp.getNumberOfErrors()));
            if (!this.errorItem.getExpanded()) {
                this.relayoutExpandBar(this.errorItem);
                this.errorItem.setExpanded(true);
            }
        } else {
            this.errorMessageList.removeForOwner((Object)this.coverCheckComp);
            this.errorItem.setText(String.format(ERROR_LIST_ERRORS, NUMBER_ZERO));
        }
        if (this.isExpressionOK != null) {
            this.isExpressionOK[this.currentExpressionIndex] = !haveError;
        }
    }

    protected Expression getCurrentExpression() {
        return (Expression)this.treeManager.getExpressionList().get(this.currentExpressionIndex);
    }

    public ErrorMessageList getErrorMessageList() {
        return this.errorMessageList;
    }

    protected void relayoutExpandBar(ExpandItem changed) {
        int height = this.errorBar.computeSize((int)-1, (int)-1).y;
        height = changed.getExpanded() ? (height -= changed.getHeight()) : (height += changed.getHeight());
        ((GridData)this.errorBar.getLayoutData()).heightHint = height;
        this.container.layout(new Control[]{this.errorBar});
    }
}

