/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveLoadHelper {
    public static final String LOAD_BUTTON_TEXT = "Load...";
    public static final String SAVE_BUTTON_TEXT = "Save...";
    public static final String LOAD_DIALOG_TITLE = "Load Wizard from XML";
    public static final String SAVE_DIALOG_TITLE = "Save Wizard to XML";
    protected static final String XML_FILES_TEXT = "XML files (*.xml)";
    protected static final String ALL_FILES_TEXT = "All files";
    protected static final String[] FILTER_NAMES = new String[]{"XML files (*.xml)", "All files"};
    protected static final String[] FILTER_EXTENSIONS = new String[]{"*.xml", "*"};

    public static void loadFromXMLFile(Wizard wizard, BranchTreeManager treeManager) {
        FileDialog openDialog = new FileDialog(wizard.getShell(), 4096);
        openDialog.setFilterNames(FILTER_NAMES);
        openDialog.setFilterExtensions(FILTER_EXTENSIONS);
        openDialog.setText(LOAD_DIALOG_TITLE);
        String fileName = openDialog.open();
        if (fileName == null) {
            return;
        }
        try {
            treeManager.deserializeFromXML((Reader)new FileReader(fileName), true);
            wizard.getContainer().updateButtons();
        }
        catch (Exception e1) {
            MessageDialog.openError((Shell)wizard.getShell(), (String)wizard.getWindowTitle(), (String)e1.toString());
        }
    }

    public static void saveToXMLFile(Wizard wizard, BranchTreeManager treeManager) {
        FileDialog saveDialog = new FileDialog(wizard.getShell(), 8192);
        saveDialog.setFilterNames(FILTER_NAMES);
        saveDialog.setFilterExtensions(FILTER_EXTENSIONS);
        saveDialog.setText(SAVE_DIALOG_TITLE);
        String fileName = saveDialog.open();
        if (fileName == null) {
            return;
        }
        try {
            treeManager.serializeToXML((Writer)new FileWriter(fileName), true, true);
        }
        catch (Exception e1) {
            MessageDialog.openError((Shell)wizard.getShell(), (String)wizard.getWindowTitle(), (String)e1.toString());
        }
    }

    public static Button createSaveButton(Composite container, IWizardPage wizardPage, BranchTreeManager treeManager) {
        Button rv = new Button(container, 8);
        rv.setText(SAVE_BUTTON_TEXT);
        rv.addSelectionListener((SelectionListener)new SaveListener(treeManager, (Wizard)wizardPage.getWizard()));
        return rv;
    }

    public static class LoadListener
    extends SelectionAdapter {
        protected BranchTreeManager treeManager;
        protected Wizard wizard;

        public LoadListener(BranchTreeManager treeManager, Wizard wizard) {
            this.treeManager = treeManager;
            this.wizard = wizard;
        }

        public void widgetSelected(SelectionEvent e) {
            SaveLoadHelper.loadFromXMLFile(this.wizard, this.treeManager);
        }
    }

    public static class SaveListener
    extends SelectionAdapter {
        protected BranchTreeManager treeManager;
        protected Wizard wizard;

        public SaveListener(BranchTreeManager treeManager, Wizard wizard) {
            this.treeManager = treeManager;
            this.wizard = wizard;
        }

        public void widgetSelected(SelectionEvent e) {
            SaveLoadHelper.saveToXMLFile(this.wizard, this.treeManager);
        }
    }
}

