/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SquigglyStyledText
extends StyledText {
    protected List<Range> squiggleList = new ArrayList<Range>();
    protected int squiggleHeight = 3;

    public SquigglyStyledText(Composite parent, int style) {
        super(parent, style);
        CommonEventListener commonListener = new CommonEventListener();
        this.addListener(9, commonListener);
        this.addListener(5, commonListener);
        this.addListener(6, commonListener);
    }

    protected int[] makeSquigglyLine(int x, int y, int width) {
        int[] res = new int[(width / this.squiggleHeight + 1) * 2];
        int xpos = x;
        int i = 0;
        while (i < res.length) {
            res[i] = xpos;
            res[i + 1] = (i & 3) == 0 ? y : y + this.squiggleHeight;
            i += 2;
            xpos += this.squiggleHeight;
        }
        return res;
    }

    public void addSquiggleRange(int start, int length, String toolTip) {
        this.squiggleList.add(new Range(start, length, toolTip));
    }

    public List<Range> getSquiggleList() {
        return this.squiggleList;
    }

    public int getSquiggleHeight() {
        return this.squiggleHeight;
    }

    public void setSquiggleHeight(int squiggleHeight) {
        this.squiggleHeight = squiggleHeight;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point res = super.computeSize(wHint, hHint, changed);
        res.y += this.squiggleHeight;
        return res;
    }

    protected class CommonEventListener
    implements Listener {
        private final Color RED = Display.getDefault().getSystemColor(3);

        protected CommonEventListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 5: 
                case 6: {
                    this.handleMouseHover(event);
                    break;
                }
                case 9: {
                    this.handlePaint(event);
                }
            }
        }

        protected void handleMouseHover(Event event) {
            int offset;
            try {
                offset = SquigglyStyledText.this.getOffsetAtLocation(new Point(event.x, event.y));
            }
            catch (SWTException sWTException) {
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            String tooltipText = null;
            for (Range r : SquigglyStyledText.this.squiggleList) {
                if (offset < r.start || offset >= r.start + r.length) continue;
                tooltipText = r.toolTip;
                break;
            }
            String oldText = SquigglyStyledText.this.getToolTipText();
            if (tooltipText != oldText || tooltipText != null && !tooltipText.equals(oldText)) {
                SquigglyStyledText.this.setToolTipText(tooltipText);
            }
        }

        public void handlePaint(Event event) {
            int lineHeight = SquigglyStyledText.this.getLineHeight();
            String text = SquigglyStyledText.this.getText();
            event.gc.setForeground(this.RED);
            for (Range r : SquigglyStyledText.this.squiggleList) {
                if (r.start + r.length >= text.length()) continue;
                String squiggleText = text.substring(r.start, r.start + r.length + 1);
                int stringWidth = event.gc.stringExtent((String)squiggleText).x;
                Point topLeft = SquigglyStyledText.this.getLocationAtOffset(r.start);
                int[] squigglyPoly = SquigglyStyledText.this.makeSquigglyLine(topLeft.x, topLeft.y + lineHeight - SquigglyStyledText.this.squiggleHeight, stringWidth);
                event.gc.drawPolyline(squigglyPoly);
            }
        }
    }

    public static class Range {
        public int start;
        public int length;
        public String toolTip;

        public Range(int start, int length, String toolTip) {
            this.start = start;
            this.length = length;
            this.toolTip = toolTip;
        }
    }
}

