/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.DecisionID;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Expression;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Predicate;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.ui.Activator;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ActivityPnPWizardData;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SummaryPage
extends WizardPage
implements IPageChangingListener {
    public static final String PAGE_NAME = "de.aristaflow.rules.XOR#summary";
    protected static final String NO_PREDICATE_COMBINATION_ASSOCIATED = "No predicate combination associated!";
    protected static final String TITLE = "Summary";
    protected static final String DESCRIPTION = "This page displays a summary of the settings you have entered in the previous steps.";
    protected static final String DECISION_IDS_LABEL = "Defined decision IDs and decision statements:";
    protected static final String UNUSED_VARS_LABEL = "Unused variables (input parameters):";
    protected static final String NO_UNUSED_VARS = "All defined variables have been used.";
    protected static final String REMOVE = "Remove";
    protected static final String REMOVE_CONFIRM = "Remove the selected variable?";
    protected BranchTreeManager treeManager;
    protected Composite container;
    protected ListViewer unusedVars;
    protected StyledText decisionIDReport;
    protected Button removeVariable;
    protected ActivityPnPWizardData wizardData;

    public SummaryPage(BranchTreeManager treeManager, ActivityPnPWizardData wizardData) {
        super(PAGE_NAME, TITLE, null);
        this.treeManager = treeManager;
        this.wizardData = wizardData;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)this.container);
        Label tmpLabel = new Label(this.container, 0);
        tmpLabel.setText(DECISION_IDS_LABEL);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        tmpLabel.setLayoutData((Object)gd);
        this.decisionIDReport = new StyledText(this.container, 2818);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.decisionIDReport.setLayoutData((Object)gd);
        this.decisionIDReport.setEditable(false);
        tmpLabel = new Label(this.container, 0);
        tmpLabel.setText(UNUSED_VARS_LABEL);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        tmpLabel.setLayoutData((Object)gd);
        this.unusedVars = new ListViewer(this.container, 2560);
        gd = new GridData(4, 4, true, false);
        gd.heightHint = 100;
        this.unusedVars.getList().setLayoutData((Object)gd);
        this.unusedVars.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object sel = ((IStructuredSelection)event.getSelection()).getFirstElement();
                SummaryPage.this.removeVariable.setEnabled(sel != null && sel instanceof Variable);
            }
        });
        this.removeVariable = new Button(this.container, 8);
        this.removeVariable.setText(REMOVE);
        this.removeVariable.setLayoutData((Object)new GridData(4, 128, false, false));
        this.removeVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object sel = ((IStructuredSelection)SummaryPage.this.unusedVars.getSelection()).getFirstElement();
                if (sel == null || !(sel instanceof Variable)) {
                    return;
                }
                if (MessageDialog.openQuestion((Shell)SummaryPage.this.getShell(), (String)SummaryPage.REMOVE, (String)SummaryPage.REMOVE_CONFIRM)) {
                    if (SummaryPage.this.wizardData != null) {
                        SummaryPage.this.wizardData.removeParameter(((Variable)sel).getName(), ActivityConstants.AccessType.READ);
                    } else {
                        SummaryPage.this.treeManager.getVariables().removeVariable((Variable)sel);
                    }
                    SummaryPage.this.loadUnusedVars();
                }
            }
        });
        this.setDescription(DESCRIPTION);
    }

    public void handlePageChanging(PageChangingEvent event) {
        if (event.getTargetPage() == this) {
            this.loadDecisionIDText();
            this.loadUnusedVars();
            this.setPageComplete(true);
            this.getNextPage().isPageComplete();
        } else if (event.getCurrentPage() == this) {
            IWizardPage page = this.getPreviousPage();
            while (page != null) {
                if (event.getTargetPage() == page) {
                    this.setPageComplete(false);
                    break;
                }
                page = page.getPreviousPage();
            }
        }
    }

    protected void loadDecisionIDText() {
        StringBuilder textBuf = new StringBuilder();
        ArrayList<StyleRange> boldRanges = new ArrayList<StyleRange>();
        for (DecisionID id : this.treeManager.getAvailableDecisionIDs()) {
            int boldStart = textBuf.length();
            textBuf.append(id).append(":\n");
            boldRanges.add(new StyleRange(boldStart, textBuf.length() - boldStart, null, null, 1));
            String statement = id.calculateStatement();
            if (statement == null) {
                textBuf.append(NO_PREDICATE_COMBINATION_ASSOCIATED);
            } else {
                textBuf.append(statement);
            }
            textBuf.append("\n\n");
        }
        this.decisionIDReport.setText(textBuf.toString());
        this.decisionIDReport.setStyleRanges(boldRanges.toArray(new StyleRange[boldRanges.size()]));
    }

    protected void loadUnusedVars() {
        HashSet vars = new HashSet(this.treeManager.getVariables().getKnownVariables().values());
        for (Expression expr : this.treeManager.getExpressionList()) {
            vars.removeAll(expr.getLHSVariables());
            if (expr.getType().isConstantComparison()) continue;
            for (Predicate pred : expr.getPredicates()) {
                if (pred.getLowerBound() != null && pred.getLowerBound() instanceof Variable) {
                    vars.remove(pred.getLowerBound());
                }
                if (pred.getUpperBound() == null || !(pred.getUpperBound() instanceof Variable)) continue;
                vars.remove(pred.getUpperBound());
            }
        }
        this.unusedVars.getList().removeAll();
        this.removeVariable.setEnabled(false);
        if (vars.size() > 0) {
            for (Variable var : vars) {
                this.unusedVars.add((Object)var);
            }
        } else {
            this.unusedVars.add((Object)NO_UNUSED_VARS);
        }
    }

    public IWizardPage getNextPage() {
        ArrayList<DecisionStatement> statements = new ArrayList<DecisionStatement>(this.treeManager.getAvailableDecisionIDs().size());
        for (DecisionID id : this.treeManager.getAvailableDecisionIDs()) {
            String statement = id.calculateStatement();
            String label = id.getLabel();
            if (label == null) {
                label = statement;
            }
            statements.add(Activator.getService().getProcessModelFactory().createDecisionStatement(label, statement, (long)id.getIndex()));
        }
        this.wizardData.setDecisionStatements(statements);
        return super.getNextPage();
    }
}

