/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.extensions.xorsupport.ui;

import de.aristaflow.adept2.extensions.xorsupport.core.codegen.defaultimplementation.DefaultCodeGenerator;
import de.aristaflow.adept2.extensions.xorsupport.core.dynamic.defaultimplementation.DefaultBranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.BranchTreeManager;
import de.aristaflow.adept2.extensions.xorsupport.model.dynamic.Variable;
import de.aristaflow.adept2.extensions.xorsupport.model.meta.DataType;
import de.aristaflow.adept2.extensions.xorsupport.ui.Activator;
import de.aristaflow.adept2.extensions.xorsupport.ui.AssignBranchesWizardPage;
import de.aristaflow.adept2.extensions.xorsupport.ui.AssignEdgesWizardPage;
import de.aristaflow.adept2.extensions.xorsupport.ui.LeftHandSideWizardPage;
import de.aristaflow.adept2.extensions.xorsupport.ui.PredicatesWizardPage;
import de.aristaflow.adept2.extensions.xorsupport.ui.SummaryPage;
import de.aristaflow.adept2.extensions.xorsupport.util.ByteArrayEncoder;
import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.ExecutableComponentWizard;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.ActivityPnPWizardData;
import de.aristaflow.adept2.ui.processediting.wizards.pnp.data.PnPWizardChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class XORWizard
extends ExecutableComponentWizard {
    protected BranchTreeManager treeManager;
    protected AssignEdgesWizardPage assignEdgesPage;

    public void changeNotify(PnPWizardChangeListener.PnPWizardChangeType type, Object affectedObject) {
        ProcessModelParameter param;
        if (type == PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_ADDED || type == PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_CHANGED) {
            param = type == PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_ADDED ? (ProcessModelParameter)affectedObject : ((ProcessModelParameter[])affectedObject)[1];
            String newParamName = param.getName();
            if ((Character.toLowerCase((newParamName = newParamName.replaceAll("[^0-9a-zA-Z_]", "")).charAt(0)) < 'a' || Character.toLowerCase(newParamName.charAt(0)) > 'z') && newParamName.charAt(0) != '_') {
                newParamName = "_" + newParamName;
            }
            if (newParamName.length() == 0) {
                newParamName = "_";
            }
            if (!param.getName().equals(newParamName)) {
                int i = 1;
                while (true) {
                    String testName = i == 1 ? newParamName : String.valueOf(newParamName) + i;
                    boolean inUse = false;
                    for (ProcessModelParameter testParam : this.getData().getParameters(ActivityConstants.AccessType.READ)) {
                        if (!testParam.getName().equals(testName)) continue;
                        inUse = true;
                        break;
                    }
                    if (!inUse) {
                        newParamName = testName;
                        break;
                    }
                    ++i;
                }
            }
            if (!param.getName().equals(newParamName)) {
                final ProcessModelParameter newParam = Activator.getService().getProcessModelFactory().createProcessModelParameter(newParamName, param.getDescription(), param.getDataType(), param.getUDTName(), param.getIdentifierID(), param.isOptional(), param.isVirtual(), param.isFailure(), param.getDefaultValue(), param.getConfiguration(), (PluginDataContainer)param, param.getUserAttributes());
                final String newParamNameTemp = newParamName;
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        XORWizard.this.getData().changeParameter(param, newParam, ActivityConstants.AccessType.READ);
                        String msg = "The parameter name '%s' contained characters that aren't allowed in the context of XOR and was therefore changed to '%s' instead.\n\nA legal parameter name starts with the letter a - z or _ (underscore) followed by an arbitrary number of the following: a - z, 0 - 9, _ (underscore). Letters are allowed in upper and lower case.";
                        msg = String.format(msg, param.getName(), newParamNameTemp);
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Illegal Characters in Parameter Name", (String)msg);
                    }
                });
                if (type.equals((Object)PnPWizardChangeListener.PnPWizardChangeType.READ_PARAMETER_CHANGED)) {
                    Variable var = (Variable)this.treeManager.getVariables().getKnownVariables().get(((ProcessModelParameter[])affectedObject)[0].getName());
                    this.treeManager.getVariables().removeVariable(var);
                }
                return;
            }
        }
        switch (type) {
            case READ_PARAMETER_ADDED: {
                param = (ProcessModelParameter)affectedObject;
                this.treeManager.getVariables().addVariable(param.getName(), DataType.getDataTypeFromAdeptDataType((ProcessConstants.AdeptDataType)param.getDataType(), (String)param.getUDTName()), param.isOptional());
                break;
            }
            case READ_PARAMETER_REMOVED: {
                Variable var = (Variable)this.treeManager.getVariables().getKnownVariables().get(((ProcessModelParameter)affectedObject).getName());
                if (var == null) break;
                this.treeManager.getVariables().removeVariable(var);
                break;
            }
            case READ_PARAMETER_CHANGED: {
                ProcessModelParameter[] params = (ProcessModelParameter[])affectedObject;
                Variable var = (Variable)this.treeManager.getVariables().getKnownVariables().get(params[0].getName());
                ProcessModelParameter param2 = params[1];
                DataType newDataType = DataType.getDataTypeFromAdeptDataType((ProcessConstants.AdeptDataType)param2.getDataType(), (String)param2.getUDTName());
                if (var == null) {
                    this.treeManager.getVariables().addVariable(param2.getName(), newDataType, param2.isOptional());
                    break;
                }
                if (!newDataType.equals(var.getDataType()) || param2.isOptional() != var.canBeNull()) {
                    this.treeManager.getVariables().removeVariable(var);
                    this.treeManager.getVariables().addVariable(param2.getName(), newDataType, param2.isOptional());
                    break;
                }
                var.setName(param2.getName());
            }
        }
    }

    public void init(ActivityPnPWizardData data) {
        super.init(data);
        this.treeManager = new DefaultBranchTreeManager((DecisionActivity)data.getOriginalEBP(), data.getNodeData().getNode(), data.getNodeData().getProcessTemplate());
        this.addPage((IWizardPage)new LeftHandSideWizardPage(this.treeManager));
        this.addPage((IWizardPage)new PredicatesWizardPage(this.treeManager));
        this.addPage((IWizardPage)new AssignBranchesWizardPage(this.treeManager));
        this.addPage((IWizardPage)new SummaryPage(this.treeManager, data));
        this.assignEdgesPage = new AssignEdgesWizardPage(data);
        this.addPage((IWizardPage)this.assignEdgesPage);
    }

    public void performFinish() {
        try {
            this.assignEdgesPage.saveChanges();
            ChangeableActivityConfiguration activityTypeConfig = this.getData().getConfiguration();
            StringWriter outXML = new StringWriter();
            this.treeManager.serializeToXML((Writer)outXML, false, false);
            activityTypeConfig.setString("DECISION_XML", outXML.toString());
            DefaultCodeGenerator gen = new DefaultCodeGenerator();
            gen.writeEvaluateLeftHandSide(this.treeManager.getExpressionList());
            gen.writeEvaluateDecisionID(this.treeManager);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            gen.finalizeClass((OutputStream)out);
            out.close();
            activityTypeConfig.setString("DECISION_BYTECODE", ByteArrayEncoder.encodeBytes((byte[])out.toByteArray()));
        }
        catch (Exception ex) {
            MessageDialog.openError((Shell)this.assignEdgesPage.getShell(), (String)"Error", (String)("An error occured:\n " + ex.toString()));
        }
    }
}

