/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser;

import de.aristaflow.adept2.ui.processediting.Editor;
import de.aristaflow.adept2.ui.processediting.editorinputs.TemplateInput;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.processrepositorybrowser.RepositoryTemplateInput;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISaveablePart2;

public class RepositoryTemplateEditor
extends Editor
implements ISaveablePart2 {
    public static final String ID = String.valueOf(Activator.getPluginID()) + ".RepositoryTemplateEditor";
    protected static final String TITLE = "Save resource";
    protected static final String MESSAGE = "'%s' has changed, save resource?";
    protected static final String[] LABELS = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
    private static final int DEFAULT = 0;

    public void setInput(IEditorInput input) {
        if (!(input instanceof RepositoryTemplateInput)) {
            throw new RuntimeException("This editor may only be used with the Repository Template Input");
        }
        super.setInput(input);
    }

    public void doSave(IProgressMonitor monitor) {
        RepositoryTemplateInput input = (RepositoryTemplateInput)this.getEditorInput();
        try {
            input.doSave(this.getTemplate(), this.getTemplateStatus(), monitor);
            TemplateInput.Holder holder = input.load();
            this.getGraphicalViewer().setContents((Object)holder.template);
            this.performChecks();
            this.setLocalDirty(false);
        }
        catch (Exception ex) {
            String msg = "Error while trying to save template to the process repository!";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)ex);
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        if (this.getEditorInput() != null) {
            ((RepositoryTemplateInput)this.getEditorInput()).unlock();
        }
        super.dispose();
    }

    protected class CheckInDialogue
    extends MessageDialog {
        public CheckInDialogue() {
            super(RepositoryTemplateEditor.this.getSite().getShell(), RepositoryTemplateEditor.TITLE, null, String.format(RepositoryTemplateEditor.MESSAGE, RepositoryTemplateEditor.this.getTemplate().getName()), 3, LABELS, 0);
        }

        protected Control createCustomArea(Composite parent) {
            return super.createCustomArea(parent);
        }
    }
}

