/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateDeltaLayer;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.ui.processediting.Activator;
import de.aristaflow.adept2.ui.processediting.editorinputs.TemplateInput;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;

public class RepositoryTemplateInput
extends TemplateInput {
    private final ProcessRepository repository;
    private UUID templateID;
    private boolean deriveChildTemplate;
    private TemplateInput.Holder template;
    private List<TemplateChangeListener> templateChangeListener = new ArrayList<TemplateChangeListener>();

    public RepositoryTemplateInput(ProcessRepository repository, UUID templateID, boolean deriveChildTemplate) {
        ArgChecks.checkForNull((Object)repository, (String)"repository");
        ArgChecks.checkForNull((Object)templateID, (String)"templateID");
        this.repository = repository;
        this.templateID = templateID;
        this.deriveChildTemplate = deriveChildTemplate;
    }

    public String getName() {
        return "Process Template " + this.templateID.toString();
    }

    public String getToolTipText() {
        return this.getName();
    }

    public void addTemplateChangeListener(TemplateChangeListener listener) {
        this.templateChangeListener.add(listener);
    }

    public void removeTemplateChangeListener(TemplateChangeListener listener) {
        this.templateChangeListener.remove(listener);
    }

    public TemplateInput.Holder load() throws InvalidTemplateStateException, LockException, Exception {
        try {
            if (this.template == null) {
                ChangeableTemplate template;
                SessionToken session = Activator.getService().getSessionToken();
                if (this.deriveChildTemplate) {
                    template = this.repository.getTemplateManager().deriveNewChildTemplate(session, this.templateID);
                    this.templateID = template.getID();
                    this.deriveChildTemplate = false;
                    this.repository.getTemplateManager().validateTemplate(session, template.getID());
                } else {
                    template = this.repository.getTemplateManager().getAndLockTemplate(session, this.templateID);
                }
                this.template = new TemplateInput.Holder((Template)template, null);
            }
            return this.template;
        }
        catch (LockException ex) {
            String msg;
            if (ex.getLockOwner() instanceof QualifiedAgent) {
                QualifiedAgent agent = (QualifiedAgent)ex.getLockOwner();
                msg = this.deriveChildTemplate ? "The new child template could not be derived because the source template is currently locked by user '%s'." : "Could not lock the template in order to open it. It is currently locked by user '%s'.";
                msg = String.format(msg, agent.getAgentUserName());
            } else {
                msg = this.deriveChildTemplate ? "The new child template could not be derived because the source template is currently locked by someone else." : "Could not lock the template in order to open it. It is currently locked by someone else.";
            }
            throw new Exception(msg, ex);
        }
    }

    public boolean isSaveAllowed() {
        return true;
    }

    public TemplateInput.Holder doSave(Template template, TemplateStatus templateStatus, IProgressMonitor monitor) throws Exception {
        SessionToken session = Activator.getService().getSessionToken();
        Document history = null;
        TemplateDeltaLayer structuralChanges = null;
        CheckReport report = this.repository.getTemplateManager().storeTemplate(session, template, true, history, structuralChanges);
        if (report.getCheckResult() != CheckReport.ResultType.OK && report.getCheckResult() != CheckReport.ResultType.INFO) {
            this.repository.getTemplateManager().storeTemplate(session, template, false, history, structuralChanges);
        }
        for (TemplateChangeListener listener : this.templateChangeListener) {
            listener.templateSaved(template);
        }
        return this.template;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RepositoryTemplateInput) || obj == null) {
            return false;
        }
        RepositoryTemplateInput other = (RepositoryTemplateInput)((Object)obj);
        return this.templateID.equals(other.templateID) && this.deriveChildTemplate == other.deriveChildTemplate;
    }

    public void unlock() {
        if (this.template == null) {
            return;
        }
        SessionToken session = Activator.getService().getSessionToken();
        try {
            this.repository.getTemplateManager().unlockTemplate(session, this.templateID);
        }
        catch (LockException e) {
            String message = "Could not unlock template while dismissing changes.";
            LoggerTools.getLogger((Object)((Object)this)).log(Level.INFO, message, e);
        }
        this.template = null;
        this.deriveChildTemplate = false;
    }

    public void dispose() throws InvalidTemplateStateException {
        this.unlock();
    }

    public static interface TemplateChangeListener {
        public void templateSaved(Template var1);
    }
}

