/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.ui.processediting.AbstractTemplateStatusInput;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.LockException;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;

public class RepositoryTemplateStatusInput
extends AbstractTemplateStatusInput {
    private final ProcessRepository repository;
    private TemplateStatus status;

    public RepositoryTemplateStatusInput(ProcessRepository repository, TemplateProxy proxy) throws LockException {
        this.repository = repository;
        SessionToken session = this.getToken();
        this.status = repository.getTemplateManager().getAndLockTemplateStatus(session, proxy.getID());
        this.init(this.status, proxy.getName());
    }

    public void doSave(IProgressMonitor monitor) throws LockException, InvalidTemplateStateException {
        SessionToken session = this.getToken();
        UUID templateID = this.templateStatus.getTemplateID();
        this.repository.getTemplateManager().getAndLockTemplateStatus(session, templateID);
        try {
            this.repository.getTemplateManager().setTemplateStatus(session, this.templateStatus);
        }
        finally {
            this.repository.getTemplateManager().unlockTemplateStatus(session, templateID);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RepositoryTemplateStatusInput) || obj == null) {
            return false;
        }
        RepositoryTemplateStatusInput other = (RepositoryTemplateStatusInput)((Object)obj);
        if (this.templateStatus == null ^ other.templateStatus == null) {
            return false;
        }
        if (this.templateStatus == null && other.templateStatus == null) {
            return true;
        }
        return this.templateStatus.getTemplateID().equals(other.templateStatus.getTemplateID());
    }

    public void unlock() {
        if (this.templateStatus == null) {
            return;
        }
        try {
            this.repository.getTemplateManager().unlockTemplateStatus(this.getToken(), this.templateStatus.getTemplateID());
            this.templateStatus = null;
        }
        catch (LockException e) {
            String message = "LockException while unlocking TemplateStatus!";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
        }
    }

    public void finalize() {
        this.unlock();
    }

    private SessionToken getToken() {
        return Activator.getService().getSessionToken();
    }

    public boolean exists() {
        return false;
    }
}

