/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.actions;

import de.aristaflow.adept2.core.client.AdministrationService;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.processrepositorybrowser.actions.AbstractTemplateProxyAction;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.LockException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.action.IAction;

public class DeployAction
extends AbstractTemplateProxyAction {
    @Override
    protected void selectionChanged(IAction action, TemplateProxy proxy) {
        Object[] currentPMURIs = Activator.getService().getProcessManager().getURIs();
        boolean isDeployed = false;
        for (Object[] uriIsDeployed : proxy.getDeployedProcessManagers()) {
            if (isDeployed |= Arrays.equals(uriIsDeployed, currentPMURIs)) break;
        }
        action.setEnabled(proxy.getBuildtimeState() == ProcessConstants.TemplateBuildtimeState.RELEASED && !isDeployed);
    }

    public void run(IAction action) {
        AdministrationService service = Activator.getService();
        HashSet<URI[]> processManagerURIs = new HashSet<URI[]>(1);
        processManagerURIs.add(service.getProcessManager().getURIs());
        try {
            this.getRepository().getTemplateManager().deployProcessTemplate(service.getSessionToken(), this.getSelection().getID(), processManagerURIs);
        }
        catch (InvalidTemplateStateException e) {
            String message = "The server side template state did not allow for deployment";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
        }
        catch (LockException e) {
            String message = "Could not lock template during deploy process!";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
        }
        this.view.update();
    }
}

