/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.actions;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.ui.processrepositorybrowser.RepositoryTemplateStatusEditor;
import de.aristaflow.adept2.ui.processrepositorybrowser.RepositoryTemplateStatusInput;
import de.aristaflow.adept2.ui.processrepositorybrowser.actions.AbstractTemplateProxyAction;
import de.aristaflow.adept2.ui.processvisualisation.Activator;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.LockException;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;

public class EditStatusAction
extends AbstractTemplateProxyAction {
    @Override
    protected void selectionChanged(IAction action, TemplateProxy proxy) {
        if (proxy.getBuildtimeState() == ProcessConstants.TemplateBuildtimeState.RELEASED) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    public void run(IAction action) {
        RepositoryTemplateStatusInput input;
        try {
            input = new RepositoryTemplateStatusInput(this.getRepository(), this.getSelection());
        }
        catch (LockException e) {
            String message = "Could not lock Template Status!";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
            return;
        }
        try {
            this.view.getSite().getWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, RepositoryTemplateStatusEditor.ID);
        }
        catch (PartInitException e) {
            String message = "PartInitException while opening editor.";
            StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
        }
    }
}

