/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.actions;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.model.processmodel.TemplateStatus;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLExport;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.processrepositorybrowser.actions.AbstractTemplateProxyAction;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;

public class ExportAction
extends AbstractTemplateProxyAction {
    @Override
    protected void selectionChanged(IAction action, TemplateProxy proxy) {
        action.setEnabled(true);
    }

    public void run(IAction action) {
        FileDialog dialogue = new FileDialog(this.view.getSite().getShell());
        dialogue.setFilterExtensions(new String[]{"*.template"});
        dialogue.setFilterNames(new String[]{"AristaFlow Process Template (.template)"});
        String fileString = dialogue.open();
        if (fileString != null) {
            Template template;
            TemplateStatus templateStatus;
            File file;
            if (!fileString.endsWith(".template")) {
                fileString = String.valueOf(fileString) + ".template";
            }
            if ((file = new File(fileString)).exists()) {
                String title = "Overwrite File?";
                String message = String.format("File '%s' exists, overwrite it?", file.getAbsoluteFile());
                MessageDialog messageDialog = new MessageDialog(this.view.getSite().getShell(), title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                if (messageDialog.open() != 0) {
                    return;
                }
            }
            try {
                UUID id = this.getSelection().getID();
                SessionToken session = Activator.getService().getSessionToken();
                templateStatus = this.getRepository().getTemplateManager().getAndLockTemplateStatus(session, id);
                template = this.getRepository().getTemplateManager().getTemplate(session, id);
                this.getRepository().getTemplateManager().unlockTemplateStatus(session, id);
            }
            catch (LockException e) {
                String msg = "LockException while exporting!";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)msg, (Throwable)e);
                return;
            }
            ProcessModelXMLExport xmlExport = new ProcessModelXMLExport();
            Throwable ex = null;
            try {
                xmlExport.writeTemplateAndStatusToFile(template, templateStatus, file);
            }
            catch (IOException e) {
                ex = e;
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)"Failed exporting to file:", (Throwable)ex);
            }
            catch (XMLFormatException e) {
                ex = e;
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)"Failed exporting to file:", (Throwable)ex);
            }
        }
    }
}

