/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.actions;

import de.aristaflow.adept2.core.client.AdministrationService;
import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.processrepositorybrowser.actions.AbstractProcessRepositoryViewAction;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FindActivityAction
extends AbstractProcessRepositoryViewAction {
    public void run(IAction action) {
        InputBox inBox = new InputBox(this.view.getSite().getShell(), 4);
        inBox.setMessage("Please enter the UUID of the activity template to find.");
        String uuid = inBox.open();
        if (uuid == null) {
            return;
        }
        AdministrationService service = Activator.getService();
        UUID uuidToFind = UUID.fromString(uuid);
        ProcessRepository procRep = service.getProcessRepository();
        Set result = procRep.findUsageOfActivityTemplate(service.getSessionToken(), uuidToFind);
        StringBuilder out = new StringBuilder();
        out.append("Processes containing activity ").append(uuidToFind).append(":\n\n");
        for (TemplateProxy proxy : result) {
            out.append(proxy.getName()).append(": ").append(proxy.getDescription()).append(" (").append(proxy.getID()).append(")\n");
        }
        MessageBox msgBox = new MessageBox(this.view.getSite().getShell());
        msgBox.setMessage(out.toString());
        msgBox.open();
    }

    public static class InputBox
    extends Dialog {
        Shell shell;
        private Label label;
        private String message;
        String result;

        public InputBox(Shell parent, int style) {
            super(parent, InputBox.checkStyle(style));
            this.shell = new Shell(parent, 0x860 | InputBox.checkStyle(style));
            this.shell.setText(this.getText());
            this.shell.setLayout((Layout)new GridLayout(2, false));
            new Label((Composite)this.shell, 0x1000000).setImage(this.shell.getDisplay().getSystemImage(InputBox.checkImageStyle(style)));
            Composite body = new Composite((Composite)this.shell, 0);
            GridData data0 = new GridData();
            data0.grabExcessHorizontalSpace = true;
            data0.grabExcessVerticalSpace = true;
            data0.horizontalAlignment = 4;
            data0.verticalAlignment = 4;
            body.setLayoutData((Object)data0);
            body.setLayout((Layout)new GridLayout());
            this.label = new Label(body, 16384);
            GridData data1 = new GridData();
            data1.grabExcessHorizontalSpace = true;
            data1.grabExcessVerticalSpace = true;
            data1.horizontalAlignment = 4;
            data1.verticalAlignment = 4;
            this.label.setLayoutData((Object)data1);
            final Text text = new Text(body, 2052);
            GridData data2 = new GridData();
            data2.grabExcessHorizontalSpace = true;
            data2.horizontalAlignment = 4;
            text.setLayoutData((Object)data2);
            Composite footer = new Composite((Composite)this.shell, 0);
            GridData data3 = new GridData();
            data3.grabExcessHorizontalSpace = true;
            data3.horizontalAlignment = 4;
            data3.horizontalSpan = 2;
            footer.setLayoutData((Object)data3);
            RowLayout layout = new RowLayout();
            layout.justify = true;
            layout.fill = true;
            footer.setLayout((Layout)layout);
            Button cancel = new Button(footer, 8);
            cancel.setText("  Cancel  ");
            cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputBox.this.shell.dispose();
                }
            });
            Button ok = new Button(footer, 8);
            ok.setText("    OK    ");
            ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputBox.this.result = text.getText();
                    InputBox.this.shell.dispose();
                }
            });
            this.shell.setDefaultButton(ok);
        }

        protected static int checkStyle(int style) {
            if ((style & 0x20000) == 131072) {
                return 131072;
            }
            if ((style & 0x8000) == 32768) {
                return 32768;
            }
            if ((style & 0x10000) == 65536) {
                return 65536;
            }
            return 65536;
        }

        protected static int checkImageStyle(int style) {
            if ((style & 1) == 1) {
                return 1;
            }
            if ((style & 2) == 2) {
                return 2;
            }
            if ((style & 4) == 4) {
                return 4;
            }
            if ((style & 8) == 8) {
                return 8;
            }
            if ((style & 0x10) == 16) {
                return 16;
            }
            return 0;
        }

        public void setText(String string) {
            super.setText(string);
            this.shell.setText(string);
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            if (message == null) {
                SWT.error((int)4);
            }
            this.message = message;
            this.label.setText(message);
        }

        public String open() {
            this.shell.pack();
            this.shell.open();
            this.shell.layout();
            while (!this.shell.isDisposed()) {
                if (this.shell.getDisplay().readAndDispatch()) continue;
                this.shell.getDisplay().sleep();
            }
            return this.result;
        }
    }
}

