/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.actions;

import de.aristaflow.adept2.core.client.AdministrationService;
import de.aristaflow.adept2.core.processrepository.ProcessRepository;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.processrepositorybrowser.actions.AbstractProcessRepositoryViewAction;
import de.aristaflow.adept2.ui.processrepositorybrowser.actions.FindActivityAction;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.MessageBox;

public class FindSubprocessAction
extends AbstractProcessRepositoryViewAction {
    public void run(IAction action) {
        FindActivityAction.InputBox inBox = new FindActivityAction.InputBox(this.view.getSite().getShell(), 4);
        inBox.setMessage("Please enter the UUID of the sub process to find.");
        String uuid = inBox.open();
        if (uuid == null) {
            return;
        }
        AdministrationService service = Activator.getService();
        UUID uuidToFind = UUID.fromString(uuid);
        ProcessRepository procRep = service.getProcessRepository();
        Set result = procRep.findUsageOfProcessTemplate(service.getSessionToken(), uuidToFind);
        StringBuilder out = new StringBuilder();
        out.append("Processes containing sub process ").append(uuidToFind).append(":\n\n");
        for (TemplateProxy proxy : result) {
            out.append(proxy.getName()).append(": ").append(proxy.getDescription()).append(" (").append(proxy.getID()).append(")\n");
        }
        MessageBox msgBox = new MessageBox(this.view.getSite().getShell());
        msgBox.setMessage(out.toString());
        msgBox.open();
    }
}

