/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.ui.processrepositorybrowser.actions;

import de.aristaflow.adept2.core.processrepository.ProcessTemplateManager;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.InvalidTemplateStateException;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.TemplateProxy;
import de.aristaflow.adept2.model.processmodel.xml.ProcessModelXMLImport;
import de.aristaflow.adept2.ui.processrepositorybrowser.Activator;
import de.aristaflow.adept2.ui.processrepositorybrowser.actions.AbstractTemplateProxyAction;
import de.aristaflow.adept2.ui.statushandling.StatusTools;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LockException;
import de.aristaflow.adept2.util.xml.VersionException;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.FileDialog;

public class ImportAsChildAction
extends AbstractTemplateProxyAction {
    private String lastSelectedPath;

    @Override
    protected void selectionChanged(IAction action, TemplateProxy proxy) {
        action.setEnabled(proxy != null && proxy.getBuildtimeState() == ProcessConstants.TemplateBuildtimeState.RELEASED && proxy.isDerivable());
    }

    public void run(IAction action) {
        FileDialog fd = new FileDialog(this.view.getSite().getShell());
        fd.setFilterPath(this.lastSelectedPath);
        fd.setFilterExtensions(new String[]{"*.template"});
        fd.setFilterNames(new String[]{"AristaFlow Process Template (.template)"});
        String fileString = fd.open();
        if (fileString != null) {
            ChangeableTemplate template;
            File templateFile = new File(fileString);
            this.lastSelectedPath = templateFile.getParent();
            ProcessModelFactory pmf = Activator.getService().getProcessModelFactory();
            pmf.setCreateChangeable(true);
            ProcessModelXMLImport xmlImport = new ProcessModelXMLImport(pmf);
            try {
                template = (ChangeableTemplate)xmlImport.getTemplateFromFile(templateFile);
            }
            catch (VersionException e) {
                String message = "The XML file format version is not compatible.";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
                return;
            }
            catch (XMLFormatException e) {
                String message = "The file does not fit to the XML format.";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
                return;
            }
            catch (IOException e) {
                String message = "Could not read the file.";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
                return;
            }
            ProcessTemplateManager templateManager = this.getRepository().getTemplateManager();
            try {
                ChangeableTemplate newChild = templateManager.deriveNewChildTemplate(Activator.getService().getSessionToken(), this.getSelection().getID());
                template.updateID(newChild.getID());
                for (Map.Entry entry : newChild.getUserAttributes().entrySet()) {
                    template.setUserAttributeValue((String)entry.getKey(), (String)entry.getValue());
                }
                CheckReport report = templateManager.storeTemplate(Activator.getService().getSessionToken(), (Template)template, true, null, null);
                if (report.getCheckResult() != CheckReport.ResultType.OK && report.getCheckResult() != CheckReport.ResultType.INFO) {
                    templateManager.storeTemplate(Activator.getService().getSessionToken(), (Template)template, false, null, null);
                }
                templateManager.unlockTemplate(Activator.getService().getSessionToken(), template.getID());
            }
            catch (InvalidTemplateStateException e) {
                String message = "Could not derive a new child or check-in the new template. There is an invalid state for one of the templates. Does the parent allow for derivation?";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
            }
            catch (LockException e) {
                String message = "Could not derive a new child or check-in the new template due to a LockException.";
                StatusTools.handleErrorStatus((String)Activator.getPluginID(), (String)message, (Throwable)e);
            }
            this.view.update();
        }
    }
}

